#!/usr/bin/perl
################################################################################
################################################################################
##                                                                            ##
##               ALVISION_ONE -- Alignment Tool Single version.               ##
##                                                                            ##
################################################################################
################################################################################
#
### ALVISION_ONE.pl ###
##
# Created by N.Hatano (Last renewal date : 2005.11.22).
#
# 03/09/08: ver1.0
# 03/09/11: ver1.1
# 03/09/25: ver1.2
# 03/10/01: ver1.3
# 03/10/20: ver1.3.1 Bug fix.
# 03/10/22: ver1.3.2 Bug fix.
# 04/01/21: ver1.3.3 Bug fix.
# 04/05/13: ver1.3.3a yʸرݒǉz.
# 05/02/09: ver1.3.3b Bug fix(encode).
# 05/11/22: ver1.3.3c Bug fix.
#

$| = 1;

use Tk;
use encoding "cp932";
use Cwd;
use File::Basename;
use OLE;
#use PDFJ 'SJIS';

## /* Message Label */ ##
$msg = "";
## /* Procedure Pattern */ ##
$blast_pattern='n';
## /* Expect Value */ ##
$entry_of_expect_value="";
## /* Query ID */ ##
$entry_of_query="";
## /* Sbjct ID */ ##
$entry_of_sbjct="";
## /* Scale of Expect-value */ ##
$blastn_scale_value=50;
$blastp_scale_value=50;
## /* Value of Query-Test-Area */ ##
$query_value="";
## /* Value of Sbjct-Test-Area */ ##
$sbjct_value="";
## /* dir_name */ ##
$dir = Cwd::getcwd();
## /* blast_output_file_name */ ##
$blast_output = $dir . "/blast_output.txt";
## /* for ORF amino output */ ##
$amino_mode="OFF";
@OrfCode=();
$query_IN="";
$query_EN="";
$sbjct_IN="";
$sbjct_EN="";
## /* PDF make mode */ ##
$PDF_mode="OFF";

################################################################################
## Alignment main procedure use.                                              ##
################################################################################
#
## /*---- INIT OPTION ----*/ ##
my($work_dir);
my($input_file);
my($bl2seq_cmd_path);
my($pdf_converter);
my($pdf_cnv_cmd_path);
my($comp_value);
my($comp_value_n);
my($comp_value_p);
my($expect_value);
my($blast_mode);
my($align_ss_fasta_mode);
my($error_file);
my($error_count);
## /*---- ERROR COUNT ----*/ ##
$error_count = 0;
## /*---- Blast & Query & Sbjct File INFO ----*/ ##
my($blast_out_file_path);
my($query_fasta_file_path);
my($sbjct_fasta_file_path);
## /*---- OUTPUT File INFO ----*/ ##
my($output_file_path);
## /*---- OUTPUT PDF File INFO ----*/ ##
my($output_pdf_path);
## /*---- Query Split Fasta MODE ----*/ ##
$align_ss_fasta_mode = 0;
## /*---- OUTPUT ORF-AMINO INFO ----*/ ##
my($output_amino_path);
#
#
# Main Window
$mw = MainWindow->new;
$mw->optionAdd('*font' => 'Terminal 11');
$mw->resizable(0,0);
$mw->title("ALVISION_ONE");
#
# Frame
$f0 = $mw->Frame();
$f1 = $mw->Frame();
$f2 = $mw->Frame();
$f3 = $mw->Frame();
$f4 = $mw->Frame();
$f5 = $mw->Frame();
$f6 = $mw->Frame();
#
# BLAST Pattern select
$f0->Label(-text   => 'BLAST', -anchor => 'e')
    ->pack(-side => 'left');

$rad1 = $f0->Radiobutton(-text     => 'blastn', -value    => 'blastn',
			 -variable => \$proc_pattern, -command  => \&GetPattern)
		  ->pack(-side => 'left');

$rad2 = $f0->Radiobutton(-text     => 'blastp', -value    => 'blastp',
			 -variable => \$proc_pattern, -command  => \&GetPattern)
		  ->pack(-side => 'left');
$rad1->select();

# Expect Label & Entry
$query_label = $f0->Label(-text => 'Ғl(F1e-03 or 0.001)', -anchor => 'e')
		   ->pack(-side => 'left', -padx => 15);
#
$ent_expect = $f0->Entry(-width => 12, -background => 'white')
		  ->pack(-side => 'left');

# Comp Value Button
$cv_btn = $f0->Button(-text => "dx", -command => \&Comp_value_chg, -width => 10)
	       ->pack(-side => 'right');
#
# Query Label & Entry
$query_label = $f1->Label(-text => 'Query', -anchor => 'e')
		   ->pack(-side => 'left');
#
$ent_query = $f1->Entry(-width => 24, -background => 'white')
		 ->pack(-side => 'left');
#
# Query Start Codon
$query_IN_label = $f1->Label(-text => 'IN', -anchor => 'e')
			     ->pack(-side => 'left');
#
$ent_query_IN = $f1->Entry(-width => 12, -background => 'white')
			   ->pack(-side => 'left');
#
# Query Stop Codon
$query_EN_label = $f1->Label(-text => 'EN', -anchor => 'e')
			     ->pack(-side => 'left');
#
$ent_query_EN = $f1->Entry(-width => 12, -background => 'white')
			   ->pack(-side => 'left');
# 2004.05.13 add start.
$cl_q_btn = $f1->Button(-text => "ر", -command => \&query_text_clear, -width => 5)
		 ->pack(-side => 'left', -padx => 5);
# 2004.05.13 add end.

#
# PDF Option Check-Button
$pdf_chk_btn = $f1->Checkbutton(-text => "PDFŏo", -variable => \$pdf_chk_value,
				-onvalue => "ON", -offvalue => "OFF", -command => \&pdf_chk_btn_chg)
			->pack(-side => right);
$pdf_chk_btn->deselect;
#
# Query Scroll Text Area
$yscrl = $f2->Scrollbar();

$query_txt = $f2->Text(-background     => 'white',
		       -width          => 100,
		       -height         => 10,
		       -wrap           => 'char',
		       -yscrollcommand => ['set', $yscrl ]);

$yscrl->configure(-command => ['yview', $query_txt ]);
#
$yscrl->pack(-side => 'right',  -fill => 'y');
$query_txt->pack(-padx => 5, -pady => 3, -side => 'bottom', -fill => 'both', -expand => 'yes');
#
# Sbjct Label & Entry
$sbjct_label = $f3->Label(-text => 'Sbjct', -anchor => 'e')
		   ->pack(-side => 'left');
#
$ent_sbjct = $f3->Entry(-width => 24, -background => 'white')
		 ->pack(-side => 'left');
#
# Sbjct Start Codon
$sbjct_IN_label = $f3->Label(-text => 'IN', -anchor => 'e')
			     ->pack(-side => 'left');
#
$ent_sbjct_IN = $f3->Entry(-width => 12, -background => 'white')
			   ->pack(-side => 'left');
#
# Sbjct Stop Codon
$sbjct_EN_label = $f3->Label(-text => 'EN', -anchor => 'e')
			     ->pack(-side => 'left');
#
$ent_sbjct_EN = $f3->Entry(-width => 12, -background => 'white')
			   ->pack(-side => 'left');
# 2004.05.13 add start.
$cl_s_btn = $f3->Button(-text => "ر", -command => \&sbjct_text_clear, -width => 5)
		 ->pack(-side => 'left', -padx => 5);
# 2004.05.13 add end.
#
# Sbjct Scroll Text Area
$yscrl2 = $f4->Scrollbar();

$sbjct_txt = $f4->Text(-background     => 'white',
		       -width          => 100,
		       -height         => 10,
		       -wrap           => 'char',
		       -yscrollcommand => ['set', $yscrl2 ]);

$yscrl2->configure(-command => ['yview', $sbjct_txt ]);
#
$yscrl2->pack(-side => 'right',  -fill => 'y');
$sbjct_txt->pack(-padx => 5, -pady => 3, -side => 'bottom', -fill => 'both', -expand => 'yes');
#
# Exec Button & Exit Button
$exec_btn = $f5->Button(-text => "s", -command => \&Execute_push, -width => 12)
		 ->pack(-side => 'left');

$query_btn = $f5->Button(-text => "BLASŢ", -command => \&Query_push, -width => 12)
		  ->pack(-side => 'left', -padx => 3);

$exit_btn = $f5->Button(-text => "I", -command => \&Exit_push, -width => 12)
		 ->pack(-side => 'right');

$clear_btn = $f5->Button(-text => "ر", -command => \&Clear_push, -width => 12)
		  ->pack(-side => 'right', -padx => 3);

#
# Message Label
$MSG = $f6->Label(-textvariable => \$msg, -relief => 'sunken')
	   ->pack(-fill         => 'both');
#
$f0->pack(-padx => 5, -pady => 3, -fill => 'both', -expand => 'yes');
$f1->pack(-padx => 5, -pady => 3, -fill => 'both', -expand => 'yes');
$f2->pack(-padx => 5, -pady => 3, -fill => 'both', -expand => 'yes');
$f3->pack(-padx => 5, -pady => 3, -fill => 'both', -expand => 'yes');
$f4->pack(-padx => 5, -pady => 3, -fill => 'both', -expand => 'yes');
$f5->pack(-padx => 5, -pady => 3, -fill => 'both', -expand => 'yes');
$f6->pack(-padx => 5, -pady => 3, -fill => 'both', -expand => 'yes');
#
# MainLoop
MainLoop;
#
################################################################################
# s{^
################################################################################
sub Execute_push {

	my($reslut, $c) = ();
	my($pos, $i) = 0;

	$entry_of_expect_value	= $ent_expect->get;
	$entry_of_query		= $ent_query->get;
	$entry_of_sbjct		= $ent_sbjct->get;
	$query_value		= $query_txt->get('1.0', 'end');
	$sbjct_value		= $sbjct_txt->get('1.0', 'end');
	$query_IN		= $ent_query_IN->get;
	$query_EN		= $ent_query_EN->get;
	$sbjct_IN		= $ent_sbjct_IN->get;
	$sbjct_EN		= $ent_sbjct_EN->get;

	#* 2005.11.22 add start.
	$entry_of_query	= BgTrim($entry_of_query);
	$entry_of_sbjct	= BgTrim($entry_of_sbjct);
	$entry_of_query	= BgPerm($entry_of_query);
	$entry_of_sbjct	= BgPerm($entry_of_sbjct);
	#* 2005.11.22 add end.

	&init_option("ALVISION_ONE.ini");

	if($query_value =~ /^\n/ || $sbjct_value =~ /^\n/){
	    # ERROR
	    $mw->messageBox( -type => 'ok', -icon => 'warning', -title => 'ALVISION_ONE - Nothing Data',
			     -message => 'z񂪖͂łB' );
	    return;
	}

	$query_value = uc($query_value);
	$sbjct_value = uc($sbjct_value);

	chomp($query_value);
	chomp($sbjct_value);
	chomp($query_IN);
	chomp($query_EN);
	chomp($sbjct_IN);
	chomp($sbjct_EN);

	$query_value =~ s/\n//g;
	$sbjct_value =~ s/\n//g;

	for ($i=0; $i<length($query_value); $i++) {
	    $c = substr($query_value, $i, 1);
	    if ($proc_pattern eq "blastn") { # 2004.01.08 add 
		if ($c =~ /[^ATGCN\n]/) {
		    $pos = $i + 1;
		    $mw->messageBox( -type => 'ok', -icon => 'warning', -title => 'ALVISION_ONE - Error Data',
				     -message => 'zɖȏ񂪂܂BTYPE=[QUERY], POS=[' . $pos . '], DATA=[' . $c . ']');
		    return;
		}
	    }
	    elsif ($proc_pattern eq "blastp") { # 2004.01.08 add 
		if ($c =~ /[^a-zA-Z\n]/) { # 2004.01.08 add 
		    $pos = $i + 1;
		    $mw->messageBox( -type => 'ok', -icon => 'warning', -title => 'ALVISION_ONE - Error Data',
				     -message => 'zɖȏ񂪂܂BTYPE=[QUERY], POS=[' . $pos . '], DATA=[' . $c . ']');
		    return;
		}
	    }
	}
	for ($i=0; $i<length($sbjct_value); $i++) {
	    $c = substr($sbjct_value, $i, 1);
	    if ($proc_pattern eq "blastn") { # 2004.01.08 add 
		if ($c =~ /[^ATGCN\n]/) {
		    $pos = $i + 1;
		    $mw->messageBox( -type => 'ok', -icon => 'warning', -title => 'ALVISION_ONE - Error Data',
				     -message => 'zɖȏ񂪂܂BTYPE=[SBJCT], POS=[' . $pos . '], DATA=[' . $c . ']');
		    return;
		}
	    }
	    elsif ($proc_pattern eq "blastp") { # 2004.01.08 add 
		if ($c =~ /[^a-zA-Z\n]/) { # 2004.01.08 add 
		    $pos = $i + 1;
		    $mw->messageBox( -type => 'ok', -icon => 'warning', -title => 'ALVISION_ONE - Error Data',
				     -message => 'zɖȏ񂪂܂BTYPE=[SBJCT], POS=[' . $pos . '], DATA=[' . $c . ']');
		    return;
		}
	    }
	}

	if(length($query_value) < 11 || length($sbjct_value) < 11){
	    # ERROR
	    $kaigyou = "\n"; # 2005.02.22 add by hatano(bug).
	    $mw->messageBox( -type => 'ok', -icon => 'warning', -title => 'ALVISION_ONE - Length Error',
#			     -message => 'z11łB' . '\n' . '11ȏ͂ĂB' );
			     -message => 'z11łB' . $kaigyou . '11ȏ͂ĂB' ); # 2005.02.22 chg by hatano(bug).
	    return;
	}

	if($query_IN =~ /[^0-9]/ || $query_EN =~ /[^0-9]/){
	    # ERROR
	    $mw->messageBox( -type => 'ok', -icon => 'warning', -title => 'ALVISION_ONE - ORF IN/EN Error',
			     -message => 'QueryORFJn/IɐȊO̕񂪎w肳Ă܂B' );
	    return;
	}
	if($sbjct_IN =~ /[^0-9]/ || $sbjct_EN =~ /[^0-9]/){
	    # ERROR
	    $mw->messageBox( -type => 'ok', -icon => 'warning', -title => 'ALVISION_ONE - ORF IN/EN Error',
			     -message => 'SbjctORFJn/IɐȊO̕񂪎w肳Ă܂B' );
	    return;
	}

	# /* 2003.10.20 Bug taisaku start */
	if(-f $blast_out_file_path) {
	    unlink($blast_out_file_path);
	}
	# /* 2003.10.20 Bug taisaku end */

	$result = &align_main($dir, "TEXT", $entry_of_expect_value, 
			      $blastn_scale_value, $blastp_scale_value, "0", $blast_pattern,
			      $entry_of_query, $entry_of_sbjct, $blast_output,
			      $query_value, $sbjct_value);

	if($result =~ "OK"){
	    &alignment_result_show();
	}
	else{
	    &ng_file_show();
	}
}
#
################################################################################
# BLASŢ {^
################################################################################
sub Query_push {
	if(!-f $blast_output){
	    # ERROR
	    $mw->messageBox( -type => 'ok', -icon => 'warning', -title => 'ALVISION_ONE - No such file',
			     -message => 'BLASTʃt@C݂܂B' );
	    return;
	}
	&bl2seq_result_show();
}
################################################################################
# I{^
################################################################################
sub Exit_push {
	unlink("$output_file_path");
	unlink("$output_amino_path");
	unlink("$blast_output");
	unlink("$output_pdf_path");
	if(-f $error_file){
	    unlink("$error_file");
	}
	exit();
}
################################################################################
# BLASTݑIWI{^IR[obN֐
################################################################################
sub GetPattern {
	if($proc_pattern eq "blastn"){

	    $blast_pattern = "n";

	    if($pdf_chk_value eq "OFF"){
		$ent_query_IN->configure(-state => 'normal', -background => 'white');
		$ent_query_IN->update();
		$ent_query_EN->configure(-state => 'normal', -background => 'white');
		$ent_query_EN->update();
		$ent_sbjct_IN->configure(-state => 'normal', -background => 'white');
		$ent_sbjct_IN->update();
		$ent_sbjct_EN->configure(-state => 'normal', -background => 'white');
		$ent_sbjct_EN->update();
	    }
	}
	elsif($proc_pattern eq "blastp"){

	    $blast_pattern = "p";

	    if($pdf_chk_value eq "OFF"){
		$ent_query_IN->delete(0, 'end');
		$ent_query_EN->delete(0, 'end');
		$ent_sbjct_IN->delete(0, 'end');
		$ent_sbjct_EN->delete(0, 'end');
		$ent_query_IN->configure(-state => 'disabled', -background => 'gray');
		$ent_query_IN->update();
		$ent_query_EN->configure(-state => 'disabled', -background => 'gray');
		$ent_query_EN->update();
		$ent_sbjct_IN->configure(-state => 'disabled', -background => 'gray');
		$ent_sbjct_IN->update();
		$ent_sbjct_EN->configure(-state => 'disabled', -background => 'gray');
		$ent_sbjct_EN->update();
	    }
	}
}
################################################################################
# ر {^
################################################################################
sub Clear_push {
	$query_txt->delete('1.0', 'end');
	$sbjct_txt->delete('1.0', 'end');
	$ent_query->delete(0, 'end');
	$ent_sbjct->delete(0, 'end');
	$ent_expect->delete(0, 'end');
	$ent_query_IN->delete(0, 'end');
	$ent_query_EN->delete(0, 'end');
	$ent_sbjct_IN->delete(0, 'end');
	$ent_sbjct_EN->delete(0, 'end');
	$msg = "";
	$MSG->update();
}
################################################################################
# dx̐ݒ{^
################################################################################
sub Comp_value_chg {

	my($backup_blastn_scale_value);
	my($backup_blastp_scale_value);

	$backup_blastn_scale_value = $blastn_scale_value;
	$backup_blastp_scale_value = $blastp_scale_value;

        ########################################################################
	$oSub->withdraw if (Exists($oSub));
	$oSub = $mw->Toplevel();
	$oSub->title('ALVISION_ONE - dx̐ݒ');

	$oSub->grab;
	$oSub->focus;

        ########################################################################
	$gf0 = $oSub->Frame();
	$gf0->Label(-text   => 'BLASTN:dx(%)F',
		    -anchor => 'e')
	     ->pack(-side   => 'left');

	$gf0->Scale(-from     => 0,
		    -to       => 100,
		    -variable => \$blastn_scale_value,
		    -length   => 200,
		    -tickinterval   => 10,
		    -width    => 20,
		    -bigincrement   => 10,
		    -sliderrelief   => 'raised',
		    -orient   => 'horizontal')
	     ->pack(-fill     => 'both');

	$gf0->pack(-padx => 5, -pady => 3, -fill => 'both', -expand => 'yes');

        ########################################################################
	$gf1 = $oSub->Frame();
	$gf1->Label(-text   => 'BLASTP:dx(%)F',
		    -anchor => 'e')
	     ->pack(-side   => 'left');

	$gf1->Scale(-from     => 0,
		    -to       => 100,
		    -variable => \$blastp_scale_value,
		    -length   => 200,
		    -tickinterval   => 10,
		    -width    => 20,
		    -bigincrement   => 10,
		    -sliderrelief   => 'raised',
		    -orient   => 'horizontal')
	     ->pack(-fill     => 'both');

	$gf1->pack(-padx => 5, -pady => 3, -fill => 'both', -expand => 'yes');

        #######################################################################
	$gf2 = $oSub->Frame();
	$cvc_btn1 = $gf2->Button(-text       => "ݒ",
		     -command    => sub { $oSub->destroy; },
		     -width      => 10)
	      ->pack(-side       => 'left');

	$cvc_btn2 = $gf2->Button(-text       => "ݾ",
		     -command    => sub { $blastn_scale_value = $backup_blastn_scale_value;
		                          $blastp_scale_value = $backup_blastp_scale_value;
		                          $oSub->destroy;
		                          $mw->focus; },
		     -width      => 10)
	      ->pack(-side       => 'right');

        #######################################################################
	$gf0->pack(-padx => 5, -pady => 3, -fill => 'both', -expand => 'yes');
	$gf1->pack(-padx => 5, -pady => 3, -fill => 'both', -expand => 'yes');
	$gf2->pack(-padx => 5, -pady => 3, -fill => 'both', -expand => 'yes');

}
################################################################################
# PDF쐬`FbN{^IR[obN֐
################################################################################
sub pdf_chk_btn_chg {
	if($pdf_chk_value eq "ON"){
	    if($proc_pattern eq "blastn"){
		$ent_query_IN->delete(0, 'end');
		$ent_query_EN->delete(0, 'end');
		$ent_sbjct_IN->delete(0, 'end');
		$ent_sbjct_EN->delete(0, 'end');
		$ent_query_IN->configure(-state => 'disabled', -background => 'gray');
		$ent_query_IN->update();
		$ent_query_EN->configure(-state => 'disabled', -background => 'gray');
		$ent_query_EN->update();
		$ent_sbjct_IN->configure(-state => 'disabled', -background => 'gray');
		$ent_sbjct_IN->update();
		$ent_sbjct_EN->configure(-state => 'disabled', -background => 'gray');
		$ent_sbjct_EN->update();
	    }
	}
	elsif($pdf_chk_value eq "OFF"){
	    if($proc_pattern eq "blastn"){
		$ent_query_IN->configure(-state => 'normal', -background => 'white');
		$ent_query_IN->update();
		$ent_query_EN->configure(-state => 'normal', -background => 'white');
		$ent_query_EN->update();
		$ent_sbjct_IN->configure(-state => 'normal', -background => 'white');
		$ent_sbjct_IN->update();
		$ent_sbjct_EN->configure(-state => 'normal', -background => 'white');
		$ent_sbjct_EN->update();
	    }
	}
	$PDF_mode = $pdf_chk_value;
}
# 2004.05.13 add start.
################################################################################
# Queryر {^
################################################################################
sub query_text_clear {
	$query_txt->delete('1.0', 'end');
	$ent_query->delete(0, 'end');
	$ent_query_IN->delete(0, 'end');
	$ent_query_EN->delete(0, 'end');
}
################################################################################
# Sbjctر {^
################################################################################
sub sbjct_text_clear {
	$sbjct_txt->delete('1.0', 'end');
	$ent_sbjct->delete(0, 'end');
	$ent_sbjct_IN->delete(0, 'end');
	$ent_sbjct_EN->delete(0, 'end');
}
# 2004.05.13 add end.
################################################################################
# Bl2seqʕ\GUI
################################################################################
sub bl2seq_result_show {

	my($string) = ();

	open(BLAST_RESULT,"<$blast_output") || die "No $blast_output.";
	while($line = <BLAST_RESULT>){
	    $string .= $line;
	}
	close(BLAST_RESULT);

	$bl2seq_win = $mw->Toplevel;
	$bl2seq_win->title("Bl2seq Result");

	# Query Scroll Text Area
	$yscrl3 = $bl2seq_win->Scrollbar();

	$bl2seq_txt = $bl2seq_win->Text(-background     => 'white',
					-width          => 100,
					-height         => 40,
					-wrap           => 'char',
					-yscrollcommand => ['set', $yscrl3 ]);

	$yscrl3->configure(-command => ['yview', $bl2seq_txt ]);
	$yscrl3->pack(-side => 'right',  -fill => 'y');
	$bl2seq_txt->pack(-padx => 5, -pady => 3, -side => 'bottom', -fill => 'both', -expand => 'yes');

	$bl2seq_txt->insert('1.0', $string);
}
################################################################################
# NG_FILE\GUI
################################################################################
sub ng_file_show {

	my($string) = ();

	open(NG_FILE,"<$error_file") || die "No $error_file.";
	while($line = <NG_FILE>){
	    $string .= $line;
	}
	close(NG_FILE);

	$ng_file_win = $mw->Toplevel;
	$ng_file_win->title("NG");

	# Query Scroll Text Area
	$yscrl4 = $ng_file_win->Scrollbar();

	$ng_file_txt = $ng_file_win->Text(-background     => 'white',
					  -width          => 100,
					  -height         => 20,
					  -wrap           => 'char',
					  -yscrollcommand => ['set', $yscrl4 ]);

	$yscrl4->configure(-command => ['yview', $ng_file_txt ]);
	$yscrl4->pack(-side => 'right',  -fill => 'y');
	$ng_file_txt->pack(-padx => 5, -pady => 3, -side => 'bottom', -fill => 'both', -expand => 'yes');

	$ng_file_txt->insert('1.0', $string);
}
################################################################################
# Alignmentʕ\(use OLE)
################################################################################
sub alignment_result_show {

	if($amino_mode eq "OFF"){
	    if($PDF_mode eq "ON"){
		if(-f $output_pdf_path){
		    $ie = CreateObject OLE "InternetExplorer.Application.1" || die "CreateObject: $!"; 
		    $ie->{Visible} = 1; 
		    $ie->Navigate("$output_pdf_path"); 
		}
		elsif(-f $output_file_path){
		    $ie = CreateObject OLE "InternetExplorer.Application.1" || die "CreateObject: $!"; 
		    $ie->{Visible} = 1; 
		    $ie->Navigate("$output_file_path"); 
		}
	    }
	    elsif(-f $output_file_path){
		$ie = CreateObject OLE "InternetExplorer.Application.1" || die "CreateObject: $!"; 
		$ie->{Visible} = 1; 
		$ie->Navigate("$output_file_path"); 
	    }
	}
	else{
	    if(-f $output_amino_path){
		$ie = CreateObject OLE "InternetExplorer.Application.1" || die "CreateObject: $!"; 
		$ie->{Visible} = 1; 
		$ie->Navigate("$output_amino_path"); 
	    }
	}
}
#---
#
# /* start of alignment make process. (align.pl) */
###############################################################################
###############################################################################
###                                                                        ####
###                    ALIGNMENT TOOL MAIN PROCEDURE                       ####
###                                                                        ####
###############################################################################
###############################################################################
sub align_main {
    my($wd, $po, $ev, $cvn, $cvp, $asfm, $bm, $qid, $sid, $bo, $qv, $sv) = @_;

    my($query_length, $sbjct_length);
    my($qos, $qoe, $sos, $soe);

    $expect_value = $blast_mode = ();
    $query_length = $sbjct_length = ();
    $output_file_path = $blast_out_file_path = $output_pdf_path = ();
    $query_fasta_file_path = $sbjct_fasta_file_path = ();
    $expect_value = "NO-SPECIFY";
    $qos = $qoe = $sos = $soe = 0;

    ##### ALIGNMENT TOOL OPTION #####
    $work_dir = $wd;
    if($ev ne "") {
	$expect_value = $ev;
	$expect_value =~ s/E/e/;
	$expect_value =~ s/^e\-/1e\-/;
#print STDOUT "expect_value:$expect_value\n";
    }
    $comp_value_n = $cvn;
    $comp_value_p = $cvp;
    $align_ss_fasta_mode = $asfm;
    $blast_mode = $bm;
    $query_id = $qid;
    if($query_id eq ""){
	$query_id = "query";
    }
    $sbjct_id = $sid;
    if($sbjct_id eq ""){
	$sbjct_id = "sbjct";
    }
    $blast_out_file_path = $bo;
    #################################
#    $bl2seq_cmd_path = "C:\\Align\\TOOL\\Bl2seq.exe";
    $error_file = $work_dir . '/NG_FILE.txt';
    $output_file_path = $work_dir . '/ALIGNMENT_OUTPUT.txt';
    $output_amino_path = $work_dir . '/ORF_AMINO_OUTPUT.htm';
    $output_pdf_path = $work_dir . '/PDF_OUTPUT.pdf';

    $query_fasta_file_path = $work_dir . "/" . $query_id . ".txt";
    open(Q_TMP_FILE, ">$query_fasta_file_path") || die "No $query_fasta_file_path.";
    print Q_TMP_FILE "$qv";
    close(Q_TMP_FILE);

    $sbjct_fasta_file_path = $work_dir . "/" . $sbjct_id . ".txt";
    open(S_TMP_FILE, ">$sbjct_fasta_file_path") || die "No $sbjct_fasta_file_path.";
    print S_TMP_FILE "$sv";
    close(S_TMP_FILE);

    if(($query_IN ne "" && $query_EN ne "") || ($sbjct_IN ne "" && $sbjct_EN ne "")){
	$amino_mode = "ON";
    }
    elsif(($query_IN ne "") || ($sbjct_IN ne "")){
	$amino_mode = "ON";
    }
    else{
	$amino_mode = "OFF";
    }

    if($blast_mode eq "p"){
	$comp_value = $comp_value_p;
	$amino_mode = "OFF";
    }
    else{
	$comp_value = $comp_value_n;
    }

    if($amino_mode =~ "ON"){

	&make_orf_code_table();

	if($query_IN ne "" && $query_EN ne ""){
	    $qos = $query_IN;
	    $qoe = $query_EN + 2;
	}
#	/* EN󔒂̏ꍇAIRhʒu͈͂m肷 *//* 2003.09.11 Yamamoto's request */
	elsif($query_IN ne "" && $query_EN eq ""){
	    $qos = $query_IN;
	    $qoe = &EN_search($qv, $qos);
	}

	if($sbjct_IN ne "" & $sbjct_EN ne ""){
	    $sos = $sbjct_IN;
	    $soe = $sbjct_EN + 2;
	}
#	/* EN󔒂̏ꍇAIRhʒu͈͂m肷 *//* 2003.09.11 Yamamoto's request */
	elsif($sbjct_IN ne "" && $sbjct_EN eq ""){
	    $sos = $sbjct_IN;
	    $soe = &EN_search($sv, $sos);
	}
    }

#print STDOUT "eXgP\n";
    ($query_length,$sbjct_length) = &length_read($query_fasta_file_path, $sbjct_fasta_file_path);

#print STDOUT "eXgQ\n";
    &bl2seq_exec($bl2seq_cmd_path,$blast_out_file_path,$query_fasta_file_path,$sbjct_fasta_file_path);

#print STDOUT "eXgR\n";
    $ret = &make_alignment_page($blast_out_file_path,
				$query_fasta_file_path,
				$sbjct_fasta_file_path,
				$query_id,
				$sbjct_id,
				$query_length,
				$sbjct_length,
				$expect_value,
				"DUMMY",
				$qos,
				$qoe,
				$sos,
				$soe);

    ########################################################################
    ### Main Window Message Edit. ##########################################
    ########################################################################
    $msg = "sł...";
    $MSG->update();
    ########################################################################

#print STDOUT "eXgS\n";
    unlink("./tmp0.csv");
    unlink("./tmp1.csv");
    unlink("./tmp2.csv");
    unlink("./tmp3.csv");
    unlink("./tmp4.csv");
    unlink($query_fasta_file_path);
    unlink($sbjct_fasta_file_path);

    if($ret !~ "OK"){
	print "CAUTION! query_id:[$query_id], sbjct_id:[$sbjct_id] ($ret)\n";
#	next;
    }
    else{
	if($PDF_mode eq "ON" && $pdf_converter eq "iTextFront"){
	    &iTextFront_exec($pdf_cnv_cmd_path,$output_file_path,$output_pdf_path);
	}
    }

    if($error_count == 0){
	if(-f $error_file){
	    unlink($error_file);
	}
    }

    ############################################################################
    ####### Main Window Message Edit. ##########################################
    ############################################################################
    if($error_count == 0){
	$msg = "I";
	$MSG->update();
#	system("$output_file_path");
    }
    else{
	$msg = "IFG[ڂ܂";
	$MSG->update();
    }
    ############################################################################

    rmdir($query_work_dir);
    rmdir($sbjct_work_dir);
    $end_message =  sprintf("\nFinish Program...   Error count is [%d], All processing count is [%d]\n", $error_count, $num);
    $error_count = 0;
    print "$end_message";

    return($ret);
}
###############################################################################
sub init_option {
    ($ini_file) = @_;

    my($line);

    ## /* Comp Value Default Set */ /* Add by 2003.03.20 */
#    $comp_value = 50;

    open(INIT,"<$ini_file") || die "No $ini_file.";
    while($line = <INIT>){
	chomp($line);
	if($line =~ /^Bl2SeqPath=/){
	    ($dummy,$bl2seq_cmd_path) = split(/\=/, $line);
	}
	elsif($line =~ /^PDFConverterName=/){
	    ($dummy,$pdf_converter) = split(/\=/, $line);
	}
	elsif($line =~ /^PDFConverterPath=/){
	    ($dummy,$pdf_cnv_cmd_path) = split(/\=/, $line);
	}
    }
#print STDOUT "[PDFConverter]:$pdf_converter\n";
    close(INIT);

}
###############################################################################
sub length_read {
    ($query_file,$sbjct_file) = @_;

    my($q_length, $s_length);
    my($line);
    my($work);

    $q_length = $s_length = 0;
    $line = $work = ();

    open(QUERY,"<$query_file") || die "No $query_file.";
    while($line = <QUERY>){
	chomp($line);
	if($line =~ /^\>/){
	    next;
	}
	else{
	    $work .=$line;
	}
    }
    $q_length = length($work);
    close(QUERY);

    $line = $work = ();
    open(SBJCT,"<$sbjct_file") || die "No $sbjct_file.";
    while($line = <SBJCT>){
	chomp($line);
	if($line =~ /^\>/){
	    next;
	}
	else{
	    $work .=$line;
	}
    }
    $s_length = length($work);
    close(SBJCT);

    return($q_length,$s_length);
}
###############################################################################
sub bl2seq_exec {
    ($bl2seq_cmd_path,
     $blast_out_file_path,$query_fasta_file_path,
     $sbjct_fasta_file_path) = @_;

    my($bl2seq_cmd_line);

    $bl2seq_cmd_line = ();

    if($blast_mode eq "n") {
	$bl2seq_cmd_line = "$bl2seq_cmd_path -p blastn -i $query_fasta_file_path -j $sbjct_fasta_file_path -o $blast_out_file_path -F SEG";
    }
    else{
#	$bl2seq_cmd_line = "$bl2seq_cmd_path -p blastp -i $query_fasta_file_path -j $sbjct_fasta_file_path -o $blast_out_file_path -F SEG -e 0.2";
	$bl2seq_cmd_line = "$bl2seq_cmd_path -p blastp -i $query_fasta_file_path -j $sbjct_fasta_file_path -o $blast_out_file_path -F F -e 0.2";
    }
    print STDOUT "[BL2SEQ_CMD]->$bl2seq_cmd_line\n";

    system($bl2seq_cmd_line);
#    exec($bl2seq_cmd_line);
}
###############################################################################
sub iTextFront_exec {
    ($iTextFront_cmd_path,$output_file_path,$output_pdf_path) = @_;

    my($iTextFront_cmd_line);

    $iTextFront_cmd_line = ();

#    $iTextFront_cmd_line = "$iTextFront_cmd_path /font_family Courier /font-size 10 /marge $output_file_path $output_pdf_path";
#    $iTextFront_cmd_line = "$iTextFront_cmd_path /font-family Courier /font-size 7 /security 128 \"araiguma\" \"araichuu\" printing modify-annotations /merge $output_file_path $output_pdf_path";
#    $iTextFront_cmd_line = "$iTextFront_cmd_path /font-family Courier /font-size 7 /security 128 \"\" \"araichuu\" printing modify-annotations /merge $output_file_path $output_pdf_path";
#    $iTextFront_cmd_line = "$iTextFront_cmd_path /font-family Courier /font-size 7 /merge $output_file_path $output_pdf_path";
    $iTextFront_cmd_line = "$iTextFront_cmd_path /font-family Courier /font-size 7 /size A4 /margin 52:52:75:75 /security 128 \"\" \"araichuu\" printing modify-annotations /merge $output_file_path $output_pdf_path";
#    print "[ITEXTFRONT_CMD]->$iTextFront_cmd_line\n";

    system($iTextFront_cmd_line);
}
###############################################################################
sub make_alignment_page {
    ($blast_out_file_path,
     $query_fasta_file_path,
     $sbjct_fasta_file_path,
     $query_id,
     $sbjct_id,
     $q_length,
     $s_length,
     $expect_value,
     $dummy,
     $qos,
     $qoe,
     $sos,
     $soe) = @_; ## /* 2002.07.04 Reprori version chg */

    my(@qntstart, @qntsequence, @qntend);
    my(@tntstart, @tntsequence, @tntend);
    my($qnt_start_pos, $qnt_end_pos);
    my($tnt_start_pos, $tnt_end_pos);
    my($qnt_alignment, $tnt_alignment);
    my($query_line, $bar_line, $sbjct_line);
    my($result);
    my($query_cnt,$sbjct_cnt);
    my($ret);
    my($strand_flag);
    my(@strandtmp);
    my($hit_count);
    my($score,$tseqnt_evalue);
    my($query_start_pos,$sbjct_start_pos);

    $ret = "OK";

    #############################################
    ## Blast-output-file search(Alignment-line).
    #############################################
    {
	@qntstart = @qntsequence = @qntend = ();
	@tntstart = @tntsequence = @tntend = ();
	@strandtmp = ();
	$qnt_start_pos = $qnt_end_pos = ();
	$tnt_start_pos = $tnt_end_pos = ();
	$qnt_alignment = $tnt_alignment = ();
	$tmp0_file = './tmp0.csv';
	$tmp1_file = './tmp1.csv';
	$tmp2_file = './tmp2.csv';
	$tmp3_file = './tmp3.csv';
	$tmp4_file = './tmp4.csv';
	$score_count = 0;
	$seq_count = 0;
	$result = ();
	$query_line = $bar_line = $sbjct_line = ();
	$query_cnt = $sbjct_cnt = 0;
	$strand_flag = '+';
	$hit_count = 0;
	$score = $tseqnt_evalue = ();
	$retry = 10; # /* 2003.10.20 Bug taisaku */

	$time   = time();
	($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($time);
	$Year = $year + 1900;
	$Mon  = $mon + 1;
	$id = sprintf("%d/%02d/%02d/%02d%02d%02d", $Year, $Mon, $mday, $hour, $min, $sec);


	open(NG_FILE, ">>$error_file") || die "No $error_file.";
	# /* 2003.10.20 Bug taisaku add start */
	while(!-f $blast_out_file_path) {
		if (--$retry <= 0) {
			$ret = "Time out bl2seq.exe";
			print NG_FILE "<<<<<<<<<< [$id] QUERY:[$query_id], SBJCT:[$sbjct_id], $ret >>>>>>>>>>\n";
			$error_count++;
			goto EXIT;
		}
#		print STDOUT "SLEEP:$retry\n";
		sleep(1);
	}
	# /* 2003.10.20 Bug taisaku add end */
	open(BLAST_NT,"<$blast_out_file_path") || die "No $blast_out_file_path.";
	open(TMP,">$tmp0_file") || die "No $tmp0_file.";
	while($line = <BLAST_NT>){
		chomp($line);
		if($line =~ /\*\*\*\*\*\ No\ hits\ found\ \*\*\*\*\*\*/) {
			#$result = "No hits found";
			#print TMP "$result\n";
			$ret = "No hits found";
			#print "<<<<<<<<<< $ret >>>>>>>>>>\n";
			print NG_FILE "<<<<<<<<<< [$id] QUERY:[$query_id], SBJCT:[$sbjct_id], $ret >>>>>>>>>>\n";
			$error_count++;
			#last;
			goto EXIT;
		}
		elsif($line =~ /^\>/) {
			$line =~ s/\>//;
			$tseqnt_name = $line;
			if($seq_count > 0){
				$qnt_start_pos = shift(@qntstart);
				$qnt_end_pos = pop(@qntend);
				$tnt_start_pos = shift(@tntstart);
				$tnt_end_pos = pop(@tntend);
				$qnt_alignment = join("", @qntsequence);
				$tnt_alignment = join("", @tntsequence);

				$result = &one_alignment_edit($qnt_start_pos,$qnt_end_pos,
							$tnt_start_pos,$tnt_end_pos,
							$qnt_alignment,$tnt_alignment);
				print TMP "$result\n";
				$query_cnt = $sbjct_cnt = 0;
				last;
			}
			$seq_count++;
		}
		elsif($line =~ /Score\ \=/){
			$line =~ s/\ e\-/\ 1e\-/;
			($score,$tseqnt_evalue) = split(/\,\ /,$line);
			# EVALUE
			$tseqnt_evalue =~ s/Expect\ \=\ //;

			if(($score_count > 0) & ($strand_flag =~ /\+/)){
			    if($query_cnt > 0 || $sbjct_cnt > 0){
#			    if(($expect_value eq "NO-SPECIFY") || ($expect_value > $tseqnt_evalue)){
#print STDOUT "3:EXPECT_VALUE:$expect_value, GET_EVALUE:$tseqnt_evalue\n";
				$qnt_start_pos = shift(@qntstart);
				$qnt_end_pos = pop(@qntend);
				$tnt_start_pos = shift(@tntstart);
				$tnt_end_pos = pop(@tntend);
				$qnt_alignment = join("", @qntsequence);
				$tnt_alignment = join("", @tntsequence);

				$result = &one_alignment_edit($qnt_start_pos,$qnt_end_pos,
							$tnt_start_pos,$tnt_end_pos,
							$qnt_alignment,$tnt_alignment);
				print TMP "$result\n";
			    }
			}
			@qntstart = @qntsequence = @qntend = ();
			@tntstart = @tntsequence = @tntend = ();
			$query_cnt = $sbjct_cnt = 0;
			$score_count++;
		}
		elsif($line =~ /Strand\ \=/){
			@strandtmp = split(/\ +/,$line);
			if($strandtmp[3] eq $strandtmp[5]){
				$strand_flag = '+';
			}
			else{
				$strand_flag = '-';
			}
		}
		elsif($line =~ /^Query\:\ /){
			if($strand_flag =~ /\+/){
			    if(($expect_value eq "NO-SPECIFY") || ($expect_value > $tseqnt_evalue)){
#print STDOUT "1:EXPECT_VALUE:$expect_value, GET_EVALUE:$tseqnt_evalue\n";
				@qnt_pstn_tmp = split(/\ +/,$line);
				push(@qntstart,$qnt_pstn_tmp[1]);
				push(@qntsequence,$qnt_pstn_tmp[2]);
				push(@qntend,$qnt_pstn_tmp[3]);
				$query_cnt++;
				$hit_count++;
			    }
			}
		}
		elsif($line =~ /^Sbjct\:\ /){
			if($strand_flag =~ /\+/){
			    if(($expect_value eq "NO-SPECIFY") || ($expect_value > $tseqnt_evalue)){
#print STDOUT "2:EXPECT_VALUE:$expect_value, GET_EVALUE:$tseqnt_evalue\n";
				@tnt_pstn_tmp = split(/\ +/,$line);
				push(@tntstart,$tnt_pstn_tmp[1]);
				push(@tntsequence,$tnt_pstn_tmp[2]);
				push(@tntend,$tnt_pstn_tmp[3]);
				$sbjct_cnt++;
				$hit_count++;
			    }
			}
		}
		elsif(eof(BLAST_NT)){
		    if($query_cnt > 0 || $sbjct_cnt > 0){
#print STDOUT "TEST->$query_cnt,$sbjct_cnt\n";
			$qnt_start_pos = shift(@qntstart);
			$qnt_end_pos = pop(@qntend);
			$tnt_start_pos = shift(@tntstart);
			$tnt_end_pos = pop(@tntend);
			$qnt_alignment = join("", @qntsequence);
			$tnt_alignment = join("", @tntsequence);

			$result = &one_alignment_edit($qnt_start_pos,$qnt_end_pos,
						$tnt_start_pos,$tnt_end_pos,
						$qnt_alignment,$tnt_alignment);
#print STDOUT "TEST->$result\n";
			print TMP "$result\n";
		    }
		    last;
		}
	}
	close(BLAST_NT);
	close(TMP);

#print STDOUT "eXgR-1\n";
	if($hit_count == 0){
		$ret = "No hits found(Not Plus)";
		#print "<<<<<< $ret >>>>>>\n";
		print NG_FILE "<<<<<<<<<< [$id] QUERY:[$query_id], SBJCT:[$sbjct_id], $ret >>>>>>>>>>\n";
		$error_count++;
		goto EXIT;
	}

#print STDOUT "eXgR-2\n";
	## Alignment Check
	$print_count = &alignment_checker($tmp0_file,$tmp1_file);
	if($print_count == 0){
		$ret = "No hits found(No Good Alignment)";
		#print "<<<<<< $ret >>>>>>\n";
		print NG_FILE "<<<<<<<<<< [$id] QUERY:[$query_id], SBJCT:[$sbjct_id], $ret >>>>>>>>>>\n";
		$error_count++;
		goto EXIT;
	}

#print STDOUT "eXgR-3\n";
	## Alignment Check No2
	$print_count = &alignment_checker2($tmp1_file,$tmp2_file);
	if($print_count == 0){
		$ret = "No hits found(No Good Alignment2)";
		#print "<<<<<< $ret >>>>>>\n";
		print NG_FILE "<<<<<<<<<< [$id] QUERY:[$query_id], SBJCT:[$sbjct_id], $ret >>>>>>>>>>\n";
		$error_count++;
		goto EXIT;
	}

#print STDOUT "eXgR-4\n";
	## Alignment Check No3
	$print_count = &alignment_checker3($tmp2_file,$tmp3_file);
	if($print_count == 0){
		$ret = "No hits found(No Good Alignment3)";
		#print "<<<<<< $ret >>>>>>\n";
		print NG_FILE "<<<<<<<<<< [$id] QUERY:[$query_id], SBJCT:[$sbjct_id], $ret >>>>>>>>>>\n";
		$error_count++;
		goto EXIT;
	}

#print STDOUT "eXgR-5\n";
	## Alignment Sort
	&alignment_sort($tmp3_file,$tmp4_file);

    }

    #############################################
    ## Alignment Create & Edit
    #############################################
    {
	my(@query_line_table, @bar_line_table, @sbjct_line_table);
	my(@q_num_line_table, @s_num_line_table);
	my(@q_orf_line_table, @s_orf_line_table); ## /* 2002.07.08 Reprori version add */
	my($alignment_num, $identities_num, $gaps_num);
	my($identities_parcent, $gaps_parcent);
	my($piriod);
	my($print_query,$print_sbjct,$print_identities,$print_gaps);
	my($page_num);
	my($line_count);
	my($result);
	my($q_orfline,$s_orfline); ## /* 2002.07.04 Reprori version add */
	# PDF OUTPUT USE ---
	if($PDF_mode eq "ON" && $pdf_converter eq "PDFJ"){
	    my($Font,@Pagesize,@Margin,$Fontsize);
	    my($Encoding,$Linewidth,$PageHeight,@PosBody);
	    my($doc,$font,$ts,$ps);
	    my(@texts);
	}
	# ------------------

	@query_line_table = @bar_line_table = @sbjct_line_table = ();
	@q_num_line_table = @s_num_line_table = ();
	@q_orf_line_table = @s_orf_line_table = (); ## /* 2002.07.08 Reprori version add */
	$alignment_num = $identities_num = $gaps_num = ();
	$identities_parcent = $gaps_parcent = ();
	$piriod = ();
	$print_query = $print_sbjct = $print_identities = $print_gaps = ();
	$page_num = $line_count = 0;
	$query_start_pos = $sbjct_start_pos = 0;
	$result = "OK";
	$q_orfline = $s_orfline = (); ## /* 2002.07.04 Reprori version add */

#print STDOUT "eXgR-6\n";
	## Global Alignment Create
	($query_line,$bar_line,$sbjct_line,$query_start_pos,$sbjct_start_pos,$q_orfline,$s_orfline) = 
		&global_alignment_make($tmp4_file,$query_fasta_file_path,$sbjct_fasta_file_path,
		                       $qos,$qoe,$sos,$soe,$q_length,$s_length); ## /* 2002.07.04 Reprori version chg */

#print STDOUT "eXgR-7\n";
	## /* 2003.03.19 */ Alignment Compare Check
	$result = &alignment_cmp($query_line,$sbjct_line,$query_start_pos,$sbjct_start_pos,
				$query_fasta_file_path,$sbjct_fasta_file_path);
	if($result !~ "OK"){
	    ##$ret = "CAUTION! query_id:[$query_id], sbjct_id:[$sbjct_id] (alignment cmp check is NG)\n";
	    $ret = "Alignment Compare Check is NG";
	    #print "<<<<<< $ret >>>>>>\n";
	    goto EXIT;
	}

#print STDOUT "eXgR-8\n";
	## Rooler make
	($q_num_line,$s_num_line) = &num_line_make($query_line,$sbjct_line,$query_start_pos,$sbjct_start_pos);

#print STDOUT "eXgR-9\n";
	## 
	($alignment_num,$identities_num) = &check_identities($bar_line);
	$identities_parcent = ($identities_num / $alignment_num) * 100;
	if($identities_parcent ne "100"){
	    $piriod = index($identities_parcent, ".");
	    if($piriod != -1){
		$identities_parcent = substr($identities_parcent, 0, $piriod+2);
	    }
	}

#print STDOUT "eXgR-10\n";
	## 
	($alignment_num,$gaps_num)       = &check_gaps($bar_line);
	$gaps_parcent = ($gaps_num / $alignment_num) * 100;
	if($gaps_parcent ne "100"){
	    $piriod = index($gaps_parcent, ".");
	    if($piriod != -1){
		$gaps_parcent = substr($gaps_parcent, 0, $piriod+2);
	    }
	}

#print STDOUT "eXgR-11\n";
	$print_query =
	    sprintf(" Query= %18s : Length= (%5d)\n", $query_id,$q_length);
	$print_sbjct =
	    sprintf(" Sbjct= %18s : Length= (%5d)\n\n", $sbjct_id,$s_length);
	$print_identities = 
	    sprintf("  Identities= %5d / %5d (%5s%)\n", $identities_num, $alignment_num, $identities_parcent);
	$print_gaps = 
	    sprintf("  Missmaches= %5d / %5d (%5s%)\n\n", $gaps_num, $alignment_num, $gaps_parcent);

	#############################################
	## Alignment Output File Create
	#############################################

	# PDF OUTPUT SETTING
	if($PDF_mode eq "ON" && $pdf_converter eq "PDFJ"){

	    $Font = @Pagesize = @Margin = $Fontsize = ();
	    $Encoding = $Linewidth = $PageHeight = @PosBody = ();
	    $doc = $font = $ts = $ps = ();
	    @texts = ();

	    $Font = "Courier";
	    @Pagesize = (595, 842); # A4 210mm x 297mm
	    @Margin = (52, 52, 72, 72); # (left, right, top, bottom) 1inch
	    $Fontsize = 7;
	    $Encoding = "WinAnsiEncoding";
	    $Linewidth = $Pagesize[0] - $Margin[0] - $Margin[1];
	    $PageHeight = $Pagesize[1] - $Margin[2] - $Margin[3];
	    @PosBody = ($Margin[0], $Pagesize[1] - $Margin[3]);

	    $doc = PDFJ::Doc->new(1.4, @Pagesize);
	    $font = $doc->new_font($Font, $Encoding);
	    $ts = TStyle(font => $font, fontsize => $Fontsize);
	    $ps = PStyle(size => $Linewidth, align => 'b', linefeed => '150%');

	    push @texts, Text("$print_query", $ts), NewLine;
	    push @texts, Text("$print_sbjct", $ts), NewLine;
	    push @texts, Text("\n", $ts), NewLine;
	    push @texts, Text("$print_identities", $ts), NewLine;
	    push @texts, Text("$print_gaps", $ts), NewLine;
	    push @texts, Text("\n", $ts), NewLine;
	}

#print STDOUT "eXgR-12\n";
	open(OUTPUT,">$output_file_path") || die "No $output_file_path.";

	print OUTPUT "$print_query";
	print OUTPUT "$print_sbjct";

	print OUTPUT "$print_identities";
	print OUTPUT "$print_gaps";

#print STDOUT "eXgR-13\n";
	for($i=0,$n=0,$t=0; $n<length($query_line); $i++,$n=$n+100,$t=$t+110){

	    $query_line_table[$i] = substr($query_line, $n, 100);
	    $bar_line_table[$i]   = substr($bar_line, $n, 100);
	    $sbjct_line_table[$i] = substr($sbjct_line, $n, 100);
	    $q_num_line_table[$i] = substr($q_num_line, $t, 110);
	    $s_num_line_table[$i] = substr($s_num_line, $t, 110);
	    if($amino_mode =~ "ON"){
		$q_orf_line_table[$i] = substr($q_orfline, $n, 100); ## /* 2002.07.08 Reprori version add */
		$s_orf_line_table[$i] = substr($s_orfline, $n, 100); ## /* 2002.07.08 Reprori version add */
		$q_orf_line_table[$i] =~ s/\(/&lt;/g;
		$q_orf_line_table[$i] =~ s/\)/&gt;/g;
		$s_orf_line_table[$i] =~ s/\(/&lt;/g;
		$s_orf_line_table[$i] =~ s/\)/&gt;/g;
	    }

	    if($amino_mode =~ "ON"){
		print OUTPUT "          $q_orf_line_table[$i]\n"; ## /* 2002.07.08 Reprori version add */
	    }
	    print OUTPUT "$q_num_line_table[$i]\n";
	    print OUTPUT " Query :  $query_line_table[$i]\n";
	    print OUTPUT "          $bar_line_table[$i]\n";
	    print OUTPUT " Sbjct :  $sbjct_line_table[$i]\n";
	    print OUTPUT "$s_num_line_table[$i]\n";
	    if($amino_mode =~ "ON"){
		print OUTPUT "          $s_orf_line_table[$i]\n"; ## /* 2002.07.08 Reprori version add */
	    }
	    print OUTPUT "\n";

	    # PDF OUTPUT SETTING
	    if($PDF_mode eq "ON" && $pdf_converter eq "PDFJ"){
		push @texts, Text("$q_num_line_table[$i]\n", $ts), NewLine;
		push @texts, Text(" Query :  $query_line_table[$i]\n", $ts), NewLine;
		push @texts, Text("          $bar_line_table[$i]\n", $ts), NewLine;
		push @texts, Text(" Sbjct :  $sbjct_line_table[$i]\n", $ts), NewLine;
		push @texts, Text("$s_num_line_table[$i]\n", $ts), NewLine;
		push @texts, Text("\n", $ts), NewLine;
	    }
	}
	close(OUTPUT);

	## /* 2003.07.22 Reprori version add start */
	if($amino_mode =~ "ON"){
	    my(@query_html_line, @sbjct_html_line);
	    my($total_line_cnt);

	    @query_html_line = @sbjct_html_line = ();

	    ## /* bug taisaku 2003.10.16 add start */
	    $buf = ();
	    for($i=0; $i<length($query_line); $i++){
		$buf = substr($query_line, $i, 1);
		if($buf =~ /\-/){
		    ## /* bug taisaku 2003.10.22 add start */
#		    if($i < $qos) {
#			$qos++;
#		    }
		    ## /* bug taisaku 2003.10.22 add end */
#		    if($i < $qoe) { # 2004.01.21 add by hatano
#			$qoe++;
#		    }
		}
	    }
	    for($i=0; $i<length($sbjct_line); $i++){
		$buf = substr($sbjct_line, $i, 1);
		if($buf =~ /\-/){
		    ## /* bug taisaku 2003.10.22 add start */
#		    if($i < $qos) {
#		    if($i < $sos) {
#			$sos++;
#		    }
		    ## /* bug taisaku 2003.10.22 add end */
#		    if($i < $soe) { # 2004.01.21 add by hatano
#			$soe++;
#		    }
		}
	    }
	    ## /* bug taisaku 2003.10.16 add end */

#print STDOUT "query_IN:[$query_IN],query_EN:[$query_EN],qos[$qos],qoe[$qoe]\n";
	    for($i=0,$total_line_cnt=0; $i<$#query_line_table+1; $i++){
#		if($query_IN ne "" && $query_EN eq ""){ # 2004.01.19 add by hatano.
		if($query_IN ne ""){ # 2004.01.19 add by hatano.
		    ($query_html_line[$i]) = 
		    &html_query_align_line_make(\$query_line_table[$i], $qos, $qoe, \$total_line_cnt);
		}
		else{
		    $query_html_line[$i] = $query_line_table[$i];
		}
	    }
#print STDOUT "sbjct_IN:[$sbjct_IN],sbjct_EN:[$sbjct_EN],sos[$sos],soe[$soe]\n";
	    for($i=0,$total_line_cnt=0; $i<$#sbjct_line_table+1; $i++){
#		if($sbjct_IN ne "" && $sbjct_EN eq ""){ # 2004.01.19 add by hatano.
		if($sbjct_IN ne ""){ # 2004.01.19 add by hatano.
		    ($sbjct_html_line[$i]) = 
		    &html_sbjct_align_line_make(\$sbjct_line_table[$i], $sos, $soe, \$total_line_cnt);
		}
		else{
		    $sbjct_html_line[$i] = $sbjct_line_table[$i];
		}
	    }

	    open(HTML,">$output_amino_path") || die "No $output_amino_path.";

	    print HTML "<HTML>\n";
# 2004.01.21 CHG by hatano. -START-
	    print HTML "<style TYPE=\"text/css\">";
	    print HTML "<!--\n";
	    print HTML "H1 { page-break-before: always; }\n";
	    print HTML "-->\n";
	    print HTML "</style>\n";
# 2004.01.21 CHG by hatano. -END-
	    print HTML "<PRE>\n";
	    print HTML "<basefont size=\"3\">\n";
	    print HTML "$print_query";
	    print HTML "$print_sbjct";

	    print HTML "$print_identities";
	    print HTML "$print_gaps";

######################################################################################################
#	    print HTML "<div style=\"padding-left:50px\"><hr width=610 align=left></div>\n";
######################################################################################################
	    # 2004.01.21 add by hatano.
	    print HTML "<div style=\"padding-left:50px\"><hr width=610 align=left></div><br>";

	    $first_page_flg = 1;	# 2004.01.21 add by hatano.
	    $page_line_counter = 1;	# 2004.01.21 add by hatano.
	    for($i=0; $i<$#query_line_table+1; $i++){

######################################################################################################
#		print HTML "          $q_orf_line_table[$i]\n";
#		print HTML "$q_num_line_table[$i]\n";
#		print HTML " Query :  $query_html_line[$i]\n";
#		print HTML "          $bar_line_table[$i]\n";
#		print HTML " Sbjct :  $sbjct_html_line[$i]\n";
#		print HTML "$s_num_line_table[$i]\n";
#		print HTML "          $s_orf_line_table[$i]\n";
#		print HTML "<div style=\"padding-left:50px\"><hr width=610 align=left></div>\n";
######################################################################################################
# 2004.01.21 CHG by hatano. -START-
		print HTML "          $q_orf_line_table[$i]<br>";
		print HTML "$q_num_line_table[$i]<br>";
		print HTML " Query :  $query_html_line[$i]<br>";
		print HTML "          $bar_line_table[$i]<br>";
		print HTML " Sbjct :  $sbjct_html_line[$i]<br>";
		print HTML "$s_num_line_table[$i]<br>";
		print HTML "          $s_orf_line_table[$i]";

		if($first_page_flg == 1){
		    if($page_line_counter == 7){
			print HTML "<h1><br></h1>";
			$page_line_counter = 0;
			$first_page_flg = 0;
		    }
		    else{
			print HTML "<br>";
		    }
		}
		else{
		    if($page_line_counter == 8){
			print HTML "<h1><br></h1>";
			$page_line_counter = 0;
		    }
		    else{
			print HTML "<br>";
		    }
		}
		print HTML "<div style=\"padding-left:50px\"><hr width=610 align=left></div><br>";
		$page_line_counter++;
# 2004.01.21 CHG by hatano. -END-
	    }
	    print HTML "</PRE>\n";
	    print HTML "</HTML>\n";
	    close(HTML);
	}
	## /* 2003.07.22 Reprori version add end */

	# PDF OUTPUT SETTING
	if($PDF_mode eq "ON" && $pdf_converter eq "PDFJ"){
	    for my $para(Paragraph(Text(\@texts, $ts), $ps)->break($PageHeight)) {
		my $page = $doc->new_page;
		$para->show($page, @PosBody);
	    }
	    $doc->print($output_pdf_path);
	}

#print STDOUT "eXgR-14\n";
	## /* 2003.04.02 */ ##
	if($align_ss_fasta_mode == 1){
	    &ss_fasta_create($sbjct_line,$sbjct_fasta_file_path,$work_dir,$bar_line,$query_id);
	}

    }
EXIT:
#print STDOUT "eXgR-15\n";
    close(NG_FILE);
    return($ret);
}
###############################################################################
sub one_alignment_edit {
    ($qnt_start_pos,$qnt_end_pos,$tnt_start_pos,$tnt_end_pos,$qnt_alignment,$tnt_alignment) = @_;

    my($qnt_length,$tnt_length);
    my($alignment_or_mark);
    my($ident_count,$gap_count);
    my($c);
    my($rtn_alignment);

    $alignment_or_mark = $rtn_alignment = ();

    $qnt_length = length($qnt_alignment);
    $tnt_length = length($tnt_alignment);

    $ident_count = $gap_count = 0;

    for($i=0; $i<$qnt_length; $i++) {
	$char_qnt = substr($qnt_alignment, $i, 1);
	$char_tnt = substr($tnt_alignment, $i, 1);
	if($char_qnt eq $char_tnt) {
		$alignment_or_mark .= '|';
		$ident_count++;
	}
	else {
		$alignment_or_mark .= '*';
		$gap_count++;
		$uc_char_qnt = uc($char_qnt);
		$uc_char_tnt = uc($char_tnt);
		substr($qnt_alignment, $i, 1, $uc_char_qnt);
		substr($tnt_alignment, $i, 1, $uc_char_tnt);
	}
    }
    $rtn_alignment = "$qnt_start_pos,$qnt_alignment,$qnt_end_pos,$tnt_start_pos,$tnt_alignment,$tnt_end_pos,$alignment_or_mark";

    return $rtn_alignment;

##    print "==========================\n";
##    printf("Query:[%5d]:%s:[%5d]\n",$qnt_start_pos,$qnt_alignment,$qnt_end_pos);
##    printf("              %s\n",$alignment_or_mark);
##    printf("Sbjct:[%5d]:%s:[%5d]\n",$tnt_start_pos,$tnt_alignment,$tnt_end_pos);
}
###############################################################################
sub alignment_sort {
    ($tmp_file,$output_file) = @_;

    my(%ge);
    my(@start_pos);
    my($i);

    @ge = ();
    @start_pos = ();

    open(TMP,"<$tmp_file") || die "No $tmp_file.";
    while(<TMP>){
        chomp($_);
        push(@ge,$_);
        @dt = split(',',$_);
        ## QNT_START_POS
        push(@start_pos, $dt[0]);
    }
    close(TMP);

    @ge = @ge[sort {$start_pos[$a] <=> $start_pos[$b] } 0 .. $#start_pos];

    open(OUT,">$output_file") || die "No $output_file.";
    foreach $i ( @ge ){
        chomp($i);

        print OUT "$i\n";

    }
    close(OUT);
}
###############################################################################
sub alignment_checker {
    ($tmp_file,$output_file) = @_;

    my(%lines);
    my(@buf);
    my($i, $j, $count, $remove_cnt, $n);
    my(@q_start_pos,@q_end_pos,@t_start_pos,@t_end_pos);
    my(@Removes);
    my($stat);
    my($print_flag);
    my($print_line_count);
    my($removed_flg);

    @lines = ();
    @buf = ();
    @Removes = ();
    @q_start_pos = @q_end_pos = @t_start_pos = @t_end_pos = ();
    $count = $remove_cnt = 0;
    $print_flag = "YES";
    $print_line_count = 0;
    $removed_flg = 0;

    open(TMP,"<$tmp_file") || die "No $tmp_file.";
    while(<TMP>){
        chomp($_);
	push(@lines,$_);
	@buf = split(',',$_);
	push(@q_start_pos, $buf[0]);
	push(@q_end_pos, $buf[2]);
	push(@t_start_pos, $buf[3]);
	push(@t_end_pos, $buf[5]);
	$count++;
    }
    close(TMP);

    for($i=0; $i<$count; $i++){
	for($j=$i+1; $j<$count; $j++){
#	    if($i != $j){
		for($n=0; $n<$remove_cnt;$n++){
		    if($i == $Removes[$n]){
			$removed_flg = 1;
		    }
		}
		if($removed_flg == 0){
#		    if((($q_start_pos[$j] >= $q_start_pos[$i]) && ($q_end_pos[$j] <= $q_end_pos[$i])) ||
#		       (($t_start_pos[$j] >= $t_start_pos[$i]) && ($t_end_pos[$j] <= $t_end_pos[$i]))) {
# TEST
		    if(($q_start_pos[$j] >= $q_start_pos[$i] && $q_end_pos[$j] <= $q_end_pos[$i]) ||
		       ($t_start_pos[$j] >= $t_start_pos[$i] && $t_end_pos[$j] <= $t_end_pos[$i]) ||
		       ($q_start_pos[$i] >= $q_start_pos[$j] && $q_end_pos[$i] <= $q_end_pos[$j]) ||
		       ($t_start_pos[$i] >= $t_start_pos[$j] && $t_end_pos[$i] <= $t_end_pos[$j])) {
			push(@Removes, $j);
			$remove_cnt++;
#print STDOUT "$q_start_pos[$i],$q_end_pos[$i], -- $q_start_pos[$j],$q_end_pos[$j]\n";
		    }
		}
		else{
		    $removed_flg = 0;
		}
#	    }
	}
	$j=0;
    }
    
    open(OUT,">$output_file") || die "No $output_file.";
    for($i=0; $i<$count; $i++){
	$stat = $lines[$i];
        chomp($stat);
	if($remove_cnt == 0){
	    print OUT "$stat\n";
	    $print_line_count++;
	}
	else{
	    for($j=0; $j<$remove_cnt; $j++){
		if($i == $Removes[$j]){
		    $print_flag = "NO";
		    last;
		}
		else{
		    $print_flag = "YES";
		}
	    }
	    if($print_flag eq "YES"){
#print "STAT:$stat\n";
		print OUT "$stat\n";
		$print_line_count++;
	    }
	}
    }
    close(OUT);

    return ($print_line_count);

}
###############################################################################
sub alignment_checker2 {
    ($tmp_file,$output_file) = @_;

    my(%lines);
    my(@buf);
    my($i, $j, $count, $remove_cnt, $n);
    my(@q_start_pos,@q_end_pos,@t_start_pos,@t_end_pos);
    my(@Removes);
    my($stat);
    my($print_flag);
    my($print_line_count);
    my($removed_flg);

    @lines = ();
    @buf = ();
    @Removes = ();
    @q_start_pos = @q_end_pos = @t_start_pos = @t_end_pos = ();
    $count = $remove_cnt = 0;
    $print_flag = "YES";
    $print_line_count = 0;
    $removed_flg = 0;

    open(TMP,"<$tmp_file") || die "No $tmp_file.";
    while(<TMP>){
        chomp($_);
	push(@lines,$_);
	@buf = split(',',$_);
	push(@q_start_pos, $buf[0]);
	push(@q_end_pos, $buf[2]);
	push(@t_start_pos, $buf[3]);
	push(@t_end_pos, $buf[5]);
	$count++;
    }
    close(TMP);

    for($i=0; $i<$count; $i++){
	for($j=$i+1; $j<$count; $j++){
	    for($n=0; $n<$remove_cnt;$n++){
		if($i == $Removes[$n]){
		    $removed_flg = 1;
		}
	    }
	    if($removed_flg == 0){
		if($q_start_pos[$i] <= $q_start_pos[$j]){
		    if($t_start_pos[$i] >= $t_start_pos[$j]){
			push(@Removes, $j);
			$remove_cnt++;
		    }
		}
		elsif($q_start_pos[$i] >= $q_start_pos[$j]){
		    if($t_start_pos[$i] <= $t_start_pos[$j]){
			push(@Removes, $j);
			$remove_cnt++;
		    }
		}
	    }
	    else{
		$removed_flg = 0;
	    }
	}
	$j=0;
    }
    
    open(OUT,">$output_file") || die "No $output_file.";
    for($i=0; $i<$count; $i++){
	$stat = $lines[$i];
        chomp($stat);
	if($remove_cnt == 0){
	    print OUT "$stat\n";
	    $print_line_count++;
	}
	else{
	    for($j=0; $j<$remove_cnt; $j++){
		if($i == $Removes[$j]){
		    $print_flag = "NO";
		    last;
		}
		else{
		    $print_flag = "YES";
		}
	    }
	    if($print_flag eq "YES"){
#print "STAT:$stat\n";
		print OUT "$stat\n";
		$print_line_count++;
	    }
	}
    }
    close(OUT);

    return ($print_line_count);

}
###############################################################################
sub alignment_checker3 {
    ($tmp_file,$output_file) = @_;

    my(%lines);
    my(@buf);
    my($i, $j, $n, $count, $remove_cnt, $p);
    my(@q_start_pos,@q_length,@q_end_pos,@t_start_pos,@t_length,@t_end_pos);
    my(@Removes);
    my($stat);
    my($print_flag);
    my($print_line_count);
    my($work);
    my($length_wk);
    my($q_start_wk1,$q_start_wk2,$t_start_wk1,$t_start_wk2);
    my($q_end_wk1,$q_end_wk2,$t_end_wk1,$t_end_wk2);
    my($cmp_counter);
    my($removed_flg);

    @lines = ();
    @buf = ();
    @Removes = ();
    @q_start_pos = @q_length = @q_end_pos = @t_start_pos = @t_length = @t_end_pos = ();
    $count = $remove_cnt = 0;
    $print_flag = "YES";
    $print_line_count = 0;
    $work = ();
    $length_wk = 0;
    $q_start_wk1 = $q_start_wk2 = $t_start_wk1 = $t_start_wk2 = 0;
    $q_end_wk1 = $q_end_wk2 = $t_end_wk1 = $t_end_wk2 = 0;
    $cmp_counter = 0;
    $removed_flg = 0;

    open(TMP,"<$tmp_file") || die "No $tmp_file.";
    while(<TMP>){
        chomp($_);
	push(@lines,$_);
	@buf = split(',',$_);
	push(@q_start_pos, $buf[0]);
	$work = length($buf[1]);
	push(@q_length, $work);
	push(@q_end_pos, $buf[2]);
	push(@t_start_pos, $buf[3]);
	$work = length($buf[4]);
	push(@t_length, $work);
	push(@t_end_pos, $buf[5]);
	$count++;
    }
    close(TMP);

    for($i=0; $i<$count; $i++){
	for($j=$i+1,$comp_counter=0; $j<$count; $j++){

	    for($p=0; $p<$remove_cnt;$p++){
		if($i == $Removes[$p]){
		    $removed_flg = 1;
		}
	    }
	    if($removed_flg == 0){
		if((($q_start_pos[$j] >= $q_start_pos[$i]) && ($q_start_pos[$j] <= $q_end_pos[$i])) ||
		   (($q_end_pos[$j] >= $q_start_pos[$i]) && ($q_end_pos[$j] <= $q_end_pos[$i]))) {

		    $q_start_wk1 = $q_start_pos[$i];
		    $q_end_wk1 = $q_end_pos[$i];
		    $q_start_wk2 = $q_start_pos[$j];
		    $q_end_wk2 = $q_end_pos[$j];

		    for($n=$q_start_wk1; $n<$q_end_wk1; $n++){
			if(($n >= $q_start_wk2) && ($n <= $q_end_wk2)){
			    $cmp_counter++;
			}
		    }
## /* 2002.04.03 COMMENT */
#		    if($q_length[$i] <= $q_length[$j]){
#			$length_wk = $q_length[$i];
#		    }
#		    else{
			$length_wk = $q_length[$j];
#		    }
		    $cmp_percent = ($cmp_counter / $length_wk) * 100;
			if($comp_value <= $cmp_percent){
			push(@Removes, $j);
			$remove_cnt++;
		    }
		}
		elsif((($t_start_pos[$j] >= $t_start_pos[$i]) && ($t_start_pos[$j] <= $t_end_pos[$i])) ||
		      (($t_end_pos[$j] >= $t_start_pos[$i]) && ($t_end_pos[$j] <= $t_end_pos[$i]))) {

		    $t_start_wk1 = $t_start_pos[$i];
		    $t_end_wk1 = $t_end_pos[$i];
		    $t_start_wk2 = $t_start_pos[$j];
		    $t_end_wk2 = $t_end_pos[$j];

		    for($n=$t_start_wk1; $n<$t_end_wk1; $n++){
			if(($n >= $t_start_wk2) && ($n <= $t_end_wk2)){
			    $cmp_counter++;
			}
		    }
## /* 2002.04.03 COMMENT */
#		    if($t_length[$i] <= $t_length[$j]){
#			$length_wk = $t_length[$i];
#		    }
#		    else{
			$length_wk = $t_length[$j];
#		    }
		    $cmp_percent = ($cmp_counter / $length_wk) * 100;
			if($comp_value <= $cmp_percent){
			push(@Removes, $j);
			$remove_cnt++;
		    }
		}
	    }
	    else{
		$removed_flg = 0;
	    }
	}
	$j=0;
    }
    
    open(OUT,">$output_file") || die "No $output_file.";
    for($i=0; $i<$count; $i++){
	$stat = $lines[$i];
        chomp($stat);
	if($remove_cnt == 0){
	    print OUT "$stat\n";
	    $print_line_count++;
	}
	else{
	    for($j=0; $j<$remove_cnt; $j++){
		if($i == $Removes[$j]){
		    $print_flag = "NO";
		    last;
		}
		else{
		    $print_flag = "YES";
		}
	    }
	    if($print_flag eq "YES"){
#print "STAT:$stat\n";
		print OUT "$stat\n";
		$print_line_count++;
	    }
	}
    }
    close(OUT);

    return ($print_line_count);

}
###############################################################################
sub global_alignment_make {
    ($input_file,$query_fasta_file_path,$sbjct_fasta_file_path,
     $qos,$qoe,$sos,$soe,$qlen,$slen) = @_; ## /* 2002.07.04 Reprori version chg */

    my(@QstartBuf,@QseqBuf,@QendBuf);
    my(@TstartBuf,@TseqBuf,@TendBuf);
    my(@SeqOrBuf);
    my($line);
    my($i,$j);
    my($alignment_cnt);
    my($query_gap,$sbjct_gap);
    my($query_union,$sbjct_union);
    my($pos);
    my($query_gap_stat,$sbjct_gap_stat);
    my($Qstr, $Tstr, $BARstr);
    my($blank,$blank2);
    my($rtn_query,$rtn_bar,$rtn_sbjct);
    my($wk_query,$wk_bar,$wk_sbjct); # /* 2003.05.14 add */
    my($updt_flag, $left_or_right);
    my($query_start_point,$sbjct_start_point);
    my($q_orfline,$s_orfline); ## /* 2002.07.04 Reprori version add */
    my($q_orfline_wk,$s_orfline_wk); ## /* 2002.07.04 Reprori version add */
    my($q_orfline_wk2,$s_orfline_wk2); ## /* 2002.07.04 Reprori version add */
    my($q_orfline_wk3,$s_orfline_wk3); ## /* 2002.07.14 Reprori version add */
    my($q_orf_len,$s_orf_len); ## /* 2002.07.04 Reprori version add */
    my($q_orf_head_len,$s_orf_head_len); ## /* 2002.07.04 Reprori version add */
    my($q_orf_tail_len,$s_orf_tail_len); ## /* 2002.07.04 Reprori version add */

    @QstartBuf = @QseqBuf = @QendBuf = ();
    @TstartBuf = @TseqBuf = @TendBuf = ();
    @SeqOrBuf = ();
    $Qstr = $Tstr = $BARstr = ();
    $rtn_query = $rtn_bar = $rtn_sbjct = ();
    $wk_query = $wk_bar = $wk_sbjct = (); # /* 2003.05.14 add */
    $updt_flag = $left_or_right = 0;
    $query_start_point = $sbjct_start_point = 1;
    $q_orfline = $s_orfline = (); ## /* 2002.07.04 Reprori version add */
    $q_orfline_wk = $s_orfline_wk = (); ## /* 2002.07.04 Reprori version add */
    $q_orfline_wk2 = $s_orfline_wk2 = (); ## /* 2002.07.04 Reprori version add */
    $q_orfline_wk3 = $s_orfline_wk3 = (); ## /* 2002.07.14 Reprori version add */
    $q_orf_len = $s_orf_len = 0;  ## /* 2002.07.04 Reprori version add */
    $q_orf_head_len = $s_orf_head_len = 0;  ## /* 2002.07.04 Reprori version add */
    $q_orf_tail_len = $s_orf_tail_len = 0;  ## /* 2002.07.04 Reprori version add */

#print STDOUT "eXgR-6-1\n";
    open(INPUT,"<$input_file") || die "No $input_file.";
    $i=0;
#print STDOUT "eXgR-6-2\n";
    while($line = <INPUT>) {
	chomp($line);

	($QstartBuf[$i],$QseqBuf[$i],$QendBuf[$i],
	 $TstartBuf[$i],$TseqBuf[$i],$TendBuf[$i],
	 $SeqOrBuf[$i])		= split(/\,/, $line);
	$i++;
    }
    close(INPUT);
#print STDOUT "eXgR-6-3\n";

    $alignment_cnt = $i;
#print STDOUT "eXgR-6-3:alignment_cnt:$alignment_cnt\n";

    for($i=0; $i<$alignment_cnt; $i++){
	#print STDOUT "<<$QstartBuf[$i],$QseqBuf[$i],$QendBuf[$i],$TstartBuf[$i],$TseqBuf[$i],$TendBuf[$i],$SeqOrBuf[$i]>>\n";
	$query_gap = $query_union = $sbjct_gap = $sbjct_union = 0;
	$query_gap_stat = $sbjct_gap_stat = ();
	$blank = $blank2 = ();

	######################################
	## Alignment Last Check
	######################################
	if($QstartBuf[$i+1] eq /\s+/ & $TstartBuf[$i+1] eq /\s+/) {
	    $query_gap = $sbjct_gap = 0;
	    $query_gap_stat = $sbjct_gap_stat = ();
	}

#open(TEST, ">>comp_test.txt");
	######################################
	## Query Alignment Check
	######################################
	if(($QstartBuf[$i+1] - $QendBuf[$i]) > 1){
	    $query_gap = ($QstartBuf[$i+1] - $QendBuf[$i]) - 1;
	    $query_union = 0;
#print STDOUT "query_gap:[$query_gap]\n";
	    $query_gap_stat = &fasta_gap_get($query_fasta_file_path,$QendBuf[$i],$query_gap);
#print STDOUT "query_rtn_str:[$query_gap_stat]\n";
#print STDOUT "TEST_1_1, $query_gap_stat\n";
	}
	elsif(($QstartBuf[$i+1] - $QendBuf[$i]) == 1){
	    $query_gap = 0;
	    $query_union = 0;
#print STDOUT "TEST_1_2\n";
	}
	elsif((($QstartBuf[$i+1] - $QendBuf[$i]) <= 0) & ($QstartBuf[$i+1] ne /\s+/)){
	    $query_gap = 0;
	    $query_union = ($QendBuf[$i] - $QstartBuf[$i+1]) + 1;
#print STDOUT "TEST_1_3\n";
	}
	else{
	    $query_gap = 0;
	    $query_union = 0;
	    $query_gap_stat = ();
#print STDOUT "TEST_1_4\n";
	}

	######################################
	## Sbjct Alignment Check
	######################################
	if(($TstartBuf[$i+1] - $TendBuf[$i]) > 1){
	    $sbjct_gap = ($TstartBuf[$i+1] - $TendBuf[$i]) - 1;
	    $sbjct_union = 0;
#print STDOUT "sbjct_gap:[$sbjct_gap]\n";
	    $sbjct_gap_stat = &fasta_gap_get($sbjct_fasta_file_path,$TendBuf[$i],$sbjct_gap);
	    ##print "sbjct_rtn_str:[$sbjct_gap_stat]\n";
#print STDOUT "TEST_2_1, $sbjct_gap_stat\n";
	}
	elsif(($TstartBuf[$i+1] - $TendBuf[$i]) == 1){
	    $sbjct_gap = 0;
	    $sbjct_union = 0;
#print STDOUT "TEST_2_2\n";
	}
	elsif((($TstartBuf[$i+1] - $TendBuf[$i]) <= 0) & ($TstartBuf[$i+1] ne /\s+/)){
	    $sbjct_gap = 0;
	    $sbjct_union = ($TendBuf[$i] - $TstartBuf[$i+1]) + 1;
#print STDOUT "TEST_2_3\n";
	}
	else{
	    $sbjct_gap = 0;
	    $sbjct_union = 0;
	    $sbjct_gap_stat = ();
#print STDOUT "TEST_2_4\n";
	}

	######################################
	## Alignment Gap Make
	######################################
	if($query_gap > $sbjct_gap){
#print STDOUT "TEST_A-> $query_gap, $sbjct_gap\n";
	    for($j=0; $j<($query_gap - $sbjct_gap); $j++){
		$blank .= ' ';
	    }
	    for($j=0; $j<length($sbjct_gap_stat); $j++){
		$blank2 .= ' ';
	    }
	    if($sbjct_union > 0) {
		&alignment_union_check(\$SeqOrBuf[$i],\$SeqOrBuf[$i+1],\$TseqBuf[$i],\$TseqBuf[$i+1],$sbjct_union,
					\$QseqBuf[$i],\$QseqBuf[$i+1]);
	    }
	    if(($query_gap > 0) & ($sbjct_gap > 0)){
		($updt_flag,$left_or_right) = &update_sbjct_gap_state(\$query_gap_stat,\$sbjct_gap_stat,\$blank2);
	    }
	    if(($updt_flag == 1) & ($left_or_right == 1)){
		$Tstr = $Tstr . $TseqBuf[$i] . $blank . $sbjct_gap_stat;
		$BARstr = $BARstr . $SeqOrBuf[$i] . $blank . $blank2;
	    }
	    else{
		$Tstr = $Tstr . $TseqBuf[$i] . $sbjct_gap_stat . $blank;
		$BARstr = $BARstr . $SeqOrBuf[$i] . $blank2 . $blank;
	    }
	    $Qstr = $Qstr . $QseqBuf[$i] . $query_gap_stat;
	}
	elsif($query_gap < $sbjct_gap){
#print STDOUT "TEST_B-> $query_gap, $sbjct_gap, $query_union, $sbjct_union\n";
	    for($j=0; $j<($sbjct_gap - $query_gap); $j++){
		$blank .= ' ';
	    }
#print STDOUT "eXgR-6-3-1\n";
	    for($j=0; $j<length($query_gap_stat); $j++){
		$blank2 .= ' ';
	    }
#print STDOUT "eXgR-6-3-2\n";
	    if($query_union > 0) {
		&alignment_union_check(\$SeqOrBuf[$i],\$SeqOrBuf[$i+1],\$QseqBuf[$i],\$QseqBuf[$i+1],$query_union,
					\$TseqBuf[$i],\$TseqBuf[$i+1]);
	    }
#print STDOUT "eXgR-6-3-3\n";
	    if(($query_gap > 0) & ($sbjct_gap > 0)){
		($updt_flag,$left_or_right) = &update_query_gap_state(\$query_gap_stat,\$sbjct_gap_stat,\$blank2);
	    }
#print STDOUT "eXgR-6-3-4\n";
	    if(($updt_flag == 1) & ($left_or_right == 1)){
		$Qstr = $Qstr . $QseqBuf[$i] . $blank . $query_gap_stat;
		$BARstr = $BARstr . $SeqOrBuf[$i] . $blank . $blank2;
	    }
	    else{
		$Qstr = $Qstr . $QseqBuf[$i] . $query_gap_stat . $blank;
		$BARstr = $BARstr . $SeqOrBuf[$i] . $blank2 . $blank;
	    }
#print STDOUT "eXgR-6-3-5\n";
	    $Tstr = $Tstr . $TseqBuf[$i] . $sbjct_gap_stat;
	}
	elsif($query_gap == $sbjct_gap){
#print STDOUT "TEST_C-> $query_gap, $sbjct_gap\n";
#print STDOUT "TEST_C_1-> $query_union, $sbjct_union\n";
	    if(($query_union > 0) & ($sbjct_union == 0)) {
		&alignment_union_check(\$SeqOrBuf[$i],\$SeqOrBuf[$i+1],\$QseqBuf[$i],\$QseqBuf[$i+1],$query_union,
					\$TseqBuf[$i],\$TseqBuf[$i+1]);
	    }
	    elsif(($sbjct_union > 0) & ($query_union == 0)) {
		&alignment_union_check(\$SeqOrBuf[$i],\$SeqOrBuf[$i+1],\$TseqBuf[$i],\$TseqBuf[$i+1],$sbjct_union,
					\$QseqBuf[$i],\$QseqBuf[$i+1]);
	    }
	    # /* 2002.05.15 add start */
	    elsif(($query_union > 0) & ($sbjct_union > 0)) {
		&alignment_union_check(\$SeqOrBuf[$i],\$SeqOrBuf[$i+1],\$QseqBuf[$i],\$QseqBuf[$i+1],$query_union,
					\$TseqBuf[$i],\$TseqBuf[$i+1]);
		&alignment_union_check(\$SeqOrBuf[$i],\$SeqOrBuf[$i+1],\$TseqBuf[$i],\$TseqBuf[$i+1],$sbjct_union,
					\$QseqBuf[$i],\$QseqBuf[$i+1]);
	    }
	    # /* 2002.05.15 add end */
	    for($j=0; $j<length($query_gap_stat); $j++){
		$blank2 .= ' ';
	    }
	    $Qstr = $Qstr . $QseqBuf[$i] . $query_gap_stat;
	    $BARstr = $BARstr . $SeqOrBuf[$i] . $blank2;
	    $Tstr = $Tstr . $TseqBuf[$i] . $sbjct_gap_stat;
#print STDOUT "TEST_C_2-> $Qstr\n";
#print STDOUT "TEST_C_3-> $Tstr\n";
	}
    }
    ######################################
    ## Alignment Head Make
    ######################################
    {
	$blank = $head_Q_str = $head_T_str = $head_BAR_str = ();
	$head_Q_str = &fasta_head_get($query_fasta_file_path,$QstartBuf[0]);
	$head_T_str = &fasta_head_get($sbjct_fasta_file_path,$TstartBuf[0]);
	if(length($head_Q_str) > length($head_T_str)){
	    $diff_size = length($head_Q_str) - length($head_T_str);
	    for($i=0; $i<$diff_size; $i++){
		$blank .= ' ';
	    }
	    $head_T_str = $blank . $head_T_str;
	    $blank = ();
	    for($i=0; $i<length($head_Q_str); $i++){
		$blank .= ' ';
	    }
	    $head_BAR_str = $blank;
	}
	elsif(length($head_Q_str) < length($head_T_str)){
## /* 2003.07.02 Reprori version make comment start */
##	    ## /* 2003.05.09 chg start */
##	    if($blast_mode eq "n"){
##		$diff_size = length($head_T_str) - length($head_Q_str);
##		$head_T_str = substr($head_T_str,$diff_size,length($head_Q_str));
##		$blank = ();
##		for($i=0; $i<length($head_Q_str); $i++){
##		    $blank .= ' ';
##		}
##		$head_BAR_str = $blank;
##		$sbjct_start_point = $diff_size + 1;
##	    }
##	    elsif($blast_mode eq "p"){
## /* 2003.07.02 Reprori version make comment end */
		$diff_size = length($head_T_str) - length($head_Q_str);
		for($i=0; $i<$diff_size; $i++){
		    $blank .= ' ';
		}
		$head_Q_str = $blank . $head_Q_str;
		$blank = ();
		for($i=0; $i<length($head_T_str); $i++){
		    $blank .= ' ';
		}
		$head_BAR_str = $blank;
		$sbjct_start_point = 1;
## /* 2003.07.02 Reprori version make comment start */
##	    }
##	    ## /* 2003.05.09 chg end */
## /* 2003.07.02 Reprori version make comment end */
	}
	else{
	    ## /* 2003.03.05 add by hatano */
	    if(length($head_Q_str) > 0){
	    	for($i=0; $i<length($head_Q_str); $i++){
		    $blank .= ' ';
	    	}
		$head_BAR_str = $blank;
	    }
	}
#print STDOUT "[diff_size]:$diff_size\n";
#print STDOUT "[head_Q_str  ]:$head_Q_str\n";
#print STDOUT "[head_BAR_str]:$head_BAR_str\n";
#print STDOUT "[head_T_str  ]:$head_T_str\n";
    }
    ######################################
    ## Alignment Tail Make
    ######################################
    {
	$blank = $tail_Q_str = $tail_T_str = $tail_BAR_str = ();
#print STDOUT "TEST_?->$query_fasta_file_path, $QendBuf[$#QendBuf]\n";
	$tail_Q_str = &fasta_tail_get($query_fasta_file_path,$QendBuf[$#QendBuf]);
	$tail_T_str = &fasta_tail_get($sbjct_fasta_file_path,$TendBuf[$#TendBuf]);
	if(length($tail_Q_str) > length($tail_T_str)){
#print STDOUT "TEST_D-> $tail_Q_str, $tail_T_str\n";
	    $diff_size = length($tail_Q_str) - length($tail_T_str);
	    for($i=0; $i<$diff_size; $i++){
		$blank .= ' ';
	    }
#	    $tail_T_str = $blank . $tail_T_str;
	    $tail_T_str = $tail_T_str . $blank;
	    $blank = ();
	    for($i=0; $i<length($tail_Q_str); $i++){
		$blank .= ' ';
	    }
	    $tail_BAR_str = $blank;
	}
	elsif(length($tail_Q_str) < length($tail_T_str)){
#print STDOUT "TEST_E-> $tail_Q_str, $tail_T_str\n";

## /* 2003.07.02 Reprori version make comment start */
##	    if($blast_mode eq "n"){
##		$tail_Q_sz = length($tail_Q_str);
##		$tail_T_str = substr($tail_T_str, 0, $tail_Q_sz);
##	    }
##	    elsif($blast_mode eq "p"){
## /* 2003.07.02 Reprori version make comment end */
		$diff_size = length($tail_T_str) - length($tail_Q_str);
		$blank = ();
		for($i=0; $i<$diff_size; $i++){
		    $blank .= ' ';
		}
		$tail_Q_str = $tail_Q_str . $blank;
		$blank = ();
		for($i=0; $i<length($tail_Q_str); $i++){
		    $blank .= ' ';
		}
		$tail_BAR_str = $blank;
## /* 2003.07.02 Reprori version make comment start */
##	    }
## /* 2003.07.02 Reprori version make comment end */
	}
	else{
#print STDOUT "TEST_F-> $tail_Q_str, $tail_T_str\n";
	    ## /* none */
	}

#print STDOUT "[tail_Q_str  ]:$tail_Q_str\n";
#print STDOUT "[tail_BAR_str]:$tail_BAR_str\n";
#print STDOUT "[tail_T_str  ]:$tail_T_str\n";
    }

    # /* 2003.05.14 chg start */
    $wk_query = $head_Q_str . $Qstr . $tail_Q_str;
    $wk_bar   = $head_BAR_str . $BARstr . $tail_BAR_str;
    $wk_sbjct = $head_T_str . $Tstr . $tail_T_str;
#    $rtn_query = $head_Q_str . $Qstr . $tail_Q_str;
#    $rtn_bar   = $head_BAR_str . $BARstr . $tail_BAR_str;
#    $rtn_sbjct = $head_T_str . $Tstr . $tail_T_str;
    # /* 2003.05.14 chg end */
    # /* 2003.05.14 add */
    ($rtn_query, $rtn_bar, $rtn_sbjct) = &union_padding($wk_query, $wk_bar, $wk_sbjct);

    ## /* 2002.07.04 Reprori version add start */
    if($amino_mode =~ "ON"){
	$q_orf_len = ($qoe - $qos)+1;
	$s_orf_len = ($soe - $sos)+1;
	$q_orf_head_len = $qos - 1;
	$s_orf_head_len = $sos - 1;
	$q_orf_tail_len = $qlen - ($q_orf_head_len + $q_orf_len);
	$s_orf_tail_len = $slen - ($s_orf_head_len + $s_orf_len);
	$q_orfline_wk = &fasta_gap_get($query_fasta_file_path,$qos-1,$q_orf_len);
	$s_orfline_wk = &fasta_gap_get($sbjct_fasta_file_path,$sos-1,$s_orf_len);
	($q_orfline_wk3,$s_orfline_wk3) = &orf_convert($q_orfline_wk,$s_orfline_wk);
	## Query ORF Line make
	for($i=0; $i<$q_orf_head_len; $i++){
	    $q_orfline_wk2 .= ' ';
	}
	$q_orfline_wk2 .= $q_orfline_wk3;
	for($i=0; $i<$q_orf_tail_len; $i++){
	    $q_orfline_wk2 .= ' ';
	}
	## Sbjct ORF Line make
	for($i=0; $i<$s_orf_head_len; $i++){
	    $s_orfline_wk2 .= ' ';
	}
	$s_orfline_wk2 .= $s_orfline_wk3;
	for($i=0; $i<$s_orf_tail_len; $i++){
	    $s_orfline_wk2 .= ' ';
	}
	($q_orfline,$s_orfline) = &orf_line_make($q_orfline_wk2,$s_orfline_wk2,$rtn_query,$rtn_sbjct);
    }
    ## /* 2002.07.04 Reprori version add end */

#print STDOUT "[Qstr  ]:$Qstr\n";
#print STDOUT "[BARstr]:$BARstr\n";
#print STDOUT "[Tstr  ]:$Tstr\n";
#print STDOUT "[Qorf  ]:$q_orfline\n";
#print STDOUT "[Qstr  ]:$rtn_query\n";
#print STDOUT "[BARstr]:$rtn_bar\n";
#print STDOUT "[Tstr  ]:$rtn_sbjct\n";
#print STDOUT "[Sorf  ]:$s_orfline\n";

#print STDOUT "SBJCT_START_POINT-> $sbjct_start_point\n";
#print STDOUT "eXgR-6-4\n";
    return($rtn_query,$rtn_bar,$rtn_sbjct,$query_start_point,$sbjct_start_point,
           $q_orfline,$s_orfline); ## /* 2002.07.04 Reprori version chg */
}
###############################################################################
sub fasta_gap_get {
    ($fasta_file_path,$start_p,$gap_size) = @_;

    my($line);
    my($info);
    my($rtn_str);

    $line = $info = $rtn_str = ();

    open(FASTA,"<$fasta_file_path") || die "No $fasta_file_path.";
    while($line = <FASTA>){
	chomp($line);
	if($line =~ /^\>/) {
	    next;
	}
	$info .= $line;
    }
    close(FASTA);

    $rtn_str = substr($info, $start_p, $gap_size);

    return $rtn_str;
}
###############################################################################
sub fasta_head_get {
    ($fasta_file_path,$start_p) = @_;

    my($line);
    my($info);
    my($size);
    my($rtn_str);

    $line = $info = $size = $rtn_str = ();

    $size = $start_p - 1;

    open(FASTA,"<$fasta_file_path") || die "No $fasta_file_path.";
    while($line = <FASTA>){
	chomp($line);
	if($line =~ /^\>/) {
	    next;
	}
	$info .= $line;
    }
    close(FASTA);

    $rtn_str = substr($info, 0, $size);

    return $rtn_str;
}
###############################################################################
sub fasta_tail_get {
    ($fasta_file_path,$start_p) = @_;

    my($line);
    my($info);
    my($size);
    my($rtn_str);

    $line = $info = $size = $rtn_str = ();

    open(FASTA,"<$fasta_file_path") || die "No $fasta_file_path.";
    while($line = <FASTA>){
	chomp($line);
	if($line =~ /^\>/) {
	    next;
	}
	$info .= $line;
    }
    close(FASTA);

    $size = length($info) - $start_p;

    $rtn_str = substr($info, $start_p, $size);

    return $rtn_str;
}
###############################################################################
sub alignment_union_check {
    ($SeqOrBuf_1,$SeqOrBuf_2,$SeqBuf_1,$SeqBuf_2,$union_count,$OObuf1,$OObuf2) = @_;

    my($left_last_bar_pos,$left_start_bar_pos,$left_last_bar);
    my($right_first_bar_pos,$right_first_bar);
    my($n);
    my($bar_char);
    my($blank);
    my($work);
    ## /* 2003.05.09 add start */
    my($update_count, $i, $eiji_count, $blank_count);
    my($char);
    ## /* 2003.05.09 add end */

    $left_last_bar_pos = length($$SeqOrBuf_1) - 1;
    $left_start_bar_pos = $left_last_bar_pos - $union_count;
    $left_last_bar = substr($$SeqOrBuf_1, $left_start_bar_pos, $union_count);

    $right_first_bar_pos = 0;
    $right_first_bar = substr($$SeqOrBuf_2, $left_last_bar_pos, $union_count);

    for($n=0; $n<length($left_last_bar); $n++){
        $bar_char = substr($left_last_bar, $n, 1);
        if($bar_char eq /\|/){
	    $left_last_bar_cnt++;
        }
    }
    for($n=0; $n<length($right_first_bar); $n++){
        $bar_char = substr($right_first_bar, $n, 1);
        if($bar_char eq /\|/){
	    $right_first_bar_cnt++;
        }
    }

#    $blank = ();
#    for($n=0; $n<$union_count; $n++){
#	$blank .= ' ';
#    }

    ######################################
    ## Change Blank 
    ######################################
    if($left_last_bar_cnt >= $right_first_bar_cnt){
	## /* 2003.05.09 add start */
	$i = 0;
	$eiji_count = $blank_count = 0;
#print STDOUT "eiji_count:$eiji_count\n";
#print STDOUT "union_count:$union_count\n";
#print STDOUT "TEST_LEFT\n";
	while($eiji_count < $union_count){
#	while($blank_count < $union_count){
#	for($i=0; $i<$union_count;$i++){
	    $char = substr($$SeqBuf_2, $i, 1);
	    if($char =~ /[A-Za-z]/){
#print STDOUT "$char";
		$eiji_count++;
	    }
	    $i++;
	    $blank_count++;
#print STDOUT "eiji_count:$eiji_count\n";
#print STDOUT "union_count:$union_count\n";
	}
#print STDOUT "blank_count:$blank_count\n";
	$blank = ();
	for($n=0; $n<$blank_count; $n++){
	    $blank .= ' ';
	}
	## /* 2003.05.09 add end */
        substr($$SeqOrBuf_2, 0, $blank_count, $blank);
        substr($$SeqBuf_2, 0, $blank_count, $blank);
	$work = substr($$OObuf2, 0, $blank_count);
	$work = uc($work);
#print STDOUT "\nWORK1:$work\n";
        substr($$OObuf2, 0, $blank_count, $work);
    }
    else{
	## /* 2003.05.09 add start */
	$i = $left_start_bar_pos;
	$eiji_count = $blank_count = 0;
#print STDOUT "TEST_RIGHT\n";
	while($eiji_count < $union_count){
#	while($blank_count < $union_count){
#	for($i=0; $i<$union_count;$i++){
	    $char = substr($$SeqBuf_2, $i, 1);
	    if($char =~ /[A-Za-z]/){
#print STDOUT "$char";
		$eiji_count++;
	    }
	    $i++;
	    $blank_count++;
	}
#print STDOUT "blank_count:$blank_count\n";
	$blank = ();
	for($n=0; $n<$blank_count; $n++){
	    $blank .= ' ';
	}
	## /* 2003.05.09 add end */
        substr($$SeqOrBuf_1, $left_start_bar_pos, $blank_count, $blank);
        substr($$SeqBuf_1, $left_start_bar_pos, $blank_count, $blank);
	$work = substr($$OObuf1, $left_start_bar_pos, $blank_count);
	$work = uc($work);
#print STDOUT "\nWORK2:$work\n";
        substr($$OObuf1, $left_start_bar_pos, $blank_count, $work);
    }
}
###############################################################################
sub update_query_gap_state {
    ($query_gap_stat,$sbjct_gap_stat,$blank) = @_;

    my($update_flag,$laft_or_right);
    my($q_length,$s_length,$b_length);
    my($i);
    my($work);

    $update_flag = $left_or_right = 0;
    $q_length = $s_length = $b_length = 0;
    $work = ();

    $q_length = length($$query_gap_stat);
    $s_length = length($$sbjct_gap_stat);
    $b_length = length($$blank);

    $left_str  = substr($$sbjct_gap_stat, 0, $q_length);
    $right_str = substr($$sbjct_gap_stat, ($s_length - $q_length),$q_length);

    if(($$query_gap_stat eq $left_str) & ($$query_gap_stat eq $right_str)){
#print "TEST_A_1, $$query_gap_stat, $left_str, $right_str\n";
	$update_flag = 0;
    }
    elsif($$query_gap_stat eq $left_str){
#print "TEST_B_1, $$query_gap_stat, $left_str, $right_str\n";
	$update_flag = 1;
	$left_or_right = 0;
	$left_str  = lc($left_str);

	substr($$query_gap_stat,0,$q_length,$left_str);
	substr($$sbjct_gap_stat,0,$q_length,$left_str);

	for($i=0; $i<$b_length; $i++){
	    $work .= '|';
	}
	substr($$blank,0,$b_length,$work);
    }
    elsif($query_gap_stat eq $right_str){
#print "TEST_C_1, $$query_gap_stat, $left_str, $right_str\n";
	$update_flag = 1;
	$left_or_right = 1;
	$right_str = lc($right_str);

	substr($$query_gap_stat,($s_length - $q_length)-1,$q_length,$right_str);
	substr($$sbjct_gap_stat,($s_length - $q_length)-1,$q_length,$right_str);

	for($i=0; $i<$b_length; $i++){
	    $work .= '|';
	}
	substr($$blank,0,$b_length,$work);
    }
    else{
#print "TEST_D_1, $$query_gap_stat, $left_str, $right_str\n";
	$update_flag = 0;
    }

    return($update_flag,$laft_or_right);
}
###############################################################################
sub update_sbjct_gap_state {
    ($query_gap_stat,$sbjct_gap_stat,$blank) = @_;

    my($update_flag,$laft_or_right);
    my($q_length,$s_length,$b_length);
    my($i);
    my($work);

    $update_flag = $left_or_right = 0;
    $q_length = $s_length = $b_length = 0;
    $work = ();

    $q_length = length($$query_gap_stat);
    $s_length = length($$sbjct_gap_stat);
    $b_length = length($$blank);

    $left_str  = substr($$query_gap_stat, 0, $s_length);
    $right_str = substr($$query_gap_stat, ($q_length - $s_length),$s_length);

    if(($$sbjct_gap_stat eq $left_str) & ($$sbjct_gap_stat eq $right_str)){
#print "TEST_A_2, $$sbjct_gap_stat, $left_str, $right_str\n";
	$update_flag = 0;
    }
    elsif($$sbjct_gap_stat eq $left_str){
#print "TEST_B_2, $$sbjct_gap_stat, $left_str, $right_str\n";
	$update_flag = 1;
	$left_or_right = 0;
	$left_str  = lc($left_str);

	substr($$query_gap_stat,0,$s_length,$left_str);
	substr($$sbjct_gap_stat,0,$s_length,$left_str);

	for($i=0; $i<$b_length; $i++){
	    $work .= '|';
	}
	substr($$blank,0,$b_length,$work);
    }
    elsif($sbjct_gap_stat eq $right_str){
#print "TEST_C_2, $$sbjct_gap_stat, $left_str, $right_str\n";
	$update_flag = 1;
	$left_or_right = 1;
	$right_str = lc($right_str);

	substr($$query_gap_stat,($q_length - $s_length)-1,$s_length,$right_str);
	substr($$sbjct_gap_stat,($q_length - $s_length)-1,$s_length,$right_str);

	for($i=0; $i<$b_length; $i++){
	    $work .= '|';
	}
	substr($$blank,0,$b_length,$work);
    }
    else{
#print "TEST_D_2, $$sbjct_gap_stat, $left_str, $right_str\n";
	$update_flag = 0;
    }

    return($update_flag,$laft_or_right);
}
###############################################################################
sub num_line_make {
    ($query_line,$sbjct_line,$query_start_pos,$sbjct_start_pos) = @_;

    my($q_num_line,$s_num_line);
    my($c);
    my($number);
    my($enter_cnt,$alignment_cnt,$moji_cnt);
    my($i,$n,$first_blank_cnt);

    $c = $number = ();
    $q_num_line = $s_num_line = ();

    $moji_cnt = $query_start_pos - 1;
#    for($i=0,$moji_cnt=0; $i<length($query_line); $i++){
    for($i=0; $i<length($query_line); $i++){
	if(($i % 100) == 0){
	    $q_num_line .= '          ';
	}
	$c = substr($query_line, $i, 1);
	if($c =~ /[A-Za-z]/){
	    $moji_cnt++;
	    if(($moji_cnt % 10) == 0){
		$number = sprintf("%10d", $moji_cnt);
		$q_num_line .= $number;
	    }
	}
	elsif($c =~ /\s/){
	    $q_num_line .= ' ';
	}
	elsif($c =~ /\-/){
	    $q_num_line .= ' ';
	}
    }

    $moji_cnt = $sbjct_start_pos - 1;
    if($moji_cnt != 0){
	$first_blank_cnt = 10 - ($moji_cnt % 10);
    }
    else{
	$first_blank_cnt = 10;
    }
#    for($i=0,$moji_cnt=0; $i<length($sbjct_line); $i++){
    for($i=0; $i<length($sbjct_line); $i++){
	if($i == 0){
	    for($n=0; $n<$first_blank_cnt; $n++){
		$s_num_line .= ' ';
	    }
	}
	else{
	    if(($i % 100) == 0){
		$s_num_line .= '          ';
	    }
	}
	$c = substr($sbjct_line, $i, 1);
	if($c =~ /[A-Za-z]/){
	    $moji_cnt++;
	    if(($moji_cnt % 10) == 0){
		$number = sprintf("%10d", $moji_cnt);
		$s_num_line .= $number;
	    }
	}
	elsif($c =~ /\s/){
	    $s_num_line .= ' ';
	}
	elsif($c =~ /\-/){
	    $s_num_line .= ' ';
	}
    }

    return($q_num_line,$s_num_line);
}
###############################################################################
sub check_identities {
    ($bar_line) = @_;

    my($i);
    my($c);
    my($all_cnt,$identities_cnt);

    $all_cnt = $identities_cnt= 0;

    for($i=0; $i<length($bar_line); $i++){
	$c = substr($bar_line, $i, 1);
	if($c !~ /\s/){
	    if($c =~ /\|/){
		$identities_cnt++;
	    }
	    $all_cnt++;
	}
    }
    return($all_cnt,$identities_cnt);
}
###############################################################################
sub check_gaps {
    ($bar_line) = @_;

    my($i);
    my($c);
    my($all_cnt,$gaps_cnt);

    $all_cnt = $gaps_cnt= 0;

    for($i=0; $i<length($bar_line); $i++){
	$c = substr($bar_line, $i, 1);
	if($c !~ /\s/){
	    if($c =~ /\*/){
		$gaps_cnt++;
	    }
	    $all_cnt++;
	}
    }
    return($all_cnt,$gaps_cnt);
}
###############################################################################
sub alignment_cmp {
    ($query_line,$sbjct_line,$query_start_pos,$sbjct_start_pos,
     $query_fasta_file_path,$sbjct_fasta_file_path) = @_;

    my($q_line,$s_line);
    my($q_len,$s_len);
    my($q_fasta,$s_fasta);
    my($q_work,$s_work);
    my($i,$c,$c1,$c2);
    my($line);
    my($result);

    $q_line = $s_line = $c = $line = ();
    $q_len = $s_len = 0;
    $q_fasta = $s_fasta = ();
    $q_work = $s_work = ();
    $result = "OK";

    for($i=0; $i<length($query_line); $i++){
	$c = substr($query_line, $i, 1);
	$c = uc($c);
	if($c !~ /\s/ && $c !~ /\-/){
	    $q_line .= $c;
	}
    }
    $q_len = length($q_line);

    for($i=0; $i<length($sbjct_line); $i++){
	$c = substr($sbjct_line, $i, 1);
	$c = uc($c);
	if($c !~ /\s/ && $c !~ /\-/){
	    $s_line .= $c;
	}
    }
    $s_len = length($s_line);

    open(Q_FASTA,"<$query_fasta_file_path") || die "No $query_fasta_file_path.";
    while($line = <Q_FASTA>){
	chomp($line);
	if($line =~ /^\>/) {
	    next;
	}
	$q_work .= uc($line);
    }
    close(Q_FASTA);

    open(S_FASTA,"<$sbjct_fasta_file_path") || die "No $sbjct_fasta_file_path.";
    while($line = <S_FASTA>){
	chomp($line);
	if($line =~ /^\>/) {
	    next;
	}
	$s_work .= uc($line);
    }
    close(S_FASTA);

    $q_fasta = substr($q_work, $query_start_pos-1, $q_len);
    $s_fasta = substr($s_work, $sbjct_start_pos-1, $s_len);

    for($i=0; $i<length($q_line); $i++){
	$c1 = substr($q_line, $i, 1);
	$c2 = substr($q_fasta, $i, 1);
	if ($c1 !~ $c2){
#	    open(NG_FILE,">>$error_file") || die "No $error_file.";
	    print NG_FILE "<<<<<<<<<< Query Compare Check is NG. >>>>>>>>>>\n";
	    print NG_FILE "$query_fasta_file_path, $sbjct_fasta_file_path\n";
	    print NG_FILE "[q_line ]:$q_line\n";
	    print NG_FILE "[q_fasta]:$q_fasta\n";
#	    close(NG_FILE);
	    $result = "NG";
	    #print "<<<<<< QUERY MAKE-ALIGNMENT IS NG. >>>>>>\n";
	    $error_count++;
	    goto END;
	}
    }
    for($i=0; $i<length($s_line); $i++){
	$c1 = substr($s_line, $i, 1);
	$c2 = substr($s_fasta, $i, 1);
	if ($c1 !~ $c2){
#	    open(NG_FILE,">>$error_file") || die "No $error_file.";
	    print NG_FILE "<<<<<<<<<< Sbjct Compare Check is NG. >>>>>>>>>>\n";
	    print NG_FILE "$query_fasta_file_path, $sbjct_fasta_file_path\n";
	    print NG_FILE "[s_line ]:$s_line\n";
	    print NG_FILE "[s_fasta]:$s_fasta\n";
#	    close(NG_FILE);
	    #print "<<<<<< SBJCT MAKE-ALIGNMENT IS NG. >>>>>>\n";
	    $result = "NG";
	    $error_count++;
	    goto END;
	}
    }

END:
    return($result);
}
###############################################################################
sub ss_fasta_create {
    ($s_line,$s_path,$work_dir,$bar_line,$query_id) = @_;

    my($s_dir);
    my($s_file);
    my($dummy);
    my($ss_fasta_path);
    my($ss_line);
    my(@SSPLIT,@POS);
    my($len,$count,$i,$pos_wk,$align_cnt);
    my($chr);
    my($wk_len);

    $s_dir = $s_file = $ss_fasta_path = $ss_line = $chr = ();
    @SSPLIT = @POS = ();
    @pos_wk = 0;
    $count = $align_cnt = $wk_len = 0;

    $s_dir  = $work_dir . '/SSFASTA/';
    $s_file = basename($s_path);
    ($s_file,$dummy) = split(/\./, $s_file);

    $len = length($bar_line);
    for($i=0; $i<$len; $i++){
	$chr = substr($bar_line, $i, 1);
	if($chr eq '*'){
	    $count++;
	}
    }
    for($i=0; $i<$count; $i++,$pos_wk++){
	$pos_wk = index($bar_line, "*", $pos_wk);
	$POS[$i] = $pos_wk;
    }

    $ss_line = $s_line;

    for($i=0; $i<$count; $i++){
	$chr = substr($ss_line,$POS[$i],1);
	$chr = lc($chr);
	substr($ss_line,$POS[$i],1,$chr);
    }

    $ss_line =~ s/[A-Z]/\ /g;

    @SSPLIT = split(/\ +/, $ss_line);
    $wk_len = length($SSPLIT[0]);
    if($wk_len == 0){
	$dummy_wk = shift(@SSPLIT);
    }

    if(!-d $s_dir){
	mkdir "$s_dir", 0777 or die "mkdir error!:$s_dir.\n";
    }

    $align_cnt = $#SSPLIT;
    for($i=0; $i<=$align_cnt; $i++){
	$SSPLIT[$i] = uc($SSPLIT[$i]);
	$ss_fasta_path = sprintf("%s%s_SS_%02d.txt", $s_dir, $query_id, $i+1);
	open(SSWORK,">$ss_fasta_path") || die "No $ss_fasta_path.";
	print SSWORK "$SSPLIT[$i]";
	close(SSWORK);
    }
}
###############################################################################
sub union_padding {
    my($q_line,$b_line,$s_line) = @_;

    my($rtn_query, $rtn_bar, $rtn_sbjct);
    my($len, $i);
    my($chr);

    $rtn_query = $rtn_bar = $rtn_sbjct = ();
    $qchr = $bchr = $schr = ();
    $len = $i = 0;

    #print STDOUT "Q1:$q_line\n";
    #print STDOUT "B1:$b_line\n";
    #print STDOUT "S1:$s_line\n";
    $len = length($q_line);
    for($i=0; $i<$len; $i++){
	$qchr = substr($q_line, $i, 1);
	$bchr = substr($b_line, $i, 1);
	$schr = substr($s_line, $i, 1);
	# /* When '-' */
	if($qchr =~ /\-/){
	    if($schr !~ /\ /){
		$rtn_query .= $qchr;
		$rtn_bar   .= $bchr;
		$rtn_sbjct .= $schr;
	    }
	}
	elsif($schr =~/\-/){
	    if($qchr !~ /\ /){
		$rtn_query .= $qchr;
		$rtn_bar   .= $bchr;
		$rtn_sbjct .= $schr;
	    }
	}
	elsif($qchr =~ /\ /){
	    if($schr !~ /\ /){
		$rtn_query .= $qchr;
		$rtn_bar   .= $bchr;
		$rtn_sbjct .= $schr;
	    }
	}
	elsif($schr =~ /\ /){
	    if($qchr !~ /\ /){
		$rtn_query .= $qchr;
		$rtn_bar   .= $bchr;
		$rtn_sbjct .= $schr;
	    }
	}
	else{
	    $rtn_query .= $qchr;
	    $rtn_bar   .= $bchr;
	    $rtn_sbjct .= $schr;
	}
    }

    #print STDOUT "Q2$rtn_query\n";
    #print STDOUT "B2$rtn_bar\n";
    #print STDOUT "S2$rtn_sbjct\n";
    return($rtn_query, $rtn_bar, $rtn_sbjct);
}
## /* 2002.07.07 Reprori version add */
###############################################################################
sub orf_line_make {
    ($qol,$sol,$qal,$sal) = @_;

    my($rtn_qol,$rtn_sol);
    my($len, $i, $align_cnt);
    my($chr, $ochr);

    $rtn_qol = $rtn_sol = ();
    $chr = $ochr = ();
    $len = 0;

    # Query ORF LINE
    $len = length($qal);
    for($i=0,$align_cnt=0; $i<$len; $i++){
	$chr = substr($qal, $i, 1);
	# When '-' or ' '
	if($chr =~ /\-/ || $chr =~ /\ /){
	    $ochr = ' ';
	}
	# When Not '-' and ' '
	else{
	    $ochr = substr($qol, $align_cnt, 1);
	    $align_cnt++;
	}
	$rtn_qol .= $ochr;
    }

    # Sbjct ORF LINE
    $chr = $ochr = ();
    $len = length($sal);
    for($i=0,$align_cnt=0; $i<$len; $i++){
	$chr = substr($sal, $i, 1);
	# When '-' or ' '
	if($chr =~ /\-/ || $chr =~ /\ /){
	    $ochr = ' ';
	}
	# When Not '-' and ' '
	else{
	    $ochr = substr($sol, $align_cnt, 1);
	    $align_cnt++;
	}
	$rtn_sol .= $ochr;
    }

    return($rtn_qol, $rtn_sol);

}
## /* 2002.07.07 Reprori version add */
###############################################################################
sub orf_convert {
    ($q_orfline,$s_orfline) = @_;

    my($rtn_q,$rtn_s);
    my($buf);
    my($i);
    my($orf_code);

    $rtn_q = $rtn_s = $buf = $orf_code = ();

    for($i=0; $i<length($q_orfline); $i+=3){
	$buf = substr($q_orfline, $i, 3);
	if(length($buf) == 3){
	    $orf_code = $OrfCode{$buf};		# 2004.01.21 add by hatano.
	    if($orf_code eq ""){		# 2004.01.21 add by hatano.
		$orf_code = "N";		# 2004.01.21 add by hatano.
	    }					# 2004.01.21 add by hatano.
	    $rtn_q .= "(" . $orf_code . ")";	# 2004.01.21 chg by hatano.
	}
    }
#print STDOUT "rtn_q:$rtn_q($q_orfline)$i\n";
    $buf = ();
    for($i=0; $i<length($s_orfline); $i+=3){
	$buf = substr($s_orfline, $i, 3);
	if(length($buf) == 3){
	    $orf_code = $OrfCode{$buf};		# 2004.01.21 add by hatano.
	    if($orf_code eq ""){		# 2004.01.21 add by hatano.
		$orf_code = "N";		# 2004.01.21 add by hatano.
	    }					# 2004.01.21 add by hatano.
	    $rtn_s .= "(" . $orf_code . ")";	# 2004.01.21 chg by hatano.
	}
    }
#print STDOUT "rtn_s:$rtn_s($s_orfline)$i\n";

    return($rtn_q, $rtn_s);
}
###############################################################################
sub make_orf_code_table {

    $OrfCode{"TTT"} = "F";
    $OrfCode{"TTC"} = "F";
    $OrfCode{"TTA"} = "L";
    $OrfCode{"TTG"} = "L";
    $OrfCode{"TCT"} = "S";
    $OrfCode{"TCC"} = "S";
    $OrfCode{"TCA"} = "S";
    $OrfCode{"TCG"} = "S";
    $OrfCode{"TAT"} = "Y";
    $OrfCode{"TAC"} = "Y";
    $OrfCode{"TAA"} = "-";
    $OrfCode{"TAG"} = "-";
    $OrfCode{"TGT"} = "C";
    $OrfCode{"TGC"} = "C";
    $OrfCode{"TGA"} = "-";
    $OrfCode{"TGG"} = "W";
    $OrfCode{"CTT"} = "L";
    $OrfCode{"CTC"} = "L";
    $OrfCode{"CTA"} = "L";
    $OrfCode{"CTG"} = "L";
    $OrfCode{"CCT"} = "P";
    $OrfCode{"CCC"} = "P";
    $OrfCode{"CCA"} = "P";
    $OrfCode{"CCG"} = "P";
    $OrfCode{"CAT"} = "H";
    $OrfCode{"CAC"} = "H";
    $OrfCode{"CAA"} = "Q";
    $OrfCode{"CAG"} = "Q";
    $OrfCode{"CGT"} = "R";
    $OrfCode{"CGC"} = "R";
    $OrfCode{"CGA"} = "R";
    $OrfCode{"CGG"} = "R";
    $OrfCode{"ATT"} = "I";
    $OrfCode{"ATC"} = "I";
    $OrfCode{"ATA"} = "I";
    $OrfCode{"ATG"} = "M";
    $OrfCode{"ACT"} = "T";
    $OrfCode{"ACC"} = "T";
    $OrfCode{"ACA"} = "T";
    $OrfCode{"ACG"} = "T";
    $OrfCode{"AAT"} = "N";
    $OrfCode{"AAC"} = "N";
    $OrfCode{"AAA"} = "K";
    $OrfCode{"AAG"} = "K";
    $OrfCode{"AGT"} = "S";
    $OrfCode{"AGC"} = "S";
    $OrfCode{"AGA"} = "R";
    $OrfCode{"AGG"} = "R";
    $OrfCode{"GTT"} = "V";
    $OrfCode{"GTC"} = "V";
    $OrfCode{"GTA"} = "V";
    $OrfCode{"GTG"} = "V";
    $OrfCode{"GCT"} = "A";
    $OrfCode{"GCC"} = "A";
    $OrfCode{"GCA"} = "A";
    $OrfCode{"GCG"} = "A";
    $OrfCode{"GAT"} = "D";
    $OrfCode{"GAC"} = "D";
    $OrfCode{"GAA"} = "E";
    $OrfCode{"GAG"} = "E";
    $OrfCode{"GGT"} = "G";
    $OrfCode{"GGC"} = "G";
    $OrfCode{"GGA"} = "G";
    $OrfCode{"GGG"} = "G";
}
###############################################################################
sub html_query_align_line_make() {
    my($qlt, $qs, $qe, $cnt) = @_;

    my($query_html_line, $c) = ();
    my($start_draw_flg, $end_draw_flg) = 0;
    my($i) = 0;

    for($i=0; $i<length($$qlt); $i++){
	$c = substr($$qlt, $i, 1);
	if($c =~ /\ /){
	    if($$cnt > $qs-1 && $$cnt < $qe-1){
		if($start_draw_flg == 1){
		    $query_html_line .= "</span>";
		    $start_draw_flg = 0;
		    $end_draw_flg = 1;
		}
	    }
	    $query_html_line .= $c;
	}
	elsif($c =~ /\-/){ # 2004.01.21 add by hatano
	    if($$cnt > $qs-1 && $$cnt < $qe-1){
		if($start_draw_flg == 1){
		    $query_html_line .= "</span>";
		    $start_draw_flg = 0;
		    $end_draw_flg = 1;
		}
	    }
	    $query_html_line .= $c;
	}
	else{
	    if($$cnt == $qs-1){
		$query_html_line .= "<span style=\"background-color:#E9CC67\">";
		$query_html_line .= $c;
		$start_draw_flg = 1;
		$end_draw_flg = 0;
	    }
	    elsif($$cnt == $qe-1){
		$query_html_line .= $c;
		$query_html_line .= "</span>";
		$start_draw_flg = 0;
		$end_draw_flg = 1;
	    }
	    elsif($$cnt > $qs-1 && $$cnt < $qe-1){
		if($start_draw_flg == 0){
		    $query_html_line .= "<span style=\"background-color:#E9CC67\">";
		    $start_draw_flg = 1;
		    $end_draw_flg = 0;
		}
		$query_html_line .= $c;
	    }
	    else{
		$query_html_line .= $c;
	    }
	    if($i+1 == length($$qlt)){
		if($start_draw_flg == 1 && $end_draw_flg == 0){
		    $query_html_line .= "</span>";
		}
	    }
	    $$cnt++;
	}
    }

    return($query_html_line);
}
###############################################################################
sub html_sbjct_align_line_make() {
    my($slt, $ss, $se, $cnt) = @_;

    my($sbjct_html_line, $c) = ();
    my($start_draw_flg, $end_draw_flg) = 0;
    my($i) = 0;

#print STDOUT "CNT:[$$cnt]\n";
    for($i=0; $i<length($$slt); $i++){
	$c = substr($$slt, $i, 1);
	if($c =~ /\ /){
	    if($$cnt > $ss-1 && $$cnt < $se-1){
		if($start_draw_flg == 1){
		    $sbjct_html_line .= "</span>";
		    $start_draw_flg = 0;
		    $end_draw_flg = 1;
		}
	    }
	    $sbjct_html_line .= $c;
	}
	elsif($c =~ /\-/){ # 2004.01.21 add by hatano.
	    if($$cnt > $ss-1 && $$cnt < $se-1){
		if($start_draw_flg == 1){
		    $sbjct_html_line .= "</span>";
		    $start_draw_flg = 0;
		    $end_draw_flg = 1;
		}
	    }
	    $sbjct_html_line .= $c;
	}
	else{
	    if($$cnt == $ss-1){
#		$sbjct_html_line .= "<span style=\"background-color:#C6BAD8\">";
#		$sbjct_html_line .= "<span style=\"background-color:#E4A4EE\">";
		$sbjct_html_line .= "<span style=\"background-color:#F0C9FA\">";
		$sbjct_html_line .= $c;
		$start_draw_flg = 1;
		$end_draw_flg = 0;
	    }
	    elsif($$cnt == $se-1){
		$sbjct_html_line .= $c;
		$sbjct_html_line .= "</span>";
		$start_draw_flg = 0;
		$end_draw_flg = 1;
	    }
	    elsif($$cnt > $ss-1 && $$cnt < $se-1){
		if($start_draw_flg == 0){
#		    $sbjct_html_line .= "<span style=\"background-color:#C6BAD8\">";
#		    $sbjct_html_line .= "<span style=\"background-color:#E4A4EE\">";
		    $sbjct_html_line .= "<span style=\"background-color:#F0C9FA\">";
		    $start_draw_flg = 1;
		    $end_draw_flg = 0;
		}
		$sbjct_html_line .= $c;
	    }
	    else{
		$sbjct_html_line .= $c;
	    }
	    if($i+1 == length($$slt)){
		if($start_draw_flg == 1 && $end_draw_flg == 0){
		    $sbjct_html_line .= "</span>";
		}
	    }
	    $$cnt++;
	}
    }

    return($sbjct_html_line);
}
## /* 2002.09.11 Reprori version add */
###############################################################################
sub EN_search {
    ($line,$startp) = @_;

    my($rtn_pos);
    my($work, $buf, $diff_sz, $buf_len, $ORF_info);
    my($i);

    $rtn_pos = $diff_sz = $buf_len = 0;
    $work = $buf = $ORF_info = ();

    $diff_sz = length($line) - ($startp - 1);
    $work = substr($line, $startp-1, $diff_sz);

    $rtn_pos = $startp - 1;

    for($i=0; $i<=$diff_sz; $i+=3){
	$buf = substr($work, $i, 3);
	$buf_len = length($buf);
	if($buf_len == 3){
	    $ORF_info = "(" . $OrfCode{$buf} . ")";
	    $rtn_pos = $rtn_pos + $buf_len;
	    if($ORF_info =~ /\-/){
		last;
	    }
	}
	else{
	    $rtn_pos = $rtn_pos + $buf_len;
	    last;
	}
    }

    return($rtn_pos);
}
## /* 2005.11.22 Reprori version add */
###############################################################################
sub BgTrim {
    my @out = @_;
    for (@out) {
	s/^\s+//;
	s/\s+$//;
    }
    return wantarray ? @out : $out[0];
}
sub BgPerm {
    my @out = @_;
    for (@out) {
	s/\s+/\_/g;
    }
    return wantarray ? @out : $out[0];
}
#---
