#!/usr/bin/perl
################################################################################
################################################################################
##                                                                            ##
##           ALVISION_MULTI -- Global Viewer of Local Alignment               ##
##                                                                            ##
################################################################################
################################################################################
#
### ALVISION_MULTI.pl ###
##
# Created by N.Hatano (Last renewal date : 2005.09.28).
#
# 03/02/21: ver0.0
# 03/03/10: ver0.1
# 03/03/11: ver1.0
# 03/04/03: ver1.1
# 03/05/16: ver2.0
# 03/06/09: ver2.1
# 03/08/21: ReProRi ver2.2
# 03/10/16: ReProRi ver2.3
# 03/10/22: ReProRi ver2.3.1 Bug fix.
# 04/01/21: ReProRi ver2.3.2 Bug fix.
# 04/01/22: ReProRi ver2.3.3 ʕύX̑.
# 05/02/09: ReProRi ver2.3.3a Buf fix(encode).
# 05/09/28: ReProRi ver2.3.4 Insert,Deletion,Subst񃊃Xg쐬@\ǉ.
# 05/09/28: ReProRi ver2.3.4 Perl Version 5.8.6ȏΉ.
#

$|=1;

use Tk;
use Encode; # 2005.02.09 add
use Tk::LabFrame; # 2004.01.22 add
use Cwd;
use File::Basename;
use OLE;
#use PDFJ 'SJIS';
#use strict;

################################################################################
## GUI procedure use.                                                         ##
################################################################################
#
## /* Message */ ##
$msg="";
## /* Scale of Expect-value */ ##
$blastn_scale_value=50;
$blastp_scale_value=50;
## /* Init file */ ##
$INI_FILE = "./alignment_tool.ini";
&init_comp_value_get($INI_FILE);
## /* Output Mode */ ##
$output_mode='';
## /* SS Fasta Mode */ ##
$ss_fasta_mode='0';
## /* blast Mode */ ##
$blast_mode='n';
## /* 萔 */ ##
$filetypes = [["Text  file", '.txt'],
	      ["PDF   file", '.pdf'],
	      ["Fasta file", '.fasta'],
	      ["Seq   file", '.seq'],
	      ["All files",  '*'  ]];
$path_name = "$ENV{'HOME'}";
$dir_nm = "";
## /* t@C */ ##
$file_path_text="";
$file_path_pdf="";
$file_path_blastn="";
$file_path_blastp="";
$file_path_amino=""; ## /* 2003.10.16 add */
$input_file_nm= "";
$ng_file= "";
## /* Working mode - Reprori version use */ ##
$work_mode="ALIGN";
$amino_mode="OFF";
$output_tbl_path="";
@OrfCode=();

################################################################################
## Alignment main procedure use.                                              ##
################################################################################
#
## /*---- INIT OPTION ----*/ ##
my($home_dir);
my($work_dir);
my($input_file);
my($bl2seq_cmd_path);
my($pdf_cnv_cmd_path);
my($comp_value);
my($comp_value_n);
my($comp_value_p);
my($align_ss_fasta_mode);
my($error_file);
my($error_count);
## /*---- ERROR COUNT ----*/ ##
$error_count = 0;
## /*---- Query & Sbjct File INFO ----*/ ##
my(@QUERY_ITEMS, @SBJCT_ITEMS);
my(@QUERY_ORF_START, @QUERY_ORF_END); ## /* 2002.07.03 Reprori version */ ##
my(@SBJCT_ORF_START, @SBJCT_ORF_END);
## /*---- PDF WRITE MODE ----*/ ##
my($pdf_flag);
## /*---- Query Split Fasta MODE ----*/ ##
$align_ss_fasta_mode = 0;
## /*---- blast MODE (default value is 'blastn') ----*/ ##
#$blast_mode = 'n';
#
################################################################################
################################################################################
##                                                                            ##
##                              GUI PROCEDURE                                 ##
##                                                                            ##
################################################################################
################################################################################
#
$top = MainWindow->new();
$top->optionAdd('*font' => 'Terminal 10.5');
#$top->optionAdd('*font' => 'MSGOTHIC 10.5');
#$top->optionAdd('*font' => 'MSMINCHO 10.5');
#$top->gridColumnconfigure( 1, -weight => 1 );
$top->resizable(0,0);
$top->title('ALVISION_MULTI');

################################################################################
#$f0 = $top->Frame();
#$fa = $top->LabFrame(-label => 'Ɩ̫ޑI', -labelside => 'acrosstop');
$fa = $top->Frame();
#$f0 = $top->LabFrame(-label => '{ݒ', -labelside => 'acrosstop');
$f0 = $top->LabFrame(-label => decode('cp932','{ݒ'), -labelside => 'acrosstop'); # 2005.02.09 chg
$fb = $top->Frame();
$fc = $top->Frame();
$f1 = $top->Frame();
$f2 = $top->Frame();

################################################################################
# j[o[̒`
$menu = $top->Menu();
# Toplevel $top ̃IvV -menu `B
$top->configure(-menu => $menu);
# j[o[̃Gg
$menu->add('cascade', -label => '߼');
$menu->add('cascade', -label => '̑');
# IvṼv_Ej[
$item1 = $menu->Menu();
$menu->entryconfigure('߼', -menu => $item1);
#
$item1->add('command',
#	    -label   => 'dx̐ݒ',
	    -label   => decode('cp932','dx̐ݒ'), # 2005.02.09 chg
	    -command => \&Comp_value_chg);
$item1->add('separator');
$item1->add('command',
#	    -label   => "I",
	    -label   => decode('cp932','I'), # 2005.02.09 chg
	    -command => sub { exit; });
#
$item2 = $menu->Menu();
$menu->entryconfigure('̑', -menu => $item2);
#
$item2->add('command',
#	    -label   => '',
	    -label   => decode('cp932',''), # 2005.02.09 chg
	    -command => \&help_info);
$item2->add('command',
#	    -label   => 'ްޮݏ',
	    -label   => decode('cp932','ްޮݏ'), # 2005.02.09 chg
	    -command => \&version_info);

################################################################################
#$fa->Label(-text   => '̫ޖ',
$fa->Label(-text   => decode('cp932','̫ޖ'), # 2005.02.09 chg
	   -anchor => 'e')
    ->pack(-side   => left,
	   -padx   => 5);

$ent1 = $fa->Entry(-width      => 24,
		   -background => 'white')
	    ->pack(-side       => left);

#$btn1 = $fa->Button(-text      => 'Q',
$btn1 = $fa->Button(-text      => decode('cp932','Q'), # 2005.02.09 chg
		    -command   => \&Query_push,
		    -width     => 4)
	     ->pack(-side      => left,
		    -padx      => 5);

#$btn13 = $fa->Button(-text     => '',
$btn13 = $fa->Button(-text     => decode('cp932',''), # 2005.02.09 chg
		    -command   => \&file_select_main,
		    -width     => 10)
	     ->pack(-side      => right,
		    -padx      => 5);

################################################################################
#$f0->Label(-text   => 'blast',
$f0->Label(-text   => decode('cp932','blast'), # 2005.02.09 chg
	   -anchor => 'w')
    ->grid(-row      => 0,
	   -column   => 0,
#	   -sticky   => 'news');
	   -sticky   => 'e');

$rad5 = $f0->Radiobutton(-text     => 'blastn',
		 	 -value    => 'n',
		 	 -variable => \$check_blast_mode,
		 	 -command  => \&blast_mode_select)
		  ->grid(-row      => 0,
		 	 -column   => 1,
		 	 -sticky   => 'w');

$rad6 = $f0->Radiobutton(-text     => 'blastp',
		 	 -value    => 'p',
		 	 -variable => \$check_blast_mode,
		 	 -command  => \&blast_mode_select)
		  ->grid(-row      => 0,
		 	 -column   => 2,
		 	 -sticky   => 'w');
$rad5->select();

#$f0->Label(-text   => 'o͕@',
$f0->Label(-text   => decode('cp932','o͕@'), # 2005.02.09 chg
	   -anchor => 'w')
    ->grid(-row    => 1,
	   -column => 0,
	   -sticky => 'news');

#$rad1 = $f0->Radiobutton(-text     => 'eLXg,oceɏo',
#$rad1 = $f0->Radiobutton(-text     => '÷,PDF',
$rad1 = $f0->Radiobutton(-text     => decode('cp932','÷,PDF'), # 2005.02.09 chg
			 -value    => 'PDF',
			 -variable => \$check_pdf_text,
			 -command  => \&pdf_text_select)
		  ->grid(-row      => 1,
			 -column   => 1,
			 -sticky   => 'w');

#$rad2 = $f0->Radiobutton(-text     => 'eLXĝ݂ɏo',
#$rad2 = $f0->Radiobutton(-text     => '÷Ă̂',
$rad2 = $f0->Radiobutton(-text     => decode('cp932','÷Ă̂'), # 2005.02.09 chg
			 -value    => 'TEXT',
			 -variable => \$check_pdf_text,
			 -command  => \&pdf_text_select)
		  ->grid(-row      => 1,
			 -column   => 2,
			 -sticky   => 'w');
$rad2->select();

#$f0->Label(-text   => 'I',
$f0->Label(-text   => decode('cp932','I'), # 2005.02.24 chg
	   -anchor => 'w')
    ->grid(-row      => 2,
	   -column   => 0,
	   -sticky   => 'news');

$rad7 = $f0->Radiobutton(-text     => 'Align',
		 	 -value    => 'ALIGN',
		 	 -variable => \$check_work_mode,
		 	 -command  => \&work_mode_select)
		  ->grid(-row      => 2,
		 	 -column   => 1,
		 	 -sticky   => 'w');

$rad8 = $f0->Radiobutton(-text     => 'TopHit',
		 	 -value    => 'TOPHIT',
		 	 -variable => \$check_work_mode,
		 	 -command  => \&work_mode_select)
		  ->grid(-row      => 2,
		 	 -column   => 2,
		 	 -sticky   => 'w');
$rad7->select();

#$f0->Label(-text   => 'Ɏ_ϊ',
$f0->Label(-text   => decode('cp932','Ɏ_ϊ'), # 2005.02.09 chg
	   -anchor => 'w')
    ->grid(-row      => 3,
	   -column   => 0,
	   -sticky   => 'news');

$rad9 = $f0->Radiobutton(-text     => 'On',
		 	 -value    => 'ON',
		 	 -variable => \$check_amino_mode,
		 	 -command  => \&amino_mode_select)
		  ->grid(-row      => 3,
		 	 -column   => 1,
		 	 -sticky   => 'w');

$rad10 = $f0->Radiobutton(-text     => 'Off',
		 	 -value    => 'OFF',
		 	 -variable => \$check_amino_mode,
		 	 -command  => \&amino_mode_select)
		  ->grid(-row      => 3,
		 	 -column   => 2,
		 	 -sticky   => 'w');
$rad10->select();


################################################################################
#$fb->Label(-text   => '߼E',
$fb->Label(-text   => decode('cp932','߼E'), # 2005.02.09 chg
	   -anchor => 'e')
    ->pack(-side   => left,
	   -padx   => 5);

$ent2 = $fb->Entry(-width      => 12,
		   -background => 'white')
	    ->pack(-side       => left);

#$fb->Label(-text   => 'i:1e-03 or 0.001j',
$fb->Label(-text   => decode('cp932','i:1e-03 or 0.001j'), # 2005.02.09 chg
	   -anchor => 'w')
    ->pack(-side   => left);

################################################################################
#$fc->Label(-text   => '߼S',
$fc->Label(-text   => decode('cp932','߼S'), # 2005.02.09 chg
	   -anchor => 'e')
    ->pack(-side   => left,
	   -padx   => 5);

#$chk1 = $fc->Checkbutton(-text => "̧ق쐬",
$chk1 = $fc->Checkbutton(-text => decode('cp932','̧ق쐬'), # 2005.02.09 chg
			 -variable => \$check_ss_fasta_mode,
			 -onvalue => '1',
			 -offvalue => '0',
			 -command => \&ss_fasta_mode_select)
			->pack(-side => left);
$chk1->deselect;

################################################################################
#$btn2 = $f1->Button(-text       => "s",
$btn2 = $f1->Button(-text       => decode('cp932','s'), # 2005.02.09 chg
	    -command    => \&Execute_push,
	    -width      => 10)
     ->pack(-side       => 'left');

#$btn3 = $f1->Button(-text       => "I",
$btn3 = $f1->Button(-text       => decode('cp932','I'), # 2005.02.09 chg
	    -command    => \&Exit_push,
	    -width      => 10)
     ->pack(-side       => 'right');

################################################################################
$MSG = $f2->Label(-textvariable => \$msg,
	   -relief       => 'sunken')
    ->pack(-fill         => 'both');

################################################################################
$fa->pack(-padx => 5, -pady => 3, -fill => 'both');
$f0->pack(-padx => 5, -pady => 3, -fill => 'both');
$fb->pack(-padx => 5, -pady => 3, -fill => 'both');
$fc->pack(-padx => 5, -pady => 3, -fill => 'both');
$f1->pack(-padx => 5, -pady => 3, -fill => 'both');
$f2->pack(-padx => 5, -pady => 3, -fill => 'both');

################################################################################
MainLoop;

################################################################################
sub Execute_push {
	my $dir_name      = $ent1->get;
	my $expect_value  = $ent2->get;
	my $blastn_comp_value    = $blastn_scale_value;
	my $blastp_comp_value    = $blastp_scale_value;
	my $align_perl_cmd = "perl align.pl";
	my @LAST_MSG = ();
	my $dir = $tophit_tbl_name = ();

	if ($dir_name eq "") {
#	    $msg = "tH_͂ĂB";
	    $msg = decode('cp932','tH_͂ĂB'); # 2005.02.09 chg
	} else {
	    # ͏t@C(input.txt)AfBNg쐬
	    $input_file_path = $dir_name . '/input.txt';
	    $dir_path_blastn = $dir_name . '/blastn';
	    $dir_path_blastp = $dir_name . '/blastp';
	    $dir_path_pdf    = $dir_name . '/pdf';
	    $dir_path_output = $dir_name . '/output';
	    $dir_path_query  = $dir_name . '/query';
	    $dir_path_sbjct  = $dir_name . '/sbjct';

	    # ͏t@CꍇI
	    if(!-f $input_file_path){
		$top->messageBox( -type => 'ok', -icon => 'warning', -title => 'ALVISION_MULTI - Nothing Input-File',
#				  -message => 'w肳ꂽfBNgɁAinputt@C݂܂B' );
				  -message => decode('cp932','w肳ꂽfBNgɁAinputt@C݂܂B') ); # 2005.02.09 chg
		return;
	    }

	    # fBNgꍇ쐬
	    if(!-d $dir_path_blastn){
		mkdir "$dir_path_blastn", 0777 or die "mkdir error!:$dir_path_blastn.\n";
	    }
	    if(!-d $dir_path_blastp){
		mkdir "$dir_path_blastp", 0777 or die "mkdir error!:$dir_path_blastp.\n";
	    }
	    if(!-d $dir_path_pdf){
		mkdir "$dir_path_pdf", 0777 or die "mkdir error!:$dir_path_pdf.\n";
	    }
	    if(!-d $dir_path_output ){
		mkdir "$dir_path_output", 0777 or die "mkdir error!:$dir_path_output.\n";
	    }

	    #
	    $msg = "";
	    #
	    ####################################################################
	    #
	    &align_main($dir_name, $check_pdf_text, $expect_value, $blastn_comp_value, $blastp_comp_value, $ss_fasta_mode, $blast_mode);
	    #
	    ####################################################################
	    $btn3->configure(-state => 'disabled');
	    $btn3->update();
	    $btn3->configure(-state => 'normal');
	    $btn3->update();
	    if($work_mode eq "ALIGN"){ ## /* 2002.07.11 Reprori version chg */ ##
		&file_select();
	    }elsif($work_mode eq "TOPHIT"){ ## /* 2002.07.11 Reprori version chg */ ##
		$dir = Cwd::getcwd();
		$tophit_tbl_name = $dir . "/" . $output_tbl_path;
#		print STDOUT "$tophit_tbl_name\n";
#		$ie = CreateObject OLE "InternetExplorer.Application.1" || die "CreateObject: $!"; 
#		$ie->{Visible} = 1; 
#		$ie->Navigate("$tophit_tbl_name"); 
		system($tophit_tbl_name);
	    }
	}
}

################################################################################
sub Exit_push {
	exit();
}
################################################################################
sub Comp_value_chg {

	my($backup_blastn_scale_value);
	my($backup_blastp_scale_value);

	$backup_blastn_scale_value = $blastn_scale_value;
	$backup_blastp_scale_value = $blastp_scale_value;

        ########################################################################
	$oSub->withdraw if (Exists($oSub));
	$oSub = $top->Toplevel();
#	$oSub->title('ALVISION_MULTI - dx̐ݒ');
	$oSub->title(decode('cp932','ALVISION_MULTI - dx̐ݒ')); # 2005.02.09 chg
	$oSub->resizable(1,0);

	$oSub->grab;
	$oSub->focus;

        ########################################################################
	$gf0 = $oSub->Frame();
#	$gf0->Label(-text   => 'BLASTN dx(%):',
	$gf0->Label(-text   => decode('cp932','BLASTN dx(%):'), # 2005.02.09 chg
		    -anchor => 'e')
	     ->pack(-side   => 'left');

	$gf0->Scale(-from     => 0,
		    -to       => 100,
		    -variable => \$blastn_scale_value,
		    -length   => 200,
		    -tickinterval   => 10,
		    -width    => 20,
		    -bigincrement   => 10,
		    -sliderrelief   => 'raised',
		    -font   => 'Terminal 10.5',
		    -orient   => 'horizontal')
	     ->pack(-fill     => 'both');

	$gf0->pack(-padx => 5, -pady => 3, -fill => 'both');

        ########################################################################
	$gf1 = $oSub->Frame();
#	$gf1->Label(-text   => 'BLASTP dx(%):',
	$gf1->Label(-text   => decode('cp932','BLASTP dx(%):'), # 2005.02.09 chg
		    -anchor => 'e')
	     ->pack(-side   => 'left');

	$gf1->Scale(-from     => 0,
		    -to       => 100,
		    -variable => \$blastp_scale_value,
		    -length   => 200,
		    -tickinterval   => 10,
		    -width    => 20,
		    -bigincrement   => 10,
		    -sliderrelief   => 'raised',
		    -font   => 'Terminal 10.5',
		    -orient   => 'horizontal')
	     ->pack(-fill     => 'both');

	$gf1->pack(-padx => 5, -pady => 3, -fill => 'both');

        #######################################################################
	$gf2 = $oSub->Frame();
#	$btn4 = $gf2->Button(-text       => "ݒ",
	$btn4 = $gf2->Button(-text       => decode('cp932','ݒ'), # 2005.02.09 chg
		     -command    => sub { $oSub->destroy; },
		     -width      => 10)
	      ->pack(-side       => 'left');

#	$btn5 = $gf2->Button(-text       => "ݾ",
	$btn5 = $gf2->Button(-text       => decode('cp932','ݾ'), # 2005.02.09 chg
		     -command    => sub { $blastn_scale_value = $backup_blastn_scale_value;
		                          $blastp_scale_value = $backup_blastp_scale_value;
		                          $oSub->destroy;
		                          $top->focus; },
		     -width      => 10)
	      ->pack(-side       => 'right');

        #######################################################################
	$gf0->pack(-padx => 5, -pady => 3, -fill => 'both');
	$gf1->pack(-padx => 5, -pady => 3, -fill => 'both');
	$gf2->pack(-padx => 5, -pady => 3, -fill => 'both');

}
################################################################################
sub Query_push {

	my($dir);

	$dir = ();

        ########################################################################
	$qSub->withdraw if (Exists($qSub));
	$qSub = $top->Toplevel();
#	$qSub->title('ALVISION_MULTI - ̫ޑI');
	$qSub->title(decode('cp932','ALVISION_MULTI - ̫ޑI')); # 2005.02.09 chg

	$qSub->grab;
	$qSub->focus;

        ########################################################################
	$qf0 = $qSub->Frame();

#	$qf0->Label(-text   => 'I̫',
	$qf0->Label(-text   => decode('cp932','I̫'), # 2005.02.09 chg
		    -anchor => 'e')
	     ->pack(-side   => 'left');

	$q_ent = $qf0->Entry(-background => 'white')
		      ->pack(-padx       => 5,
			     -pady       => 3,
			     -fill       => 'x',
			     -expand     => 'yes');
        ########################################################################
	$qf1 = $qSub->Frame();

#	$qf1->Label(-text   => 'IΏ̫ވꗗ:',
	$qf1->Label(-text   => decode('cp932','IΏ̫ވꗗ:'), # 2005.02.09 chg
		    -anchor => 'w')
	     ->pack(-fill   => 'x');

	# Xg{bNX`
	$lis = $qf1->Scrolled('Listbox',
			      -background => 'white',
			      -scrollbars => 'se',
			      -font       => 'Terminal 10.5')
	     ->pack(-fill   => 'both',
		    -expand => 'yes');

	# \鍀ڂ`
	opendir(DIR, "./") || die "not opendir!!\n";
	@files = readdir(DIR);
	# Xg{bNX̍ڂ}
	foreach $item (@files){
	    if(-d $item){
		if($item ne '.' & $item ne '..'){
#		    $lis->insert('end', $item);
		    $lis->insert('end', decode('cp932',$item)); # 2005.02.09 chg
		}
	    }
	}
	closedir(DIR);

	$lis->bind("<ButtonPress>", \&get_list_dir_b1_press);
	$lis->bind("<Double-1>",    \&get_list_dir_double_click);

        ########################################################################
	$qf2 = $qSub->Frame();

#	$btn6 = $qf2->Button(-text       => "ݒ",
	$btn6 = $qf2->Button(-text       => decode('cp932','ݒ'), # 2005.02.09 chg
		     -command    => \&insert_dir_name,
		     -width      => 10)
	      ->pack(-side       => 'left');

#	$btn7 = $qf2->Button(-text       => "ݾ",
	$btn7 = $qf2->Button(-text       => decode('cp932','ݾ'), # 2005.02.09 chg
		     -command    => sub { $qSub->destroy; },
		     -width      => 10)
	      ->pack(-side       => 'right');


        #######################################################################
	$qf0->pack(-padx => 5, -pady => 3, -fill => 'x');
	$qf1->pack(-padx => 5, -pady => 3, -fill => 'both', -expand => 'yes');
	$qf2->pack(-padx => 5, -pady => 3, -fill => 'x');

}
################################################################################
sub help_info {

	my($help_file);
	my($dir);

	$dir = Cwd::getcwd();
	$help_file = $dir . "/help/ALVISION040129.htm";
	$ie = CreateObject OLE "InternetExplorer.Application.1" || die "CreateObject: $!"; 
	$ie->{Visible} = 1; 
	$ie->Navigate("$help_file"); 

#	system("$help_file");
}
################################################################################
sub version_info {

        ########################################################################
	$vSub->withdraw if (Exists($vSub));
	$vSub = $top->Toplevel();
#	$vSub->title('ALVISION_MULTI - o[W');
	$vSub->title(decode('cp932','ALVISION_MULTI - o[W')); # 2005.02.09 chg
	$vSub->resizable(0,0);

	$vSub->grab;
	$vSub->focus;

	$version_info = "                                                              \n" .
			"  ALVISION_MULTI    version 2.3.4                             \n" .
			"                                                              \n" .
			"                                                              \n" .
			"   Created by                                                 \n" .
			"              Reverse Proteomics Research Institute co.,ltd.  \n" .
			"                                                              \n" .
			"                           (Last renewal date : 2005.09.28).  \n" .
			"                                                              ";

        ########################################################################
	$vfp = $vSub->Frame();
	$vf0 = $vSub->Frame();
	$vf1 = $vSub->Frame();

        #######################################################################
	$can = $vfp->Canvas(-width => 400,
			    -height => 200,
			    -background => 'white')->pack();
	$logo = $vfp->Photo(-format => 'gif',
			    -file   => 'HELP/logo.gif');
	$can->createImage(200,100,-image => $logo);

        #######################################################################
	$vf0->Label(-text   => $version_info,
		    -background => 'white',
		    -anchor => 'w')
	     ->pack(-fill       => 'x');

        #######################################################################
	$btn11 = $vf1->Button(-text       => "OK",
		      -command    => sub { $vSub->destroy;
		                           $top->focus; },
		     -width      => 10)
#	      ->pack(-side       => 'right');
	      ->pack();

        #######################################################################
	$vfp->pack(-padx => 5, -pady => 3, -fill => 'both');
	$vf0->pack(-padx => 5, -pady => 3, -fill => 'both');
	$vf1->pack(-padx => 5, -pady => 3, -fill => 'both');

}
################################################################################
sub get_list_dir_b1_press {
	$q_ent->delete(0, 'end');
	$dir = $lis->get('anchor');
	$q_ent->insert('end', $dir);
}
################################################################################
sub get_list_dir_double_click {
	$q_ent->delete(0, 'end');
	$dir = $lis->get('anchor');
	$q_ent->insert('end', $dir);
	&insert_dir_name();
}
################################################################################
sub insert_dir_name {
	$ent1->delete(0, 'end');
	$dir_name = $q_ent->get;
	$ent1->insert('end', $dir_name);
	$qSub->destroy;
}
################################################################################
sub pdf_text_select {
# /* not use. */
#	if($check_pdf_text =~ "TEXT"){
#		$output_mode = "TEXT";
#	}
#	elsif($check_pdf_text =~ "PDF"){
#		$output_mode = "";
#	}
}
################################################################################
sub ss_fasta_mode_select {
	if($check_ss_fasta_mode =~ "1"){
		$ss_fasta_mode = "1";
		$rad6->configure(-state => 'disabled');
		$rad6->update();
	}
	elsif($check_ss_fasta_mode =~ "0"){
		$ss_fasta_mode = "0";
		$rad6->configure(-state => 'normal');
		$rad6->update();
	}
}
################################################################################
sub blast_mode_select {
	if($check_blast_mode =~ "n"){
		$blast_mode = "n";

		if($check_work_mode =~ "ALIGN"){
			$chk1->configure(-state => 'normal');
			$chk1->update();
		}

		$rad9->configure(-state => 'normal');
		$rad9->update();
		$rad10->configure(-state => 'normal');
		$rad10->update();
	}
	elsif($check_blast_mode =~ "p"){
		$blast_mode = "p";

		if($check_work_mode =~ "ALIGN"){
			$chk1->configure(-state => 'disabled');
			$chk1->update();
			$chk1->deselect();
		}

		$rad9->configure(-state => 'disabled');
		$rad9->update();
		$check_amino_mod = 'OFF';
		$rad10->select();
		$rad10->configure(-state => 'disabled');
		$rad10->update();
	}
}
################################################################################
sub work_mode_select {
	if($check_work_mode =~ "ALIGN"){
		$work_mode = "ALIGN";

		$rad1->configure(-state => 'normal');
		$rad1->update();
		$rad2->configure(-state => 'normal');
		$rad2->update();

		$chk1->configure(-state => 'normal');
		$chk1->update();

		$rad9->configure(-state => 'normal');
		$rad9->update();
		$rad10->configure(-state => 'normal');
		$rad10->update();
	}
	elsif($check_work_mode =~ "TOPHIT"){
		$work_mode = "TOPHIT";

		$rad1->configure(-state => 'disabled');
		$rad1->update();
		$rad2->configure(-state => 'disabled');
		$rad2->update();

		$chk1->configure(-state => 'disabled');
		$chk1->update();

		$rad9->configure(-state => 'disabled');
		$rad9->update();
		$check_amino_mod = 'OFF';
		$rad10->select();
		$rad10->configure(-state => 'disabled');
		$rad10->update();
	}
}
################################################################################
sub amino_mode_select {
	if($check_amino_mode =~ "ON"){
		$amino_mode = "ON";

		$check_blast_mode = 'n';
		$rad5->select();
		$rad6->configure(-state => 'disabled');
		$rad6->update();
	}
	elsif($check_amino_mode =~ "OFF"){
		$amino_mode = "OFF";

		$rad6->configure(-state => 'normal');
		$rad6->update();
	}
}
################################################################################
# t@C̓ǂݍ
sub LoadFile {
    my $filename = $top->getOpenFile(-filetypes        => $filetypes,
				     -title            => 'ALVISION_MULTI - File Open',
				     -initialdir       => $path_name,
				     -defaultextension => '.txt');
    if ($filename) {
	$path_name = dirname($filename);
	system("$filename");
    }
}
################################################################################
sub file_select_main {

	my $ent_name  = $ent1->get;

	if($ent_name eq ""){
	    &Dir_select();
	}
	else{
	    &file_select();
	}
}
################################################################################
sub file_select {

	my $cdir      = Cwd::getcwd();
	my $ent_name  = $ent1->get;

	if($ent_name eq ""){
	    $ent_name        = $dir_nm;
	}
	$input_file_nm    = $cdir . '/' . $ent_name . '/input.txt';
	$ng_file          = $cdir . '/' . $ent_name . '/NG_FILE.txt';

	$file_path_blastn = $cdir . '/' . $ent_name . '/blastn';
	$file_path_blastp = $cdir . '/' . $ent_name . '/blastp';
	$file_path_pdf    = $cdir . '/' . $ent_name . '/pdf';
	$file_path_text   = $cdir . '/' . $ent_name . '/output';
	$file_path_amino  = $cdir . '/' . $ent_name . '/amino';  ## /* 2003.10.16 add */

	@label = ('ID', 'BLAST', 'PDF', 'TEXT');
	@files = @buf = @work = ();

        ########################################################################
	if(-d $file_path_blastn &
	   -d $file_path_blastp &
	   -d $file_path_pdf    &
	   -d $file_path_text ) {
	    ## noting
	}
	else{
	    $top->messageBox( -type => 'ok', -icon => 'warning', -title => 'ALVISION_MULTI - Nothing Directory',
#			      -message => 'w肳ꂽfBNgɁAblastnAblastpA pdfAoutput fBNg݂܂B' );
			      -message => decode('cp932','w肳ꂽfBNgɁAblastnAblastpA pdfAoutput fBNg݂܂B') ); # 2005.02.09 chg
		return;
	}
        ########################################################################
	$fSub->withdraw if (Exists($fSub));
	$fSub = $top->Toplevel();
#	$fSub->title('ALVISION_MULTI - ̧وꗗ');
	$fSub->title(decode('cp932','ALVISION_MULTI - ̧وꗗ')); # 2005.02.09 chg
	$fSub->resizable(0,0);

	$fSub->grab;
	$fSub->focus;


        ########################################################################
	open(INPUT, "$input_file_nm") || die "No $input_file_nm.";
	while(<INPUT>){
	    chomp($_);
	    if($_ =~ /^#/){
		next;
	    }
	    else{
		push(@buf, $_);
		@work = split('\t', $_);
		push(@files, $work[0]);
	    }
	}
	close(INPUT);

        ########################################################################
#	$fSub->Label(-text   => "̫ޖ[$ent_name]",
	$fSub->Label(-text   => decode('cp932',"̫ޖ[$ent_name]"), # 2005.02.09 chg
		     -font   => 'Terminal 10.5',
		    -anchor => 'w')
	     ->grid(-row      => 0,
		    -column   => 0,
		    -pady     => 5,
		    -sticky   => 'news');
	$btn16 = $fSub->Button(-text       => "input.txt",
		     -command    => \&open_input_file,
		     -font       => 'Terminal 10.5',
		     -width      => 10)
	     ->grid(-row      => 0,
		    -column   => 1,
		    -pady     => 5,
		    -sticky   => 'news');
	$btn17 = $fSub->Button(-text       => "NG_FILE.txt",
		      -command   => \&open_ng_file,
		     -font       => 'Terminal 10.5',
		     -width      => 10)
	     ->grid(-row      => 0,
		    -column   => 2,
		    -pady     => 5,
		    -sticky   => 'news');

	$yscrl = $fSub->Scrollbar(-command => sub { &MultiScrollSet; })
	    ->grid(-row     => 1,
		   -column  => 6,
		   -sticky  => 'news',
		   -rowspan => 2);
	#
	$list[0] = $fSub->Listbox(#-background       => 'white',
				   -selectforeground => 'yellow',
				   -selectbackground => 'darkolivegreen',
				   -width  => 20,
				   -height => 30,
				   -relief => 'flat',
				   -font   => 'Terminal 10.5',
				   -yscrollcommand   => ['set', $yscrl ])
			    ->grid(-row    => 2,
				   -column => 0,
				   -pady   => 5,
				   -sticky => 'news');
	$list[1] = $fSub->Listbox(#-background       => 'blue',
				   #-foreground      => 'yellow',
				   -background       => 'white',
				   -selectforeground => 'yellow',
				   -selectbackground => 'darkolivegreen',
				   -width   => 10,
				   -height  => 30,
				   -relief => 'sunken',
				   -font   => 'Terminal 10.5',
				   -yscrollcommand   => ['set', $yscrl ])
			    ->grid(-row    => 2,
				   -column => 1,
				   -pady   => 5,
				   -sticky => 'news');
	$list[1]->bind("<Double-1>", \&open_output);

	$list[2] = $fSub->Listbox(#-background       => 'blue',
				   #-foreground      => 'yellow',
				   -background       => 'white',
				   -selectforeground => 'yellow',
				   -selectbackground => 'darkolivegreen',
				   -width   => 10,
				   -height  => 30,
				   -relief => 'sunken',
				   -font   => 'Terminal 10.5',
				   -yscrollcommand   => ['set', $yscrl ])
			    ->grid(-row    => 2,
				   -column => 2,
				   -pady   => 5,
				   -sticky => 'news');
	$list[2]->bind("<Double-1>", \&open_pdf);

	$list[3] = $fSub->Listbox(#-background       => 'blue',
				   #-foreground      => 'yellow',
				   -background       => 'white',
				   -selectforeground => 'yellow',
				   -selectbackground => 'darkolivegreen',
				   -width   => 10,
				   -height  => 30,
				   -relief => 'sunken',
				   -font   => 'Terminal 10.5',
				   -yscrollcommand   => ['set', $yscrl ])
			    ->grid(-row    => 2,
				   -column => 3,
				   -pady   => 5,
				   -sticky => 'news');
	$list[3]->bind("<Double-1>", \&open_blastn);

	$list[4] = $fSub->Listbox(#-background       => 'blue',
				   #-foreground      => 'yellow',
				   -background       => 'white',
				   -selectforeground => 'yellow',
				   -selectbackground => 'darkolivegreen',
				   -width   => 10,
				   -height  => 30,
				   -relief => 'sunken',
				   -font   => 'Terminal 10.5',
				   -yscrollcommand   => ['set', $yscrl ])
			    ->grid(-row    => 2,
				   -column => 4,
				   -pady   => 5,
				   -sticky => 'news');
	$list[4]->bind("<Double-1>", \&open_blastp);

	$list[5] = $fSub->Listbox(#-background       => 'blue',
				   #-foreground      => 'yellow',
				   -background       => 'white',
				   -selectforeground => 'yellow',
				   -selectbackground => 'darkolivegreen',
				   -width   => 10,
				   -height  => 30,
				   -relief => 'sunken',
				   -font   => 'Terminal 10.5',
				   -yscrollcommand   => ['set', $yscrl ])
			    ->grid(-row    => 2,
				   -column => 5,
				   -pady   => 5,
				   -sticky => 'news');
	$list[5]->bind("<Double-1>", \&open_amino);

	#
	foreach (@files) {
	    $list[0]->insert('end', $_);
	}
	foreach (@files) {
	    $list[1]->insert('end', 'OUTPUT');
	}
	foreach (@files) {
	    $list[2]->insert('end', 'PDF');
	}
	foreach (@files) {
	    $list[3]->insert('end', 'BLASTN');
	}
	foreach (@files) {
	    $list[4]->insert('end', 'BLASTP');
	}
	foreach (@files) {
	    $list[5]->insert('end', 'AMINO');
	}
}
################################################################################
# widgetscrollbarA  
sub MultiScrollSet {
    foreach $widget (@list) {
	$widget->yview(@_);
    }
}
################################################################################
sub open_output {
    $number = $list[1]->index('anchor');
#    $fname  = $list[0]->get($number, $number);
    $fname  = $list[0]->get($number);
    $file_nm = $file_path_text . '/' . $fname . '.txt';
    if(-f $file_nm){
	$ie = CreateObject OLE "InternetExplorer.Application.1" || die "CreateObject: $!"; 
	$ie->{Visible} = 1; 
	$ie->Navigate("$file_nm"); 
#	system("$file_nm");
#	exec("$file_nm");
    }
    else{
	$fSub->messageBox( -type => 'ok', -icon => 'info', -title => 'ALVISION_MULTI - Nothing file',
#			  -message => 'w肳ꂽt@C݂͑܂B' );
			  -message => decode('cp932','w肳ꂽt@C݂͑܂B') ); # 2005.02.09 chg
    }
    $fSub->focus;
}
################################################################################
sub open_pdf {
    $number = $list[2]->index('anchor');
#    $fname  = $list[0]->get($number, $number);
    $fname  = $list[0]->get($number);
    $file_nm = $file_path_pdf . '/' . $fname . '.pdf';
    if(-f $file_nm){
	$ie = CreateObject OLE "InternetExplorer.Application.1" || die "CreateObject: $!"; 
	$ie->{Visible} = 1; 
	$ie->Navigate("$file_nm"); 
#	system("$file_nm");
#	exec("$file_nm");
    }
    else{
	$fSub->messageBox( -type => 'ok', -icon => 'info', -title => 'ALVISION_MULTI - Nothing file',
#			  -message => 'w肳ꂽt@C݂͑܂B' );
			  -message => decode('cp932','w肳ꂽt@C݂͑܂B') ); # 2005.02.09 chg
    }
    $fSub->focus;
}
################################################################################
sub open_blastn {
    $number = $list[3]->index('anchor');
#    $fname  = $list[0]->get($number, $number);
    $fname  = $list[0]->get($number);
    $file_nm = $file_path_blastn . '/' . $fname . '.txt';
    if(-f $file_nm){
	$ie = CreateObject OLE "InternetExplorer.Application.1" || die "CreateObject: $!"; 
	$ie->{Visible} = 1; 
	$ie->Navigate("$file_nm"); 
#	system("$file_nm");
#	exec("$file_nm");
    }
    else{
	$fSub->messageBox( -type => 'ok', -icon => 'info', -title => 'ALVISION_MULTI - Nothing file',
#			  -message => 'w肳ꂽt@C݂͑܂B' );
			  -message => decode('cp932','w肳ꂽt@C݂͑܂B') ); # 2005.02.09 chg
    }
    $fSub->focus;
}
################################################################################
sub open_blastp {
    $number = $list[4]->index('anchor');
#    $fname  = $list[0]->get($number, $number);
    $fname  = $list[0]->get($number);
    $file_nm = $file_path_blastp . '/' . $fname . '.txt';
    if(-f $file_nm){
	$ie = CreateObject OLE "InternetExplorer.Application.1" || die "CreateObject: $!"; 
	$ie->{Visible} = 1; 
	$ie->Navigate("$file_nm"); 
#	system("$file_nm");
#	exec("$file_nm");
    }
    else{
	$fSub->messageBox( -type => 'ok', -icon => 'info', -title => 'ALVISION_MULTI - Nothing file',
#			  -message => 'w肳ꂽt@C݂͑܂B' );
			  -message => decode('cp932','w肳ꂽt@C݂͑܂B') ); # 2005.02.09 chg
    }
    $fSub->focus;
}
################################################################################
sub open_amino {
    $number = $list[5]->index('anchor');
#    $fname  = $list[0]->get($number, $number);
    $fname  = $list[0]->get($number);
    $file_nm = $file_path_amino . '/' . $fname . '.htm';
    if(-f $file_nm){
	$ie = CreateObject OLE "InternetExplorer.Application.1" || die "CreateObject: $!"; 
	$ie->{Visible} = 1; 
	$ie->Navigate("$file_nm"); 
#	system("$file_nm");
#	exec("$file_nm");
    }
    else{
	$fSub->messageBox( -type => 'ok', -icon => 'info', -title => 'ALVISION_MULTI - Nothing file',
#			  -message => 'w肳ꂽt@C݂͑܂B' );
			  -message => decode('cp932','w肳ꂽt@C݂͑܂B') ); # 2005.02.09 chg
    }
    $fSub->focus;
}
################################################################################
sub open_input_file {
    if(-f $input_file_nm){
	system("$input_file_nm");
#	exec("$input_file_nm");
    }
    else{
	$fSub->messageBox( -type => 'ok', -icon => 'info', -title => 'ALVISION_MULTI - Nothing file',
#			  -message => 'inputt@C݂͑܂B' );
			  -message => decode('cp932','inputt@C݂͑܂B') ); # 2005.02.09 chg
    }
    $fSub->focus;
}
################################################################################
sub open_ng_file {
    if(-f $ng_file){
	system("$ng_file");
#	exec("$ng_file");
    }
    else{
	$fSub->messageBox( -type => 'ok', -icon => 'info', -title => 'ALVISION_MULTI - Nothing file',
#			  -message => 'NG_FILEt@C݂͑܂B' );
			  -message => decode('cp932','NG_FILEt@C݂͑܂B') ); # 2005.02.09 chg
    }
    $fSub->focus;
}

################################################################################
sub Dir_select {

	my($dir);

	$dir = ();

        ########################################################################
	$dSub->withdraw if (Exists($dSub));
	$dSub = $top->Toplevel();
#	$dSub->title('ALVISION_MULTI - ̫ޑI');
	$dSub->title(decode('cp932','ALVISION_MULTI - ̫ޑI')); # 2005.02.09 chg

	$dSub->grab;
	$dSub->focus;

        ########################################################################
	$df0 = $dSub->Frame();

#	$df0->Label(-text   => 'I̫',
	$df0->Label(-text   => decode('cp932','I̫'), # 2005.02.09 chg
		    -anchor => 'e')
	     ->pack(-side   => 'left');

	$q_ent2 = $df0->Entry(-background => 'white')
		      ->pack(-padx        => 5,
			     -pady        => 3,
			     -fill        => 'x',
			     -expand      => 'yes');
        ########################################################################
	$df1 = $dSub->Frame();

#	$df1->Label(-text   => 'IΏ̫ވꗗ:',
	$df1->Label(-text   => decode('cp932','IΏ̫ވꗗ:'), # 2005.02.09 chg
		    -anchor => 'w')
	     ->pack(-fill   => 'x');

	# Xg{bNX`
	$lis2 = $df1->Scrolled('Listbox',
			      -background => 'white',
			      -font       => 'Terminal 10.5',
			      -scrollbars => 'se')
	     ->pack(-fill   => 'both',
		    -expand => 'yes');

	# \鍀ڂ`
	opendir(DIR, "./") || die "not opendir!!\n";
	@files = readdir(DIR);
	# Xg{bNX̍ڂ}
	foreach $item (@files){
	    if(-d $item){
		if($item ne '.' & $item ne '..'){
#		    $lis2->insert('end', $item);
		    $lis2->insert('end', decode('cp932',$item)); # 2005.02.09 chg
		}
	    }
	}
	closedir(DIR);

	$lis2->bind("<ButtonPress>", \&get_list_dir_b1_press2);
	$lis2->bind("<Double-1>",    \&get_list_dir_double_click2);

        ########################################################################
	$df2 = $dSub->Frame();

#	$btn14 = $df2->Button(-text       => "ݒ",
	$btn14 = $df2->Button(-text       => decode('cp932','ݒ'), # 2005.02.09 chg
		     -command    => \&insert_dir_name2,
		     -width      => 10)
	      ->pack(-side       => 'left');

#	$btn15 = $df2->Button(-text       => "ݾ",
	$btn15 = $df2->Button(-text       => decode('cp932','ݾ'), # 2005.02.09 chg
		     -command    => sub { $dSub->destroy; },
		     -width      => 10)
	      ->pack(-side       => 'right');


        #######################################################################
	$df0->pack(-padx => 5, -pady => 3, -fill => 'x');
	$df1->pack(-padx => 5, -pady => 3, -fill => 'both', -expand => 'yes');
	$df2->pack(-padx => 5, -pady => 3, -fill => 'x');

}
################################################################################
sub get_list_dir_b1_press2 {
	$q_ent2->delete(0, 'end');
	$dir_nm = $lis2->get('anchor');
	$q_ent2->insert('end', $dir_nm);
}
################################################################################
sub get_list_dir_double_click2 {
	$q_ent2->delete(0, 'end');
	$dir_nm = $lis2->get('anchor');
	$q_ent2->insert('end', $dir_nm);
	&insert_dir_name2();
}
################################################################################
sub insert_dir_name2 {
	$dSub->destroy;
	&file_select();
	$dir_nm = "";
}
###############################################################################
sub init_comp_value_get {
    ($ini_file) = @_;

    my($line);

    open(INIT,"<$ini_file") || die "No $ini_file.";
    while($line = <INIT>){
	chomp($line);
	if($line =~ /^NCompValue=/){
	    ($dummy,$blastn_scale_value) = split(/\=/, $line);
	}
	elsif($line =~ /^PCompValue=/){
	    ($dummy,$blastp_scale_value) = split(/\=/, $line);
	}
    }
    close(INIT);

}
###############################################################################
sub input_file_check {
    ($input_file_nm,$q_path,$s_path) = @_;

    my($line);
    my(%buf);
    my(@work);
    my($i,$n);
    my($q_f_path,$s_f_path);
    my($not_found_count);
    my($cdir, $ent_name);
    my(@qfiles, @sfiles);
    my($f_length);
    my($comp_file);
    my($found_it_flag);

    $cdir = Cwd::getcwd();
    $ent_name  = $ent1->get;

    @QUERY_ITEMS = @SBJCT_ITEMS = ();
    $q_f_path = $s_f_path = ();
    $not_found_count = 0;
    $f_length = 0;
    $comp_file = ();
    $found_it_flag = 0;

    @buf = ();
    @work = ();
    @qfiles = @sfiles = ();

    $ng_file = $cdir . '/' . $ent_name . '/NG_FILE.txt';

    open(INPUT,"<$input_file_nm") || die "No $input_file_nm.";
    $i = 0;
    while($line = <INPUT>){
	chomp($line);
	if($line =~ /^#/){
	    next;
	}
	else{
	    push(@buf,$line);
	    @work = split('\t', $line);
	    push(@QUERY_ITEMS, $work[0]);
	    push(@SBJCT_ITEMS, $work[4]);
	    $i++;
	}
    }
    close(INPUT);
#    print STDOUT "$i\n";

    opendir(DIR, "$q_path");
    @qfiles = readdir(DIR);
    closedir(DIR);

    opendir(DIR, "$s_path");
    @sfiles = readdir(DIR);
    closedir(DIR);

    $n=0;
    foreach(@QUERY_ITEMS){
	$f_length = length($QUERY_ITEMS[$n]);
	foreach(@qfiles){
	    $comp_file = substr($_, 0, $f_length);
	    if($comp_file eq $QUERY_ITEMS[$n]){
		$found_it_flag = 1;
	    }
	}
	if($found_it_flag != 1){
	    print "$comp_file is not found.\n";
	}
	$found_it_flag = 0;
#	$q_f_path = $q_path . '/' . $QUERY_ITEMS[$n];
#	if(!-f $q_f_path){
#print STDOUT "$q_f_path\n";
#	    open(NG_FILE, ">>$ng_file") || die "No $ng_file.";
#	    print NG_FILE "Not found file is <<< $q_f_path >>>\n";
#	    close(NG_FILE);
#	    $not_found_count++;
#	}
	$n++;
    }
    $n=0;
    foreach(@SBJCT_ITEMS){
#	$s_f_path = $s_path . '/' . $SBJCT_ITEMS[$n];
#	if(!-f $s_f_path){
#print STDOUT "$s_f_path\n";
#	    open(NG_FILE, ">>$ng_file") || die "No $ng_file.";
#	    print NG_FILE "Not found file is <<< $s_f_path >>>\n";
#	    close(NG_FILE);
#	    $not_found_count++;
#	}
#	$n++;
    }
    if($not_found_count > 0){
	$i = -1;
    }
    print STDOUT "$not_found_count\n";

    return($i);

}
#---
#
# /* start of alignment make process. (align.pl) */
###############################################################################
###############################################################################
###                                                                        ####
###                    ALIGNMENT TOOL MAIN PROCEDURE                       ####
###                                                                        ####
###############################################################################
###############################################################################
sub align_main {
    my($wd, $po, $ev, $cvn, $cvp, $asfm, $bm) = @_;

    my($PDF_OPTION);
    my($expect_value);
    my($ini_file);
    my($num);
    my($tmp_path_query, $tmp_path_sbjct, $tmp_path_blast);
    my($tmp_path_output, $tmp_path_pdf);
    my($tmp_path_amino, $output_amino_path); ## /* 2002.07.22 Reprori version add */
    my(@files_query, @files_sbjct);
    my($i);
    my($query_fasta_file_path,$sbjct_fasta_file_path,$blast_out_file_path);
    my($output_file_path,$output_pdf_path);
    my($query_length,$sbjct_length);
    my($work_counter);
    my($end_message);
    my($query_work_dir);
    my($sbjct_work_dir);
    my($ret);
    my($check_query_fasta_file_path, $check_sbjct_fasta_file_path);
    my($cdir);
    my($file_match_flag);
    my($counter);
    my($qos, $qoe, $sos, $soe); ## /* 2002.07.04 Reprori version add */
    my($qos_wk, $qoe_wk, $sos_wk, $soe_wk); ## /* 2002.10.01 Reprori version add */
    my($query_line, $sbjct_line) = (); # 2005/09/26 add by hatano.

    $cdir = Cwd::getcwd();

    $work_dir = $PDF_OPTION = $expect_value = "NO-SPECIFY";
    $error_count = $counter = 0;

    ##### ALIGNMENT TOOL OPTION #####
    $work_dir = $wd;
    $PDF_OPTION = $po;
    if($ev ne "") {
	$expect_value = $ev;
	$expect_value =~ s/E/e/;
	$expect_value =~ s/^e\-/1e\-/;
    }
    $comp_value_n = $cvn;
    $comp_value_p = $cvp;
    $align_ss_fasta_mode = $asfm;
    $blast_mode = $bm;
    #################################

    @QUERY_ITEMS = @SBJCT_ITEMS = @files_query = @files_sbjct = ();
    $pdf_flag = ();
    $query_fasta_file_path = $sbjct_fasta_file_path = $blast_out_file_path = ();
    $output_file_path = $output_pdf_path = ();
    $ret = "OK";
    $end_message = ();
    $output_tbl_path = ();       ## /* 2002.07.11 Reprori version add */

    $ini_file = "./alignment_tool.ini";

    &init_option($ini_file);

    $input_file = './' . $work_dir . '/' . $input_file;

    $error_file = $work_dir . '/NG_FILE.txt';

    $tmp_path_query  = $work_dir . '/query/';
    $tmp_path_sbjct  = $work_dir . '/sbjct/';
    $tmp_path_output = $work_dir . '/output/';
    $tmp_path_pdf    = $work_dir . '/pdf/';

    $num = &input_file_open($input_file);

    if($blast_mode eq "p"){
	$tmp_path_blast = $work_dir . '/blastp/';
	$comp_value = $comp_value_p;
    }
    else{
	$tmp_path_blast = $work_dir . '/blastn/';
	$comp_value = $comp_value_n;
    }

#print STDOUT "pdf_option:$PDF_OPTION\n";
    if(($PDF_OPTION eq "TEXT") || ($PDF_OPTION eq "text")){
	$pdf_flag = "NO";
#print STDOUT "pdf_flag:$pdf_flag\n";
    }
    elsif(($PDF_OPTION eq "PDF") || ($PDF_OPTION eq "pdf")){
	$pdf_flag = "YES";
    }
    else{
	$pdf_flag = "YES";
    }

    $query_work_dir = ();
    $sbcjt_work_dir = ();

#print STDOUT "eXgP\n";
    opendir(DIR, "$tmp_path_query") || die "not opendir $tmp_path_query.\n";
    @files_query = readdir(DIR);
    closedir(DIR);

    opendir(DIR, "$tmp_path_sbjct") || die "not opendir $tmp_path_sbjct.\n";
    @files_sbjct = readdir(DIR);
    closedir(DIR);

#    $output_tbl_path = $work_dir . '/' . $work_dir . '.xls'; ## /* 2002.07.11 Reprori version add */
    $output_tbl_path = $work_dir . '/' . $work_dir . '.txt'; ## /* 2002.07.11 Reprori version add */

    ## /* 2002.07.22 Reprori version add start */
    if($amino_mode =~ "ON"){
	&make_orf_code_table(); ## /* 2002.07.11 Reprori version add */
	$tmp_path_amino = $work_dir . '/amino';

	if(!-d $tmp_path_amino){
	    mkdir "$tmp_path_amino", 0777 or die "mkdir error!:$tmp_path_amino.\n";
	}
    }
    ## /* 2002.07.22 Reprori version add end */

    ## 2005/09/26 add by hatano START. version 2.3.4.
    my $mutation_file	= ();
    if($blast_mode eq 'p'){
	$mutation_file	= $wd . '/' . 'blastp_Ins_Del_Info.txt';
    }
    else{
	$mutation_file	= $wd . '/' . 'blastn_Ins_Del_Info.txt';
    }
    open(MUT, ">$mutation_file")||die "Error open [$mutation_file].\n";
    print MUT "Query name\tquery pos\tSbjct name\tsbjct pos\tchange info\n";
    ## 2005/09/26 add by hatano END. version 2.3.4.

    for($i=0; $i<$num; $i++){

	$query_fasta_file_path = $sbjct_fasta_file_path = $blast_out_file_path = ();
	$output_file_path = $output_pdf_path = ();
	$query_length = $sbjct_length = 0;
	$work_counter = 0;
	$check_query_fasta_file_path = $check_sbjct_fasta_file_path = ();
	$file_match_flag = 0;
	$qos = $qoe = $sos = $soe = 0; ## /* 2002.07.04 Reprori version add */
	$qos_wk = $qoe_wk = $sos_wk = $soe_wk = 0; ## /* 2002.10.01 Reprori version add */

	$file_length = length(@QUERY_ITEMS[$i]);
#	$qos = @QUERY_ORF_START[$i]; ## /* 2002.07.04 Reprori version add */
#	$qoe = @QUERY_ORF_END[$i] + 2;   ## /* 2002.07.04 Reprori version add */
#	$sos = @SBJCT_ORF_START[$i]; ## /* 2002.07.04 Reprori version add */
#	$soe = @SBJCT_ORF_END[$i] + 2;   ## /* 2002.07.04 Reprori version add */
	$qos_wk = @QUERY_ORF_START[$i]; ## /* 2002.07.04 Reprori version add */
	$qoe_wk = @QUERY_ORF_END[$i];   ## /* 2002.07.04 Reprori version add */
	$sos_wk = @SBJCT_ORF_START[$i]; ## /* 2002.07.04 Reprori version add */
	$soe_wk = @SBJCT_ORF_END[$i];   ## /* 2002.07.04 Reprori version add */

	foreach(@files_query){
	    $cmp_file = substr($_, 0, $file_length);
	    if(@QUERY_ITEMS[$i] eq $cmp_file){
		$query_fasta_file_path = $tmp_path_query . $_;
		$blast_out_file_path = $tmp_path_blast . $cmp_file . '.txt';
		$query_id = $cmp_file;
		if($pdf_flag eq "YES"){
		    $output_file_path = $tmp_path_output . $cmp_file . '.txt';
		    $output_pdf_path = $tmp_path_pdf . $cmp_file . '.pdf';
		}
		else{
		    $output_file_path = $tmp_path_output . $cmp_file . '.txt';
		    $output_pdf_path = "";
		}
		## /* 2002.07.22 Reprori version add start */
		if($amino_mode =~ "ON"){
		    $output_amino_path = $tmp_path_amino . '/' . $cmp_file . '.htm';
		}
		## /* 2002.07.22 Reprori version add end */
		$file_match_flag = 1;
		last;
	    }
	    else{
		$file_match_flag = 0;
	    }
	}
	if($file_match_flag == 0){
	    $check_query_fasta_file_path = $tmp_path_query . @QUERY_ITEMS[$i];
	    open(NG_FILE,">>$error_file") || die "No $error_file.";
	    print NG_FILE "<<< Not found query-file is [ $check_query_fasta_file_path ] >>>\n";
	    close(NG_FILE);
	    $error_count++;
	    goto NEXT_LOOP;
	}

	$file_length = length(@SBJCT_ITEMS[$i]);

	foreach(@files_sbjct){
	    $cmp_file = substr($_, 0, $file_length);
	    if(@SBJCT_ITEMS[$i] eq $cmp_file){
		$sbjct_id = $cmp_file;
		$sbjct_fasta_file_path = $tmp_path_sbjct . $_;
		$file_match_flag = 1;
		last;
	    }
	    else{
		$file_match_flag = 0;
	    }
	}
	if($file_match_flag == 0){
	    $check_sbjct_fasta_file_path = $tmp_path_sbjct . @SBJCT_ITEMS[$i];
	    open(NG_FILE,">>$error_file") || die "No $error_file.";
	    print NG_FILE "<<< Not found sbjct-file is [ $check_sbjct_fasta_file_path ] >>>\n";
	    close(NG_FILE);
	    $error_count++;
	    goto NEXT_LOOP;
	}

	$work_counter = sprintf("%5d/%5d", $i+1, $num);
#	print "=========[$query_id][$sbjct_id]=========\t[$work_counter]\n";
#	print "[QUERY     ]:$query_fasta_file_path\n";
#	print "[SBJCT     ]:$sbjct_fasta_file_path\n";
#	print "[BLAST(N/P)]:$blast_out_file_path\n";
#	print "[OUTPUT    ]:$output_file_path\n";
#	print "[PDF       ]:$output_pdf_path\n";
#	print "[QUERY-ID  ]:$query_id\n";
#	print "[SBJCT-ID  ]:$sbjct_id\n";

	## /* 2003.04.01 add by hatano */ ##
	$query_work_dir = &input_file_convert(\$query_fasta_file_path);
	$sbjct_work_dir = &input_file_convert(\$sbjct_fasta_file_path);

	($query_length,$sbjct_length) = &length_read($query_fasta_file_path, $sbjct_fasta_file_path);

#	/* 2002.10.01 Reprori version add start */
	if($amino_mode =~ "ON"){
	    if($qos_wk ne "" && $qoe_wk ne ""){
		$qos = $qos_wk;
#		$qoe = $qoe_wk + 2;
		$qoe = $qoe_wk;
	    }
#	    /* EN󔒂̏ꍇAIRhʒu͈͂m肷 */
	    elsif($qos_wk ne "" && $qoe_wk eq ""){
		$qos = $qos_wk;
		$qoe = &EN_search($query_fasta_file_path, $qos);
	    }
#	    /* 2004.01.19 add by hatano. */
	    elsif($qos_wk eq "" && $qoe_wk eq ""){
		$qos = $qos_wk;
		$qoe = $qoe_wk;
	    }
#print STDOUT "qos[$qos],qoe[$qoe]\n";

	    if($sos_wk ne "" && $soe_wk ne ""){
		$sos = $sos_wk;
#		$soe = $soe_wk + 2;
		$soe = $soe_wk;
	    }
#	    /* EN󔒂̏ꍇAIRhʒu͈͂m肷 */
	    elsif($sos_wk ne "" && $soe_wk eq ""){
		$sos = $sos_wk;
		$soe = &EN_search($sbjct_fasta_file_path, $sos);
	    }
#	    /* 2004.01.19 add by hatano. */
	    elsif($sos_wk eq "" && $soe_wk eq ""){
		$sos = $sos_wk;
		$soe = $soe_wk;
	    }
#print STDOUT "sos[$sos],soe[$soe]\n";
	}
#	/* 2002.10.01 Reprori version add end */

#print STDOUT "eXgQ\n";
	&bl2seq_exec($bl2seq_cmd_path,
		     $blast_out_file_path,$query_fasta_file_path,
		     $sbjct_fasta_file_path,$output_file_path);

#print STDOUT "eXgR\n";
	if($work_mode =~ "ALIGN"){ ## /* 2002.07.11 Reprori version chg */
		($ret,$query_line,$sbjct_line)
		= &make_alignment_page($blast_out_file_path,$query_fasta_file_path,
					$sbjct_fasta_file_path,$output_file_path,
					$query_id,$sbjct_id,$query_length,$sbjct_length,
					$expect_value,$output_pdf_path,
					$qos,$qoe,$sos,$soe,$output_amino_path); ## /* 2002.07.04 Reprori version chg */

	}
	elsif($work_mode =~ "TOPHIT"){ ## /* 2002.07.04 Reprori version chg */
		if($i==0){
			open(TOPHIT_TBL, ">$output_tbl_path") || die "No $output_tbl_path.";
			print TOPHIT_TBL "query_id\tsbjct_id\tquery_len\tsbjct_len\tsbjct_evalue\tcon\tidentities\tstrand\tquery_start_pos\tquery_end_pos\tsbjct_start_pos\tsbjct_end_pos\n";
			close(TOPHIT_TBL);
		}
		$ret = &make_tophit_tbl($query_id,$sbjct_id,$blast_out_file_path,$output_tbl_path); ## /* 2002.07.04 Reprori version add */
	}

	# 2005/09/26 add by hatano. START. version 2.3.4.
	my $mutation_line	= &get_mutation_info($query_id, $query_line, $sbjct_id, $sbjct_line);
	my @MUTATION_BUF	= split(/\$/, $mutation_line);
	foreach my $get_m_line (@MUTATION_BUF){
		chomp($get_m_line);
		print MUT "$get_m_line\n";
	}
	# 2005/09/26 add by hatano. END. version 2.3.4.

	########################################################################
	### Main Window Message Edit. ##########################################
	########################################################################
	$counter = $i + 1;
#	$msg = "[ $counter / $num ] sł...";
	$msg = decode('cp932',"[ $counter / $num ] sł..."); # 2005.02.09 chg
	$MSG->update();
	########################################################################

#print STDOUT "eXgS\n";
	unlink("./tmp0.csv");
	unlink("./tmp1.csv");
	unlink("./tmp2.csv");
	unlink("./tmp3.csv");
	unlink("./tmp4.csv");
	unlink($query_fasta_file_path);
	unlink($sbjct_fasta_file_path);

	if($ret !~ "OK"){
	    #print "CAUTION! query_id:[$query_id], sbjct_id:[$sbjct_id] ($ret)\n";
	    next;
	}

#print STDOUT "TEST1->PDF_FLAG:$pdf_flag\n";
	if($pdf_flag eq "YES" && $work_mode eq "ALIGN"){
	    &iTextFront_exec($pdf_cnv_cmd_path,$output_file_path,$output_pdf_path);
	}
#print STDOUT "TEST2->PDF_FLAG:$pdf_flag\n";

	if($error_count == 0){
	    unlink($error_file);
	}
NEXT_LOOP:
    }
    ## 2005/09/26 add by hatano START. version 2.3.4.
    close(MUT);
    ## 2005/09/26 add by hatano END. version 2.3.4.

    ############################################################################
    ####### Main Window Message Edit. ##########################################
    ############################################################################
#    $msg = "I@G[:[$error_count] S:[$i]";
    $msg = decode('cp932',"I@G[:[$error_count] S:[$i]"); # 2005.02.09 chg
    $MSG->update();
    ############################################################################

    rmdir($query_work_dir);
    rmdir($sbjct_work_dir);
    $end_message =  sprintf("\nFinish Program...   Error count is [%d], All processing count is [%d]\n", $error_count, $num);
    print "$end_message";
}
###############################################################################
sub init_option {
    ($ini_file) = @_;

    my($line);

    ## /* Comp Value Default Set */ /* Add by 2003.03.20 */
#    $comp_value = 50;

    open(INIT,"<$ini_file") || die "No $ini_file.";
    while($line = <INIT>){
	chomp($line);
	if($line =~ /^HOME=/){
	    ($dummy,$home_dir) = split(/\=/, $line);
	}
	elsif($line =~ /^InputFile=/){
	    ($dummy,$input_file) = split(/\=/, $line);
	}
	elsif($line =~ /^Bl2SeqPath=/){
	    ($dummy,$bl2seq_cmd_path) = split(/\=/, $line);
	}
	elsif($line =~ /^PDFConverterPath=/){
	    ($dummy,$pdf_cnv_cmd_path) = split(/\=/, $line);
	}
#	elsif($line =~ /^CompValue=/){
#	    ($dummy,$comp_value) = split(/\=/, $line);
#	}
    }
    close(INIT);

}
###############################################################################
sub input_file_open {
    ($input_file) = @_;

    my($line);
    my(%buf);
    my(@work);
    my($i);
    my($q_f_path,$s_f_path);

    @QUERY_ITEMS = @SBJCT_ITEMS = ();
## /* 2003.07.03 Reprori version add start */
    @QUERY_ORF_START = @QUERY_ORF_END = ();
    @SBJCT_ORF_START = @SBJCT_ORF_END = ();
## /* 2003.07.03 Reprori version add end */
    $q_f_path = $s_f_path = ();

    @buf = ();
    @work = ();

    open(INPUT,"<$input_file") || die "No $input_file.";
    $i = 0;
    while($line = <INPUT>){
	chomp($line);
	if($line =~ /^#/){
	    next;
	}
	else{
	    push(@buf,$line);
	    @work = split('\t', $line);
	    push(@QUERY_ITEMS,     $work[0]);
## /* 2003.07.03 Reprori version add start */
	    push(@QUERY_ORF_START, $work[2]);
	    push(@QUERY_ORF_END  , $work[3]);
## /* 2003.07.03 Reprori version add end */
	    push(@SBJCT_ITEMS,     $work[4]);
## /* 2003.07.03 Reprori version add start */
	    push(@SBJCT_ORF_START, $work[6]);
	    push(@SBJCT_ORF_END  , $work[7]);
## /* 2003.07.03 Reprori version add end */
	    $i++;
	}
    }
    close(INPUT);

    return($i);

}
###############################################################################
sub length_read {
    ($query_file,$sbjct_file) = @_;

    my($q_length, $s_length);
    my($line);
    my($work);

    $q_length = $s_length = 0;
    $line = $work = ();

    open(QUERY,"<$query_file") || die "No $query_file.";
    while($line = <QUERY>){
	chomp($line);
	if($line =~ /^\>/){
	    next;
	}
	else{
	    $work .=$line;
	}
    }
    $q_length = length($work);
    close(QUERY);

    $line = $work = ();
    open(SBJCT,"<$sbjct_file") || die "No $sbjct_file.";
    while($line = <SBJCT>){
	chomp($line);
	if($line =~ /^\>/){
	    next;
	}
	else{
	    $work .=$line;
	}
    }
    $s_length = length($work);
    close(SBJCT);

    return($q_length,$s_length);
}
###############################################################################
sub bl2seq_exec {
    ($bl2seq_cmd_path,
     $blast_out_file_path,$query_fasta_file_path,
     $sbjct_fasta_file_path,$output_file_path) = @_;

    my($bl2seq_cmd_line);

    $bl2seq_cmd_line = ();

    if($blast_mode eq "n") {
	$bl2seq_cmd_line = "$bl2seq_cmd_path -p blastn -i $query_fasta_file_path -j $sbjct_fasta_file_path -o $blast_out_file_path -F SEG";
    }
    else{
#	$bl2seq_cmd_line = "$bl2seq_cmd_path -p blastp -i $query_fasta_file_path -j $sbjct_fasta_file_path -o $blast_out_file_path -F SEG -e 0.2";
	$bl2seq_cmd_line = "$bl2seq_cmd_path -p blastp -i $query_fasta_file_path -j $sbjct_fasta_file_path -o $blast_out_file_path -F F -e 0.2";
    }
#    print STDOUT "[BL2SEQ_CMD]->$bl2seq_cmd_line\n";

    system($bl2seq_cmd_line);
}
###############################################################################
sub iTextFront_exec {
    ($iTextFront_cmd_path,$output_file_path,$output_pdf_path) = @_;

    my($iTextFront_cmd_line);

    $iTextFront_cmd_line = ();

#    $iTextFront_cmd_line = "$iTextFront_cmd_path /font_family Courier /font-size 10 /marge $output_file_path $output_pdf_path";
#    $iTextFront_cmd_line = "$iTextFront_cmd_path /font-family Courier /font-size 7 /security 128 \"araiguma\" \"araichuu\" printing modify-annotations /merge $output_file_path $output_pdf_path";
#    $iTextFront_cmd_line = "$iTextFront_cmd_path /font-family Courier /font-size 7 /security 128 \"\" \"araichuu\" printing modify-annotations /merge $output_file_path $output_pdf_path";
#    $iTextFront_cmd_line = "$iTextFront_cmd_path /font-family Courier /font-size 7 /merge $output_file_path $output_pdf_path";
    $iTextFront_cmd_line = "$iTextFront_cmd_path /font-family Courier /font-size 7 /size A4 /margin 52:52:75:75 /security 128 \"\" \"araichuu\" printing modify-annotations /merge $output_file_path $output_pdf_path";
#    print "[ITEXTFRONT_CMD]->$iTextFront_cmd_line\n";

    system($iTextFront_cmd_line);
#    sleep(1);
}
###############################################################################
sub make_alignment_page {
    ($blast_out_file_path,$query_fasta_file_path,
     $sbjct_fasta_file_path,$output_file_path,
     $query_id,$sbjct_id,$q_length,$s_length,$expect_value,$out_pdf_file,
     $qos,$qoe,$sos,$soe,$output_amino_path) = @_; ## /* 2002.07.04 Reprori version chg */

    my(@qntstart, @qntsequence, @qntend);
    my(@tntstart, @tntsequence, @tntend);
    my($qnt_start_pos, $qnt_end_pos);
    my($tnt_start_pos, $tnt_end_pos);
    my($qnt_alignment, $tnt_alignment);
    my($query_line, $bar_line, $sbjct_line);
    my($result);
    my($query_cnt,$sbjct_cnt);
    my($ret);
    my($strand_flag);
    my(@strandtmp);
    my($hit_count);
    my($score,$tseqnt_evalue);
    my($query_start_pos,$sbjct_start_pos);
    my($query_IN,$query_EN,$sbjct_IN,$sbjct_EN) = (); # 2004.01.19 add by hatano.

    $ret = "OK";

    #############################################
    ## Blast-output-file search(Alignment-line).
    #############################################
    {
	@qntstart = @qntsequence = @qntend = ();
	@tntstart = @tntsequence = @tntend = ();
	@strandtmp = ();
	$qnt_start_pos = $qnt_end_pos = ();
	$tnt_start_pos = $tnt_end_pos = ();
	$qnt_alignment = $tnt_alignment = ();
	$tmp0_file = './tmp0.csv';
	$tmp1_file = './tmp1.csv';
	$tmp2_file = './tmp2.csv';
	$tmp3_file = './tmp3.csv';
	$tmp4_file = './tmp4.csv';
	$score_count = 0;
	$seq_count = 0;
	$result = ();
	$query_line = $bar_line = $sbjct_line = ();
	$query_cnt = $sbjct_cnt = 0;
	$strand_flag = '+';
	$hit_count = 0;
	$score = $tseqnt_evalue = ();

	$time   = time();
	($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($time);
	$Year = $year + 1900;
	$Mon  = $mon + 1;
	$id = sprintf("%d/%02d/%02d/%02d%02d%02d", $Year, $Mon, $mday, $hour, $min, $sec);

	$query_IN = $qos; # 2004.01.19 add by hatano.
	$query_EN = $qoe; # 2004.01.19 add by hatano.
	$sbjct_IN = $sos; # 2004.01.19 add by hatano.
	$sbjct_EN = $soe; # 2004.01.19 add by hatano.

	open(NG_FILE, ">>$error_file") || die "No $error_file.";
	# /* 2003.10.20 Bug taisaku add start */
	while(!-f $blast_out_file_path) {
		if (--$retry <= 0) {
			$ret = "Time out bl2seq.exe";
			print NG_FILE "<<<<<<<<<< [$id] QUERY:[$query_id], SBJCT:[$sbjct_id], $ret >>>>>>>>>>\n";
			$error_count++;
			goto EXIT;
		}
#		print STDOUT "SLEEP:$retry\n";
		sleep(1);
	}
	# /* 2003.10.20 Bug taisaku add end */
	open(BLAST_NT,"<$blast_out_file_path") || die "No $blast_out_file_path.";
	open(TMP,">$tmp0_file") || die "No $tmp0_file.";
	while($line = <BLAST_NT>){
		chomp($line);
		if($line =~ /\*\*\*\*\*\ No\ hits\ found\ \*\*\*\*\*\*/) {
			#$result = "No hits found";
			#print TMP "$result\n";
			$ret = "No hits found";
			#print "<<<<<<<<<< $ret >>>>>>>>>>\n";
			print NG_FILE "<<<<<<<<<< [$id] QUERY:[$query_id], SBJCT:[$sbjct_id], $ret >>>>>>>>>>\n";
			$error_count++;
			#last;
			goto EXIT;
		}
		elsif($line =~ /^\>/) {
			$line =~ s/\>//;
			$tseqnt_name = $line;
			if($seq_count > 0){
				$qnt_start_pos = shift(@qntstart);
				$qnt_end_pos = pop(@qntend);
				$tnt_start_pos = shift(@tntstart);
				$tnt_end_pos = pop(@tntend);
				$qnt_alignment = join("", @qntsequence);
				$tnt_alignment = join("", @tntsequence);

				$result = &one_alignment_edit($qnt_start_pos,$qnt_end_pos,
							$tnt_start_pos,$tnt_end_pos,
							$qnt_alignment,$tnt_alignment);
				print TMP "$result\n";
				$query_cnt = $sbjct_cnt = 0;
				last;
			}
			$seq_count++;
		}
		elsif($line =~ /Score\ \=/){
			$line =~ s/\ e\-/\ 1e\-/;
			($score,$tseqnt_evalue) = split(/\,\ /,$line);
			# EVALUE
			$tseqnt_evalue =~ s/Expect\ \=\ //;

			if(($score_count > 0) & ($strand_flag =~ /\+/)){
			    if($query_cnt > 0 || $sbjct_cnt > 0){
#			    if(($expect_value eq "NO-SPECIFY") || ($expect_value > $tseqnt_evalue)){
#print STDOUT "3:EXPECT_VALUE:$expect_value, GET_EVALUE:$tseqnt_evalue\n";
				$qnt_start_pos = shift(@qntstart);
				$qnt_end_pos = pop(@qntend);
				$tnt_start_pos = shift(@tntstart);
				$tnt_end_pos = pop(@tntend);
				$qnt_alignment = join("", @qntsequence);
				$tnt_alignment = join("", @tntsequence);

				$result = &one_alignment_edit($qnt_start_pos,$qnt_end_pos,
							$tnt_start_pos,$tnt_end_pos,
							$qnt_alignment,$tnt_alignment);
				print TMP "$result\n";
			    }
			}
			@qntstart = @qntsequence = @qntend = ();
			@tntstart = @tntsequence = @tntend = ();
			$query_cnt = $sbjct_cnt = 0;
			$score_count++;
		}
		elsif($line =~ /Strand\ \=/){
			@strandtmp = split(/\ +/,$line);
			if($strandtmp[3] eq $strandtmp[5]){
				$strand_flag = '+';
			}
			else{
				$strand_flag = '-';
			}
		}
		elsif($line =~ /^Query\:\ /){
			if($strand_flag =~ /\+/){
			    if(($expect_value eq "NO-SPECIFY") || ($expect_value > $tseqnt_evalue)){
#print STDOUT "1:EXPECT_VALUE:$expect_value, GET_EVALUE:$tseqnt_evalue\n";
				@qnt_pstn_tmp = split(/\ +/,$line);
				push(@qntstart,$qnt_pstn_tmp[1]);
				push(@qntsequence,$qnt_pstn_tmp[2]);
				push(@qntend,$qnt_pstn_tmp[3]);
				$query_cnt++;
				$hit_count++;
			    }
			}
		}
		elsif($line =~ /^Sbjct\:\ /){
			if($strand_flag =~ /\+/){
			    if(($expect_value eq "NO-SPECIFY") || ($expect_value > $tseqnt_evalue)){
#print STDOUT "2:EXPECT_VALUE:$expect_value, GET_EVALUE:$tseqnt_evalue\n";
				@tnt_pstn_tmp = split(/\ +/,$line);
				push(@tntstart,$tnt_pstn_tmp[1]);
				push(@tntsequence,$tnt_pstn_tmp[2]);
				push(@tntend,$tnt_pstn_tmp[3]);
				$sbjct_cnt++;
				$hit_count++;
			    }
			}
		}
		elsif(eof(BLAST_NT)){
		    if($query_cnt > 0 || $sbjct_cnt > 0){
#print STDOUT "TEST->$query_cnt,$sbjct_cnt\n";
			$qnt_start_pos = shift(@qntstart);
			$qnt_end_pos = pop(@qntend);
			$tnt_start_pos = shift(@tntstart);
			$tnt_end_pos = pop(@tntend);
			$qnt_alignment = join("", @qntsequence);
			$tnt_alignment = join("", @tntsequence);

			$result = &one_alignment_edit($qnt_start_pos,$qnt_end_pos,
						$tnt_start_pos,$tnt_end_pos,
						$qnt_alignment,$tnt_alignment);
#print STDOUT "TEST->$result\n";
			print TMP "$result\n";
		    }
		    last;
		}
	}
	close(BLAST_NT);
	close(TMP);

#print STDOUT "eXgR-1\n";
	if($hit_count == 0){
		$ret = "No hits found(Not Plus)";
		#print "<<<<<< $ret >>>>>>\n";
		print NG_FILE "<<<<<<<<<< [$id] QUERY:[$query_id], SBJCT:[$sbjct_id], $ret >>>>>>>>>>\n";
		$error_count++;
		goto EXIT;
	}

#print STDOUT "eXgR-2\n";
	## Alignment Check
	$print_count = &alignment_checker($tmp0_file,$tmp1_file);
	if($print_count == 0){
		$ret = "No hits found(No Good Alignment)";
		#print "<<<<<< $ret >>>>>>\n";
		print NG_FILE "<<<<<<<<<< [$id] QUERY:[$query_id], SBJCT:[$sbjct_id], $ret >>>>>>>>>>\n";
		$error_count++;
		goto EXIT;
	}

#print STDOUT "eXgR-3\n";
	## Alignment Check No2
	$print_count = &alignment_checker2($tmp1_file,$tmp2_file);
	if($print_count == 0){
		$ret = "No hits found(No Good Alignment2)";
		#print "<<<<<< $ret >>>>>>\n";
		print NG_FILE "<<<<<<<<<< [$id] QUERY:[$query_id], SBJCT:[$sbjct_id], $ret >>>>>>>>>>\n";
		$error_count++;
		goto EXIT;
	}

#print STDOUT "eXgR-4\n";
	## Alignment Check No3
	$print_count = &alignment_checker3($tmp2_file,$tmp3_file);
	if($print_count == 0){
		$ret = "No hits found(No Good Alignment3)";
		#print "<<<<<< $ret >>>>>>\n";
		print NG_FILE "<<<<<<<<<< [$id] QUERY:[$query_id], SBJCT:[$sbjct_id], $ret >>>>>>>>>>\n";
		$error_count++;
		goto EXIT;
	}

#print STDOUT "eXgR-5\n";
	## Alignment Sort
	&alignment_sort($tmp3_file,$tmp4_file);

    }

    #############################################
    ## Alignment Create & Edit
    #############################################
    {
	my(@query_line_table, @bar_line_table, @sbjct_line_table);
	my(@q_num_line_table, @s_num_line_table);
	my(@q_orf_line_table, @s_orf_line_table); ## /* 2002.07.08 Reprori version add */
	my($alignment_num, $identities_num, $gaps_num);
	my($identities_parcent, $gaps_parcent);
	my($piriod);
	my($print_query,$print_sbjct,$print_identities,$print_gaps);
	my($page_num);
	my($line_count);
	my($result);
	my($q_orfline,$s_orfline); ## /* 2002.07.04 Reprori version add */

	@query_line_table = @bar_line_table = @sbjct_line_table = ();
	@q_num_line_table = @s_num_line_table = ();
	@q_orf_line_table = @s_orf_line_table = (); ## /* 2002.07.08 Reprori version add */
	$alignment_num = $identities_num = $gaps_num = ();
	$identities_parcent = $gaps_parcent = ();
	$piriod = ();
	$print_query = $print_sbjct = $print_identities = $print_gaps = ();
	$page_num = $line_count = 0;
	$query_start_pos = $sbjct_start_pos = 0;
	$result = "OK";
	$q_orfline = $s_orfline = (); ## /* 2002.07.04 Reprori version add */

#print STDOUT "eXgR-6\n";
	## Global Alignment Create
	($query_line,$bar_line,$sbjct_line,$query_start_pos,$sbjct_start_pos,$q_orfline,$s_orfline) = 
		&global_alignment_make($tmp4_file,$query_fasta_file_path,$sbjct_fasta_file_path,
		                       $qos,$qoe,$sos,$soe,$q_length,$s_length); ## /* 2002.07.04 Reprori version chg */

#print STDOUT "eXgR-7\n";
	## /* 2003.03.19 */ Alignment Compare Check
	$result = &alignment_cmp($query_line,$sbjct_line,$query_start_pos,$sbjct_start_pos,
				$query_fasta_file_path,$sbjct_fasta_file_path);
	if($result !~ "OK"){
	    ##$ret = "CAUTION! query_id:[$query_id], sbjct_id:[$sbjct_id] (alignment cmp check is NG)\n";
	    $ret = "Alignment Compare Check is NG";
	    #print "<<<<<< $ret >>>>>>\n";
	    goto EXIT;
	}

#print STDOUT "eXgR-8\n";
	## Rooler make
	($q_num_line,$s_num_line) = &num_line_make($query_line,$sbjct_line,$query_start_pos,$sbjct_start_pos);

#print STDOUT "eXgR-9\n";
	## 
	($alignment_num,$identities_num) = &check_identities($bar_line);
	$identities_parcent = ($identities_num / $alignment_num) * 100;
	if($identities_parcent ne "100"){
	    $piriod = index($identities_parcent, ".");
	    if($piriod != -1){
		$identities_parcent = substr($identities_parcent, 0, $piriod+2);
	    }
	}

#print STDOUT "eXgR-10\n";
	## 
	($alignment_num,$gaps_num)       = &check_gaps($bar_line);
	$gaps_parcent = ($gaps_num / $alignment_num) * 100;
	if($gaps_parcent ne "100"){
	    $piriod = index($gaps_parcent, ".");
	    if($piriod != -1){
		$gaps_parcent = substr($gaps_parcent, 0, $piriod+2);
	    }
	}

#print STDOUT "eXgR-11\n";
	$print_query =
	    sprintf(" Query= %18s : Length= (%5d)\n", $query_id,$q_length);
	$print_sbjct =
	    sprintf(" Sbjct= %18s : Length= (%5d)\n\n", $sbjct_id,$s_length);
	$print_identities = 
	    sprintf("  Identities= %5d / %5d (%5s%)\n", $identities_num, $alignment_num, $identities_parcent);
	$print_gaps = 
	    sprintf("  Missmaches= %5d / %5d (%5s%)\n\n", $gaps_num, $alignment_num, $gaps_parcent);

	#############################################
	## Alignment Output File Create
	#############################################

#print STDOUT "eXgR-12\n";
	open(OUTPUT,">$output_file_path") || die "No $output_file_path.";

	print OUTPUT "$print_query";
	print OUTPUT "$print_sbjct";

	print OUTPUT "$print_identities";
	print OUTPUT "$print_gaps";

#print STDOUT "eXgR-13\n";
	for($i=0,$n=0,$t=0; $n<length($query_line); $i++,$n=$n+100,$t=$t+110){

	    $query_line_table[$i] = substr($query_line, $n, 100);
	    $bar_line_table[$i]   = substr($bar_line, $n, 100);
	    $sbjct_line_table[$i] = substr($sbjct_line, $n, 100);
	    $q_num_line_table[$i] = substr($q_num_line, $t, 110);
	    $s_num_line_table[$i] = substr($s_num_line, $t, 110);
	    if($amino_mode =~ "ON"){
		$q_orf_line_table[$i] = substr($q_orfline, $n, 100); ## /* 2002.07.08 Reprori version add */
		$s_orf_line_table[$i] = substr($s_orfline, $n, 100); ## /* 2002.07.08 Reprori version add */
		$q_orf_line_table[$i] =~ s/\(/&lt;/g;
		$q_orf_line_table[$i] =~ s/\)/&gt;/g;
		$s_orf_line_table[$i] =~ s/\(/&lt;/g;
		$s_orf_line_table[$i] =~ s/\)/&gt;/g;
	    }

#	    if($amino_mode =~ "ON"){
#		print OUTPUT "          $q_orf_line_table[$i]\n"; ## /* 2002.07.08 Reprori version add */
#	    }
	    print OUTPUT "$q_num_line_table[$i]\n";
	    print OUTPUT " Query :  $query_line_table[$i]\n";
	    print OUTPUT "          $bar_line_table[$i]\n";
	    print OUTPUT " Sbjct :  $sbjct_line_table[$i]\n";
	    print OUTPUT "$s_num_line_table[$i]\n";
#	    if($amino_mode =~ "ON"){
#		print OUTPUT "          $s_orf_line_table[$i]\n"; ## /* 2002.07.08 Reprori version add */
#	    }
	    print OUTPUT "\n";

	}
	close(OUTPUT);

	## /* 2003.07.22 Reprori version add start */
	if($amino_mode =~ "ON"){
	    my(@query_html_line, @sbjct_html_line);
	    my($total_line_cnt);
	    my($buf);

	    @query_html_line = @sbjct_html_line = ();

	    ## /* Bug taisaku 2003.10.16 add start */
	    $buf = ();
	    for($i=0; $i<length($query_line); $i++){
		$buf = substr($query_line, $i, 1);
		if($buf =~ /\-/){
		    ## /* Bug taisaku 2003.10.22 add start */
#		    if($i < $qos) {
#			$qos++;
#		    }
		    ## /* Bug taisaku 2003.10.22 add end */
#		    if($i < $qoe) { # 2004.01.21 add by hatano
#			$qoe++;
#		    }
		}
	    }
	    for($i=0; $i<length($sbjct_line); $i++){
		$buf = substr($sbjct_line, $i, 1);
		if($buf =~ /\-/){
		    ## /* Bug taisaku 2003.10.22 add start */
#		    if($i < $qos) {
#		    if($i < $sos) {
#			$sos++;
#		    }
		    ## /* Bug taisaku 2003.10.22 add end */
#		    if($i < $soe) { # 2004.01.21 add by hatano
#			$soe++;
#		    }
		}
	    }
	    ## /* Bug taisaku 2003.10.16 add end */

#print STDOUT "query_IN:[$query_IN],query_EN:[$query_EN],qos[$qos],qoe[$qoe]\n";
	    for($i=0,$total_line_cnt=0; $i<$#query_line_table+1; $i++){
#		if($query_IN ne "" && $query_EN eq ""){ # 2004.01.19 add by hatano.
		if($query_IN ne ""){ # 2004.01.19 add by hatano.
		    ($query_html_line[$i]) = 
		    &html_query_align_line_make(\$query_line_table[$i], $qos, $qoe, \$total_line_cnt);
		}
		else{
		    $query_html_line[$i] = $query_line_table[$i];
		}
	    }
#print STDOUT "sbjct_IN:[$sbjct_IN],sbjct_EN:[$sbjct_EN],sos[$sos],soe[$soe]\n";
	    for($i=0,$total_line_cnt=0; $i<$#sbjct_line_table+1; $i++){
#		if($sbjct_IN ne "" && $sbjct_EN eq ""){ # 2004.01.19 add by hatano.
		if($sbjct_IN ne ""){ # 2004.01.19 add by hatano.
		    ($sbjct_html_line[$i]) = 
		    &html_sbjct_align_line_make(\$sbjct_line_table[$i], $sos, $soe, \$total_line_cnt);
		}
		else{
		    $sbjct_html_line[$i] = $sbjct_line_table[$i];
		}
	    }

	    open(HTML,">$output_amino_path") || die "No $output_amino_path.";

	    print HTML "<HTML>\n";
# 2004.01.21 CHG by hatano. -START-
	    print HTML "<style TYPE=\"text/css\">";
	    print HTML "<!--\n";
	    print HTML "H1 { page-break-before: always; }\n";
	    print HTML "-->\n";
	    print HTML "</style>\n";
# 2004.01.21 CHG by hatano. -END-
	    print HTML "<PRE>\n";
	    print HTML "<basefont size=\"3\">\n";
	    print HTML "$print_query";
	    print HTML "$print_sbjct";

	    print HTML "$print_identities";
	    print HTML "$print_gaps";

######################################################################################################
#	    print HTML "<div style=\"padding-left:50px\"><hr width=610 align=left></div>\n";
######################################################################################################
	    # 2004.01.21 add by hatano.
	    print HTML "<div style=\"padding-left:50px\"><hr width=610 align=left></div><br>";

	    $first_page_flg = 1;	# 2004.01.21 add by hatano.
	    $page_line_counter = 1;	# 2004.01.21 add by hatano.
	    for($i=0; $i<$#query_line_table+1; $i++){

######################################################################################################
#		print HTML "          $q_orf_line_table[$i]\n";
#		print HTML "$q_num_line_table[$i]\n";
#		print HTML " Query :  $query_html_line[$i]\n";
#		print HTML "          $bar_line_table[$i]\n";
#		print HTML " Sbjct :  $sbjct_html_line[$i]\n";
#		print HTML "$s_num_line_table[$i]\n";
#		print HTML "          $s_orf_line_table[$i]\n";
#		print HTML "<div style=\"padding-left:50px\"><hr width=610 align=left></div>\n";
######################################################################################################
# 2004.01.21 CHG by hatano. -START-
		print HTML "          $q_orf_line_table[$i]<br>";
		print HTML "$q_num_line_table[$i]<br>";
		print HTML " Query :  $query_html_line[$i]<br>";
		print HTML "          $bar_line_table[$i]<br>";
		print HTML " Sbjct :  $sbjct_html_line[$i]<br>";
		print HTML "$s_num_line_table[$i]<br>";
		print HTML "          $s_orf_line_table[$i]";

		if($first_page_flg == 1){
		    if($page_line_counter == 7){
			print HTML "<h1><br></h1>";
			$page_line_counter = 0;
			$first_page_flg = 0;
		    }
		    else{
			print HTML "<br>";
		    }
		}
		else{
		    if($page_line_counter == 8){
			print HTML "<h1><br></h1>";
			$page_line_counter = 0;
		    }
		    else{
			print HTML "<br>";
		    }
		}
		print HTML "<div style=\"padding-left:50px\"><hr width=610 align=left></div><br>";
		$page_line_counter++;
# 2004.01.21 CHG by hatano. -END-
	    }
	    print HTML "</PRE>\n";
	    print HTML "</HTML>\n";
	    close(HTML);
	}
	## /* 2003.07.22 Reprori version add end */

#print STDOUT "eXgR-14\n";
	## /* 2003.04.02 */ ##
	if($align_ss_fasta_mode == 1){
	    &ss_fasta_create($sbjct_line,$sbjct_fasta_file_path,$work_dir,$bar_line,$query_id);
	}

    }
EXIT:
#print STDOUT "eXgR-15\n";
    close(NG_FILE);
    return($ret,$query_line,$sbjct_line);
}
###############################################################################
sub one_alignment_edit {
    ($qnt_start_pos,$qnt_end_pos,$tnt_start_pos,$tnt_end_pos,$qnt_alignment,$tnt_alignment) = @_;

    my($qnt_length,$tnt_length);
    my($alignment_or_mark);
    my($ident_count,$gap_count);
    my($c);
    my($rtn_alignment);

    $alignment_or_mark = $rtn_alignment = ();

    $qnt_length = length($qnt_alignment);
    $tnt_length = length($tnt_alignment);

    $ident_count = $gap_count = 0;

    for($i=0; $i<$qnt_length; $i++) {
	$char_qnt = substr($qnt_alignment, $i, 1);
	$char_tnt = substr($tnt_alignment, $i, 1);
	if($char_qnt eq $char_tnt) {
		$alignment_or_mark .= '|';
		$ident_count++;
	}
	else {
		$alignment_or_mark .= '*';
		$gap_count++;
		$uc_char_qnt = uc($char_qnt);
		$uc_char_tnt = uc($char_tnt);
		substr($qnt_alignment, $i, 1, $uc_char_qnt);
		substr($tnt_alignment, $i, 1, $uc_char_tnt);
	}
    }
    $rtn_alignment = "$qnt_start_pos,$qnt_alignment,$qnt_end_pos,$tnt_start_pos,$tnt_alignment,$tnt_end_pos,$alignment_or_mark";

    return $rtn_alignment;

##    print "==========================\n";
##    printf("Query:[%5d]:%s:[%5d]\n",$qnt_start_pos,$qnt_alignment,$qnt_end_pos);
##    printf("              %s\n",$alignment_or_mark);
##    printf("Sbjct:[%5d]:%s:[%5d]\n",$tnt_start_pos,$tnt_alignment,$tnt_end_pos);
}
###############################################################################
sub alignment_sort {
    ($tmp_file,$output_file) = @_;

    my(%ge);
    my(@start_pos);
    my($i);

    @ge = ();
    @start_pos = ();

    open(TMP,"<$tmp_file") || die "No $tmp_file.";
    while(<TMP>){
        chomp($_);
        push(@ge,$_);
        @dt = split(',',$_);
        ## QNT_START_POS
        push(@start_pos, $dt[0]);
    }
    close(TMP);

    @ge = @ge[sort {$start_pos[$a] <=> $start_pos[$b] } 0 .. $#start_pos];

    open(OUT,">$output_file") || die "No $output_file.";
    foreach $i ( @ge ){
        chomp($i);

        print OUT "$i\n";

    }
    close(OUT);
}
###############################################################################
sub alignment_checker {
    ($tmp_file,$output_file) = @_;

    my(%lines);
    my(@buf);
    my($i, $j, $count, $remove_cnt, $n);
    my(@q_start_pos,@q_end_pos,@t_start_pos,@t_end_pos);
    my(@Removes);
    my($stat);
    my($print_flag);
    my($print_line_count);
    my($removed_flg);

    @lines = ();
    @buf = ();
    @Removes = ();
    @q_start_pos = @q_end_pos = @t_start_pos = @t_end_pos = ();
    $count = $remove_cnt = 0;
    $print_flag = "YES";
    $print_line_count = 0;
    $removed_flg = 0;

    open(TMP,"<$tmp_file") || die "No $tmp_file.";
    while(<TMP>){
        chomp($_);
	push(@lines,$_);
	@buf = split(',',$_);
	push(@q_start_pos, $buf[0]);
	push(@q_end_pos, $buf[2]);
	push(@t_start_pos, $buf[3]);
	push(@t_end_pos, $buf[5]);
	$count++;
    }
    close(TMP);

    for($i=0; $i<$count; $i++){
	for($j=$i+1; $j<$count; $j++){
#	    if($i != $j){
		for($n=0; $n<$remove_cnt;$n++){
		    if($i == $Removes[$n]){
			$removed_flg = 1;
		    }
		}
		if($removed_flg == 0){
#		    if((($q_start_pos[$j] >= $q_start_pos[$i]) && ($q_end_pos[$j] <= $q_end_pos[$i])) ||
#		       (($t_start_pos[$j] >= $t_start_pos[$i]) && ($t_end_pos[$j] <= $t_end_pos[$i]))) {
# TEST
		    if(($q_start_pos[$j] >= $q_start_pos[$i] && $q_end_pos[$j] <= $q_end_pos[$i]) ||
		       ($t_start_pos[$j] >= $t_start_pos[$i] && $t_end_pos[$j] <= $t_end_pos[$i]) ||
		       ($q_start_pos[$i] >= $q_start_pos[$j] && $q_end_pos[$i] <= $q_end_pos[$j]) ||
		       ($t_start_pos[$i] >= $t_start_pos[$j] && $t_end_pos[$i] <= $t_end_pos[$j])) {
			push(@Removes, $j);
			$remove_cnt++;
#print STDOUT "$q_start_pos[$i],$q_end_pos[$i], -- $q_start_pos[$j],$q_end_pos[$j]\n";
		    }
		}
		else{
		    $removed_flg = 0;
		}
#	    }
	}
	$j=0;
    }
    
    open(OUT,">$output_file") || die "No $output_file.";
    for($i=0; $i<$count; $i++){
	$stat = $lines[$i];
        chomp($stat);
	if($remove_cnt == 0){
	    print OUT "$stat\n";
	    $print_line_count++;
	}
	else{
	    for($j=0; $j<$remove_cnt; $j++){
		if($i == $Removes[$j]){
		    $print_flag = "NO";
		    last;
		}
		else{
		    $print_flag = "YES";
		}
	    }
	    if($print_flag eq "YES"){
#print "STAT:$stat\n";
		print OUT "$stat\n";
		$print_line_count++;
	    }
	}
    }
    close(OUT);

    return ($print_line_count);

}
###############################################################################
sub alignment_checker2 {
    ($tmp_file,$output_file) = @_;

    my(%lines);
    my(@buf);
    my($i, $j, $count, $remove_cnt, $n);
    my(@q_start_pos,@q_end_pos,@t_start_pos,@t_end_pos);
    my(@Removes);
    my($stat);
    my($print_flag);
    my($print_line_count);
    my($removed_flg);

    @lines = ();
    @buf = ();
    @Removes = ();
    @q_start_pos = @q_end_pos = @t_start_pos = @t_end_pos = ();
    $count = $remove_cnt = 0;
    $print_flag = "YES";
    $print_line_count = 0;
    $removed_flg = 0;

    open(TMP,"<$tmp_file") || die "No $tmp_file.";
    while(<TMP>){
        chomp($_);
	push(@lines,$_);
	@buf = split(',',$_);
	push(@q_start_pos, $buf[0]);
	push(@q_end_pos, $buf[2]);
	push(@t_start_pos, $buf[3]);
	push(@t_end_pos, $buf[5]);
	$count++;
    }
    close(TMP);

    for($i=0; $i<$count; $i++){
	for($j=$i+1; $j<$count; $j++){
	    for($n=0; $n<$remove_cnt;$n++){
		if($i == $Removes[$n]){
		    $removed_flg = 1;
		}
	    }
	    if($removed_flg == 0){
		if($q_start_pos[$i] <= $q_start_pos[$j]){
		    if($t_start_pos[$i] >= $t_start_pos[$j]){
			push(@Removes, $j);
			$remove_cnt++;
		    }
		}
		elsif($q_start_pos[$i] >= $q_start_pos[$j]){
		    if($t_start_pos[$i] <= $t_start_pos[$j]){
			push(@Removes, $j);
			$remove_cnt++;
		    }
		}
	    }
	    else{
		$removed_flg = 0;
	    }
	}
	$j=0;
    }
    
    open(OUT,">$output_file") || die "No $output_file.";
    for($i=0; $i<$count; $i++){
	$stat = $lines[$i];
        chomp($stat);
	if($remove_cnt == 0){
	    print OUT "$stat\n";
	    $print_line_count++;
	}
	else{
	    for($j=0; $j<$remove_cnt; $j++){
		if($i == $Removes[$j]){
		    $print_flag = "NO";
		    last;
		}
		else{
		    $print_flag = "YES";
		}
	    }
	    if($print_flag eq "YES"){
#print "STAT:$stat\n";
		print OUT "$stat\n";
		$print_line_count++;
	    }
	}
    }
    close(OUT);

    return ($print_line_count);

}
###############################################################################
sub alignment_checker3 {
    ($tmp_file,$output_file) = @_;

    my(%lines);
    my(@buf);
    my($i, $j, $n, $count, $remove_cnt, $p);
    my(@q_start_pos,@q_length,@q_end_pos,@t_start_pos,@t_length,@t_end_pos);
    my(@Removes);
    my($stat);
    my($print_flag);
    my($print_line_count);
    my($work);
    my($length_wk);
    my($q_start_wk1,$q_start_wk2,$t_start_wk1,$t_start_wk2);
    my($q_end_wk1,$q_end_wk2,$t_end_wk1,$t_end_wk2);
    my($cmp_counter);
    my($removed_flg);

    @lines = ();
    @buf = ();
    @Removes = ();
    @q_start_pos = @q_length = @q_end_pos = @t_start_pos = @t_length = @t_end_pos = ();
    $count = $remove_cnt = 0;
    $print_flag = "YES";
    $print_line_count = 0;
    $work = ();
    $length_wk = 0;
    $q_start_wk1 = $q_start_wk2 = $t_start_wk1 = $t_start_wk2 = 0;
    $q_end_wk1 = $q_end_wk2 = $t_end_wk1 = $t_end_wk2 = 0;
    $cmp_counter = 0;
    $removed_flg = 0;

    open(TMP,"<$tmp_file") || die "No $tmp_file.";
    while(<TMP>){
        chomp($_);
	push(@lines,$_);
	@buf = split(',',$_);
	push(@q_start_pos, $buf[0]);
	$work = length($buf[1]);
	push(@q_length, $work);
	push(@q_end_pos, $buf[2]);
	push(@t_start_pos, $buf[3]);
	$work = length($buf[4]);
	push(@t_length, $work);
	push(@t_end_pos, $buf[5]);
	$count++;
    }
    close(TMP);

    for($i=0; $i<$count; $i++){
	for($j=$i+1,$comp_counter=0; $j<$count; $j++){

	    for($p=0; $p<$remove_cnt;$p++){
		if($i == $Removes[$p]){
		    $removed_flg = 1;
		}
	    }
	    if($removed_flg == 0){
		if((($q_start_pos[$j] >= $q_start_pos[$i]) && ($q_start_pos[$j] <= $q_end_pos[$i])) ||
		   (($q_end_pos[$j] >= $q_start_pos[$i]) && ($q_end_pos[$j] <= $q_end_pos[$i]))) {

		    $q_start_wk1 = $q_start_pos[$i];
		    $q_end_wk1 = $q_end_pos[$i];
		    $q_start_wk2 = $q_start_pos[$j];
		    $q_end_wk2 = $q_end_pos[$j];

		    for($n=$q_start_wk1; $n<$q_end_wk1; $n++){
			if(($n >= $q_start_wk2) && ($n <= $q_end_wk2)){
			    $cmp_counter++;
			}
		    }
## /* 2002.04.03 COMMENT */
#		    if($q_length[$i] <= $q_length[$j]){
#			$length_wk = $q_length[$i];
#		    }
#		    else{
			$length_wk = $q_length[$j];
#		    }
		    $cmp_percent = ($cmp_counter / $length_wk) * 100;
			if($comp_value <= $cmp_percent){
			push(@Removes, $j);
			$remove_cnt++;
		    }
		}
		elsif((($t_start_pos[$j] >= $t_start_pos[$i]) && ($t_start_pos[$j] <= $t_end_pos[$i])) ||
		      (($t_end_pos[$j] >= $t_start_pos[$i]) && ($t_end_pos[$j] <= $t_end_pos[$i]))) {

		    $t_start_wk1 = $t_start_pos[$i];
		    $t_end_wk1 = $t_end_pos[$i];
		    $t_start_wk2 = $t_start_pos[$j];
		    $t_end_wk2 = $t_end_pos[$j];

		    for($n=$t_start_wk1; $n<$t_end_wk1; $n++){
			if(($n >= $t_start_wk2) && ($n <= $t_end_wk2)){
			    $cmp_counter++;
			}
		    }
## /* 2002.04.03 COMMENT */
#		    if($t_length[$i] <= $t_length[$j]){
#			$length_wk = $t_length[$i];
#		    }
#		    else{
			$length_wk = $t_length[$j];
#		    }
		    $cmp_percent = ($cmp_counter / $length_wk) * 100;
			if($comp_value <= $cmp_percent){
			push(@Removes, $j);
			$remove_cnt++;
		    }
		}
	    }
	    else{
		$removed_flg = 0;
	    }
	}
	$j=0;
    }
    
    open(OUT,">$output_file") || die "No $output_file.";
    for($i=0; $i<$count; $i++){
	$stat = $lines[$i];
        chomp($stat);
	if($remove_cnt == 0){
	    print OUT "$stat\n";
	    $print_line_count++;
	}
	else{
	    for($j=0; $j<$remove_cnt; $j++){
		if($i == $Removes[$j]){
		    $print_flag = "NO";
		    last;
		}
		else{
		    $print_flag = "YES";
		}
	    }
	    if($print_flag eq "YES"){
#print "STAT:$stat\n";
		print OUT "$stat\n";
		$print_line_count++;
	    }
	}
    }
    close(OUT);

    return ($print_line_count);

}
###############################################################################
sub global_alignment_make {
    ($input_file,$query_fasta_file_path,$sbjct_fasta_file_path,
     $qos,$qoe,$sos,$soe,$qlen,$slen) = @_; ## /* 2002.07.04 Reprori version chg */

    my(@QstartBuf,@QseqBuf,@QendBuf);
    my(@TstartBuf,@TseqBuf,@TendBuf);
    my(@SeqOrBuf);
    my($line);
    my($i,$j);
    my($alignment_cnt);
    my($query_gap,$sbjct_gap);
    my($query_union,$sbjct_union);
    my($pos);
    my($query_gap_stat,$sbjct_gap_stat);
    my($Qstr, $Tstr, $BARstr);
    my($blank,$blank2);
    my($rtn_query,$rtn_bar,$rtn_sbjct);
    my($wk_query,$wk_bar,$wk_sbjct); # /* 2003.05.14 add */
    my($updt_flag, $left_or_right);
    my($query_start_point,$sbjct_start_point);
    my($q_orfline,$s_orfline); ## /* 2002.07.04 Reprori version add */
    my($q_orfline_wk,$s_orfline_wk); ## /* 2002.07.04 Reprori version add */
    my($q_orfline_wk2,$s_orfline_wk2); ## /* 2002.07.04 Reprori version add */
    my($q_orfline_wk3,$s_orfline_wk3); ## /* 2002.07.14 Reprori version add */
    my($q_orf_len,$s_orf_len); ## /* 2002.07.04 Reprori version add */
    my($q_orf_head_len,$s_orf_head_len); ## /* 2002.07.04 Reprori version add */
    my($q_orf_tail_len,$s_orf_tail_len); ## /* 2002.07.04 Reprori version add */

    @QstartBuf = @QseqBuf = @QendBuf = ();
    @TstartBuf = @TseqBuf = @TendBuf = ();
    @SeqOrBuf = ();
    $Qstr = $Tstr = $BARstr = ();
    $rtn_query = $rtn_bar = $rtn_sbjct = ();
    $wk_query = $wk_bar = $wk_sbjct = (); # /* 2003.05.14 add */
    $updt_flag = $left_or_right = 0;
    $query_start_point = $sbjct_start_point = 1;
    $q_orfline = $s_orfline = (); ## /* 2002.07.04 Reprori version add */
    $q_orfline_wk = $s_orfline_wk = (); ## /* 2002.07.04 Reprori version add */
    $q_orfline_wk2 = $s_orfline_wk2 = (); ## /* 2002.07.04 Reprori version add */
    $q_orfline_wk3 = $s_orfline_wk3 = (); ## /* 2002.07.14 Reprori version add */
    $q_orf_len = $s_orf_len = 0;  ## /* 2002.07.04 Reprori version add */
    $q_orf_head_len = $s_orf_head_len = 0;  ## /* 2002.07.04 Reprori version add */
    $q_orf_tail_len = $s_orf_tail_len = 0;  ## /* 2002.07.04 Reprori version add */

#print STDOUT "eXgR-6-1\n";
    open(INPUT,"<$input_file") || die "No $input_file.";
    $i=0;
#print STDOUT "eXgR-6-2\n";
    while($line = <INPUT>) {
	chomp($line);

	($QstartBuf[$i],$QseqBuf[$i],$QendBuf[$i],
	 $TstartBuf[$i],$TseqBuf[$i],$TendBuf[$i],
	 $SeqOrBuf[$i])		= split(/\,/, $line);
	$i++;
    }
    close(INPUT);
#print STDOUT "eXgR-6-3\n";

    $alignment_cnt = $i;
#print STDOUT "eXgR-6-3:alignment_cnt:$alignment_cnt\n";

    for($i=0; $i<$alignment_cnt; $i++){
	#print STDOUT "<<$QstartBuf[$i],$QseqBuf[$i],$QendBuf[$i],$TstartBuf[$i],$TseqBuf[$i],$TendBuf[$i],$SeqOrBuf[$i]>>\n";
	$query_gap = $query_union = $sbjct_gap = $sbjct_union = 0;
	$query_gap_stat = $sbjct_gap_stat = ();
	$blank = $blank2 = ();

	######################################
	## Alignment Last Check
	######################################
	if($QstartBuf[$i+1] eq /\s+/ & $TstartBuf[$i+1] eq /\s+/) {
	    $query_gap = $sbjct_gap = 0;
	    $query_gap_stat = $sbjct_gap_stat = ();
	}

#open(TEST, ">>comp_test.txt");
	######################################
	## Query Alignment Check
	######################################
	if(($QstartBuf[$i+1] - $QendBuf[$i]) > 1){
	    $query_gap = ($QstartBuf[$i+1] - $QendBuf[$i]) - 1;
	    $query_union = 0;
#print STDOUT "query_gap:[$query_gap]\n";
	    $query_gap_stat = &fasta_gap_get($query_fasta_file_path,$QendBuf[$i],$query_gap);
#print STDOUT "query_rtn_str:[$query_gap_stat]\n";
#print STDOUT "TEST_1_1, $query_gap_stat\n";
	}
	elsif(($QstartBuf[$i+1] - $QendBuf[$i]) == 1){
	    $query_gap = 0;
	    $query_union = 0;
#print STDOUT "TEST_1_2\n";
	}
	elsif((($QstartBuf[$i+1] - $QendBuf[$i]) <= 0) & ($QstartBuf[$i+1] ne /\s+/)){
	    $query_gap = 0;
	    $query_union = ($QendBuf[$i] - $QstartBuf[$i+1]) + 1;
#print STDOUT "TEST_1_3\n";
	}
	else{
	    $query_gap = 0;
	    $query_union = 0;
	    $query_gap_stat = ();
#print STDOUT "TEST_1_4\n";
	}

	######################################
	## Sbjct Alignment Check
	######################################
	if(($TstartBuf[$i+1] - $TendBuf[$i]) > 1){
	    $sbjct_gap = ($TstartBuf[$i+1] - $TendBuf[$i]) - 1;
	    $sbjct_union = 0;
#print STDOUT "sbjct_gap:[$sbjct_gap]\n";
	    $sbjct_gap_stat = &fasta_gap_get($sbjct_fasta_file_path,$TendBuf[$i],$sbjct_gap);
	    ##print "sbjct_rtn_str:[$sbjct_gap_stat]\n";
#print STDOUT "TEST_2_1, $sbjct_gap_stat\n";
	}
	elsif(($TstartBuf[$i+1] - $TendBuf[$i]) == 1){
	    $sbjct_gap = 0;
	    $sbjct_union = 0;
#print STDOUT "TEST_2_2\n";
	}
	elsif((($TstartBuf[$i+1] - $TendBuf[$i]) <= 0) & ($TstartBuf[$i+1] ne /\s+/)){
	    $sbjct_gap = 0;
	    $sbjct_union = ($TendBuf[$i] - $TstartBuf[$i+1]) + 1;
#print STDOUT "TEST_2_3\n";
	}
	else{
	    $sbjct_gap = 0;
	    $sbjct_union = 0;
	    $sbjct_gap_stat = ();
#print STDOUT "TEST_2_4\n";
	}

	######################################
	## Alignment Gap Make
	######################################
	if($query_gap > $sbjct_gap){
#print STDOUT "TEST_A-> $query_gap, $sbjct_gap\n";
	    for($j=0; $j<($query_gap - $sbjct_gap); $j++){
		$blank .= ' ';
	    }
	    for($j=0; $j<length($sbjct_gap_stat); $j++){
		$blank2 .= ' ';
	    }
	    if($sbjct_union > 0) {
		&alignment_union_check(\$SeqOrBuf[$i],\$SeqOrBuf[$i+1],\$TseqBuf[$i],\$TseqBuf[$i+1],$sbjct_union,
					\$QseqBuf[$i],\$QseqBuf[$i+1]);
	    }
	    if(($query_gap > 0) & ($sbjct_gap > 0)){
		($updt_flag,$left_or_right) = &update_sbjct_gap_state(\$query_gap_stat,\$sbjct_gap_stat,\$blank2);
	    }
	    if(($updt_flag == 1) & ($left_or_right == 1)){
		$Tstr = $Tstr . $TseqBuf[$i] . $blank . $sbjct_gap_stat;
		$BARstr = $BARstr . $SeqOrBuf[$i] . $blank . $blank2;
	    }
	    else{
		$Tstr = $Tstr . $TseqBuf[$i] . $sbjct_gap_stat . $blank;
		$BARstr = $BARstr . $SeqOrBuf[$i] . $blank2 . $blank;
	    }
	    $Qstr = $Qstr . $QseqBuf[$i] . $query_gap_stat;
	}
	elsif($query_gap < $sbjct_gap){
#print STDOUT "TEST_B-> $query_gap, $sbjct_gap, $query_union, $sbjct_union\n";
	    for($j=0; $j<($sbjct_gap - $query_gap); $j++){
		$blank .= ' ';
	    }
#print STDOUT "eXgR-6-3-1\n";
	    for($j=0; $j<length($query_gap_stat); $j++){
		$blank2 .= ' ';
	    }
#print STDOUT "eXgR-6-3-2\n";
	    if($query_union > 0) {
		&alignment_union_check(\$SeqOrBuf[$i],\$SeqOrBuf[$i+1],\$QseqBuf[$i],\$QseqBuf[$i+1],$query_union,
					\$TseqBuf[$i],\$TseqBuf[$i+1]);
	    }
#print STDOUT "eXgR-6-3-3\n";
	    if(($query_gap > 0) & ($sbjct_gap > 0)){
		($updt_flag,$left_or_right) = &update_query_gap_state(\$query_gap_stat,\$sbjct_gap_stat,\$blank2);
	    }
#print STDOUT "eXgR-6-3-4\n";
	    if(($updt_flag == 1) & ($left_or_right == 1)){
		$Qstr = $Qstr . $QseqBuf[$i] . $blank . $query_gap_stat;
		$BARstr = $BARstr . $SeqOrBuf[$i] . $blank . $blank2;
	    }
	    else{
		$Qstr = $Qstr . $QseqBuf[$i] . $query_gap_stat . $blank;
		$BARstr = $BARstr . $SeqOrBuf[$i] . $blank2 . $blank;
	    }
#print STDOUT "eXgR-6-3-5\n";
	    $Tstr = $Tstr . $TseqBuf[$i] . $sbjct_gap_stat;
	}
	elsif($query_gap == $sbjct_gap){
#print STDOUT "TEST_C-> $query_gap, $sbjct_gap\n";
#print STDOUT "TEST_C_1-> $query_union, $sbjct_union\n";
	    if(($query_union > 0) & ($sbjct_union == 0)) {
		&alignment_union_check(\$SeqOrBuf[$i],\$SeqOrBuf[$i+1],\$QseqBuf[$i],\$QseqBuf[$i+1],$query_union,
					\$TseqBuf[$i],\$TseqBuf[$i+1]);
	    }
	    elsif(($sbjct_union > 0) & ($query_union == 0)) {
		&alignment_union_check(\$SeqOrBuf[$i],\$SeqOrBuf[$i+1],\$TseqBuf[$i],\$TseqBuf[$i+1],$sbjct_union,
					\$QseqBuf[$i],\$QseqBuf[$i+1]);
	    }
	    # /* 2002.05.15 add start */
	    elsif(($query_union > 0) & ($sbjct_union > 0)) {
		&alignment_union_check(\$SeqOrBuf[$i],\$SeqOrBuf[$i+1],\$QseqBuf[$i],\$QseqBuf[$i+1],$query_union,
					\$TseqBuf[$i],\$TseqBuf[$i+1]);
		&alignment_union_check(\$SeqOrBuf[$i],\$SeqOrBuf[$i+1],\$TseqBuf[$i],\$TseqBuf[$i+1],$sbjct_union,
					\$QseqBuf[$i],\$QseqBuf[$i+1]);
	    }
	    # /* 2002.05.15 add end */
	    for($j=0; $j<length($query_gap_stat); $j++){
		$blank2 .= ' ';
	    }
	    $Qstr = $Qstr . $QseqBuf[$i] . $query_gap_stat;
	    $BARstr = $BARstr . $SeqOrBuf[$i] . $blank2;
	    $Tstr = $Tstr . $TseqBuf[$i] . $sbjct_gap_stat;
#print STDOUT "TEST_C_2-> $Qstr\n";
#print STDOUT "TEST_C_3-> $Tstr\n";
	}
    }
    ######################################
    ## Alignment Head Make
    ######################################
    {
	$blank = $head_Q_str = $head_T_str = $head_BAR_str = ();
	$head_Q_str = &fasta_head_get($query_fasta_file_path,$QstartBuf[0]);
	$head_T_str = &fasta_head_get($sbjct_fasta_file_path,$TstartBuf[0]);
	if(length($head_Q_str) > length($head_T_str)){
	    $diff_size = length($head_Q_str) - length($head_T_str);
	    for($i=0; $i<$diff_size; $i++){
		$blank .= ' ';
	    }
	    $head_T_str = $blank . $head_T_str;
	    $blank = ();
	    for($i=0; $i<length($head_Q_str); $i++){
		$blank .= ' ';
	    }
	    $head_BAR_str = $blank;
	}
	elsif(length($head_Q_str) < length($head_T_str)){
## /* 2003.07.02 Reprori version make comment start */
##	    ## /* 2003.05.09 chg start */
##	    if($blast_mode eq "n"){
##		$diff_size = length($head_T_str) - length($head_Q_str);
##		$head_T_str = substr($head_T_str,$diff_size,length($head_Q_str));
##		$blank = ();
##		for($i=0; $i<length($head_Q_str); $i++){
##		    $blank .= ' ';
##		}
##		$head_BAR_str = $blank;
##		$sbjct_start_point = $diff_size + 1;
##	    }
##	    elsif($blast_mode eq "p"){
## /* 2003.07.02 Reprori version make comment end */
		$diff_size = length($head_T_str) - length($head_Q_str);
		for($i=0; $i<$diff_size; $i++){
		    $blank .= ' ';
		}
		$head_Q_str = $blank . $head_Q_str;
		$blank = ();
		for($i=0; $i<length($head_T_str); $i++){
		    $blank .= ' ';
		}
		$head_BAR_str = $blank;
		$sbjct_start_point = 1;
## /* 2003.07.02 Reprori version make comment start */
##	    }
##	    ## /* 2003.05.09 chg end */
## /* 2003.07.02 Reprori version make comment end */
	}
	else{
	    ## /* 2003.03.05 add by hatano */
	    if(length($head_Q_str) > 0){
	    	for($i=0; $i<length($head_Q_str); $i++){
		    $blank .= ' ';
	    	}
		$head_BAR_str = $blank;
	    }
	}
#print STDOUT "[diff_size]:$diff_size\n";
#print STDOUT "[head_Q_str  ]:$head_Q_str\n";
#print STDOUT "[head_BAR_str]:$head_BAR_str\n";
#print STDOUT "[head_T_str  ]:$head_T_str\n";
    }
    ######################################
    ## Alignment Tail Make
    ######################################
    {
	$blank = $tail_Q_str = $tail_T_str = $tail_BAR_str = ();
#print STDOUT "TEST_?->$query_fasta_file_path, $QendBuf[$#QendBuf]\n";
	$tail_Q_str = &fasta_tail_get($query_fasta_file_path,$QendBuf[$#QendBuf]);
	$tail_T_str = &fasta_tail_get($sbjct_fasta_file_path,$TendBuf[$#TendBuf]);
	if(length($tail_Q_str) > length($tail_T_str)){
#print STDOUT "TEST_D-> $tail_Q_str, $tail_T_str\n";
	    $diff_size = length($tail_Q_str) - length($tail_T_str);
	    for($i=0; $i<$diff_size; $i++){
		$blank .= ' ';
	    }
#	    $tail_T_str = $blank . $tail_T_str;
	    $tail_T_str = $tail_T_str . $blank;
	    $blank = ();
	    for($i=0; $i<length($tail_Q_str); $i++){
		$blank .= ' ';
	    }
	    $tail_BAR_str = $blank;
	}
	elsif(length($tail_Q_str) < length($tail_T_str)){
#print STDOUT "TEST_E-> $tail_Q_str, $tail_T_str\n";

## /* 2003.07.02 Reprori version make comment start */
##	    if($blast_mode eq "n"){
##		$tail_Q_sz = length($tail_Q_str);
##		$tail_T_str = substr($tail_T_str, 0, $tail_Q_sz);
##	    }
##	    elsif($blast_mode eq "p"){
## /* 2003.07.02 Reprori version make comment end */
		$diff_size = length($tail_T_str) - length($tail_Q_str);
		$blank = ();
		for($i=0; $i<$diff_size; $i++){
		    $blank .= ' ';
		}
		$tail_Q_str = $tail_Q_str . $blank;
		$blank = ();
		for($i=0; $i<length($tail_Q_str); $i++){
		    $blank .= ' ';
		}
		$tail_BAR_str = $blank;
## /* 2003.07.02 Reprori version make comment start */
##	    }
## /* 2003.07.02 Reprori version make comment end */
	}
	else{
#print STDOUT "TEST_F-> $tail_Q_str, $tail_T_str\n";
	    ## /* none */
	}

#print STDOUT "[tail_Q_str  ]:$tail_Q_str\n";
#print STDOUT "[tail_BAR_str]:$tail_BAR_str\n";
#print STDOUT "[tail_T_str  ]:$tail_T_str\n";
    }

    # /* 2003.05.14 chg start */
    $wk_query = $head_Q_str . $Qstr . $tail_Q_str;
    $wk_bar   = $head_BAR_str . $BARstr . $tail_BAR_str;
    $wk_sbjct = $head_T_str . $Tstr . $tail_T_str;
#    $rtn_query = $head_Q_str . $Qstr . $tail_Q_str;
#    $rtn_bar   = $head_BAR_str . $BARstr . $tail_BAR_str;
#    $rtn_sbjct = $head_T_str . $Tstr . $tail_T_str;
    # /* 2003.05.14 chg end */
    # /* 2003.05.14 add */
    ($rtn_query, $rtn_bar, $rtn_sbjct) = &union_padding($wk_query, $wk_bar, $wk_sbjct);

    ## /* 2002.07.04 Reprori version add start */
    if($amino_mode =~ "ON"){
	$q_orf_len = ($qoe - $qos)+1;
	$s_orf_len = ($soe - $sos)+1;
	$q_orf_head_len = $qos - 1;
	$s_orf_head_len = $sos - 1;
	$q_orf_tail_len = $qlen - ($q_orf_head_len + $q_orf_len);
	$s_orf_tail_len = $slen - ($s_orf_head_len + $s_orf_len);
	$q_orfline_wk = &fasta_gap_get($query_fasta_file_path,$qos-1,$q_orf_len);
	$s_orfline_wk = &fasta_gap_get($sbjct_fasta_file_path,$sos-1,$s_orf_len);
	($q_orfline_wk3,$s_orfline_wk3) = &orf_convert($q_orfline_wk,$s_orfline_wk);
	## Query ORF Line make
	for($i=0; $i<$q_orf_head_len; $i++){
	    $q_orfline_wk2 .= ' ';
	}
	$q_orfline_wk2 .= $q_orfline_wk3;
	for($i=0; $i<$q_orf_tail_len; $i++){
	    $q_orfline_wk2 .= ' ';
	}
	## Sbjct ORF Line make
	for($i=0; $i<$s_orf_head_len; $i++){
	    $s_orfline_wk2 .= ' ';
	}
	$s_orfline_wk2 .= $s_orfline_wk3;
	for($i=0; $i<$s_orf_tail_len; $i++){
	    $s_orfline_wk2 .= ' ';
	}
	($q_orfline,$s_orfline) = &orf_line_make($q_orfline_wk2,$s_orfline_wk2,$rtn_query,$rtn_sbjct);
#print STDOUT "[Qorf]:$q_orfline\n";
#print STDOUT "[Sorf]:$s_orfline\n";
    }
    ## /* 2002.07.04 Reprori version add end */

#print STDOUT "[Qstr  ]:$Qstr\n";
#print STDOUT "[BARstr]:$BARstr\n";
#print STDOUT "[Tstr  ]:$Tstr\n";
#print STDOUT "[Qorf  ]:$q_orfline\n";
#print STDOUT "[Qstr  ]:$rtn_query\n";
#print STDOUT "[BARstr]:$rtn_bar\n";
#print STDOUT "[Tstr  ]:$rtn_sbjct\n";
#print STDOUT "[Sorf  ]:$s_orfline\n";

#print STDOUT "SBJCT_START_POINT-> $sbjct_start_point\n";
#print STDOUT "eXgR-6-4\n";
    return($rtn_query,$rtn_bar,$rtn_sbjct,$query_start_point,$sbjct_start_point,
           $q_orfline,$s_orfline); ## /* 2002.07.04 Reprori version chg */
}
###############################################################################
sub fasta_gap_get {
    ($fasta_file_path,$start_p,$gap_size) = @_;

    my($line);
    my($info);
    my($rtn_str);

    $line = $info = $rtn_str = ();

    open(FASTA,"<$fasta_file_path") || die "No $fasta_file_path.";
    while($line = <FASTA>){
	chomp($line);
	if($line =~ /^\>/) {
	    next;
	}
	$info .= $line;
    }
    close(FASTA);

    $info = uc($info); # 2004.01.19 add by hatano.

    $rtn_str = substr($info, $start_p, $gap_size);

    return $rtn_str;
}
###############################################################################
sub fasta_head_get {
    ($fasta_file_path,$start_p) = @_;

    my($line);
    my($info);
    my($size);
    my($rtn_str);

    $line = $info = $size = $rtn_str = ();

    $size = $start_p - 1;

    open(FASTA,"<$fasta_file_path") || die "No $fasta_file_path.";
    while($line = <FASTA>){
	chomp($line);
	if($line =~ /^\>/) {
	    next;
	}
	$info .= $line;
    }
    close(FASTA);

    $info = uc($info); # 2004.01.19 add by hatano.

    $rtn_str = substr($info, 0, $size);

    return $rtn_str;
}
###############################################################################
sub fasta_tail_get {
    ($fasta_file_path,$start_p) = @_;

    my($line);
    my($info);
    my($size);
    my($rtn_str);

    $line = $info = $size = $rtn_str = ();

    open(FASTA,"<$fasta_file_path") || die "No $fasta_file_path.";
    while($line = <FASTA>){
	chomp($line);
	if($line =~ /^\>/) {
	    next;
	}
	$info .= $line;
    }
    close(FASTA);

    $size = length($info) - $start_p;
    $info = uc($info); # 2004.01.19 add by hatano.

    $rtn_str = substr($info, $start_p, $size);

    return $rtn_str;
}
###############################################################################
sub alignment_union_check {
    ($SeqOrBuf_1,$SeqOrBuf_2,$SeqBuf_1,$SeqBuf_2,$union_count,$OObuf1,$OObuf2) = @_;

    my($left_last_bar_pos,$left_start_bar_pos,$left_last_bar);
    my($right_first_bar_pos,$right_first_bar);
    my($n);
    my($bar_char);
    my($blank);
    my($work);
    ## /* 2003.05.09 add start */
    my($update_count, $i, $eiji_count, $blank_count);
    my($char);
    ## /* 2003.05.09 add end */

    $left_last_bar_pos = length($$SeqOrBuf_1) - 1;
    $left_start_bar_pos = $left_last_bar_pos - $union_count;
    $left_last_bar = substr($$SeqOrBuf_1, $left_start_bar_pos, $union_count);

    $right_first_bar_pos = 0;
    $right_first_bar = substr($$SeqOrBuf_2, $left_last_bar_pos, $union_count);

    for($n=0; $n<length($left_last_bar); $n++){
        $bar_char = substr($left_last_bar, $n, 1);
        if($bar_char eq /\|/){
	    $left_last_bar_cnt++;
        }
    }
    for($n=0; $n<length($right_first_bar); $n++){
        $bar_char = substr($right_first_bar, $n, 1);
        if($bar_char eq /\|/){
	    $right_first_bar_cnt++;
        }
    }

#    $blank = ();
#    for($n=0; $n<$union_count; $n++){
#	$blank .= ' ';
#    }

    ######################################
    ## Change Blank 
    ######################################
    if($left_last_bar_cnt >= $right_first_bar_cnt){
	## /* 2003.05.09 add start */
	$i = 0;
	$eiji_count = $blank_count = 0;
#print STDOUT "eiji_count:$eiji_count\n";
#print STDOUT "union_count:$union_count\n";
#print STDOUT "TEST_LEFT\n";
	while($eiji_count < $union_count){
#	while($blank_count < $union_count){
#	for($i=0; $i<$union_count;$i++){
	    $char = substr($$SeqBuf_2, $i, 1);
	    if($char =~ /[A-Za-z]/){
#print STDOUT "$char";
		$eiji_count++;
	    }
	    $i++;
	    $blank_count++;
#print STDOUT "eiji_count:$eiji_count\n";
#print STDOUT "union_count:$union_count\n";
	}
#print STDOUT "blank_count:$blank_count\n";
	$blank = ();
	for($n=0; $n<$blank_count; $n++){
	    $blank .= ' ';
	}
	## /* 2003.05.09 add end */
        substr($$SeqOrBuf_2, 0, $blank_count, $blank);
        substr($$SeqBuf_2, 0, $blank_count, $blank);
	$work = substr($$OObuf2, 0, $blank_count);
	$work = uc($work);
#print STDOUT "\nWORK1:$work\n";
        substr($$OObuf2, 0, $blank_count, $work);
    }
    else{
	## /* 2003.05.09 add start */
	$i = $left_start_bar_pos;
	$eiji_count = $blank_count = 0;
#print STDOUT "TEST_RIGHT\n";
	while($eiji_count < $union_count){
#	while($blank_count < $union_count){
#	for($i=0; $i<$union_count;$i++){
	    $char = substr($$SeqBuf_2, $i, 1);
	    if($char =~ /[A-Za-z]/){
#print STDOUT "$char";
		$eiji_count++;
	    }
	    $i++;
	    $blank_count++;
	}
#print STDOUT "blank_count:$blank_count\n";
	$blank = ();
	for($n=0; $n<$blank_count; $n++){
	    $blank .= ' ';
	}
	## /* 2003.05.09 add end */
        substr($$SeqOrBuf_1, $left_start_bar_pos, $blank_count, $blank);
        substr($$SeqBuf_1, $left_start_bar_pos, $blank_count, $blank);
	$work = substr($$OObuf1, $left_start_bar_pos, $blank_count);
	$work = uc($work);
#print STDOUT "\nWORK2:$work\n";
        substr($$OObuf1, $left_start_bar_pos, $blank_count, $work);
    }
}
###############################################################################
sub update_query_gap_state {
    ($query_gap_stat,$sbjct_gap_stat,$blank) = @_;

    my($update_flag,$laft_or_right);
    my($q_length,$s_length,$b_length);
    my($i);
    my($work);

    $update_flag = $left_or_right = 0;
    $q_length = $s_length = $b_length = 0;
    $work = ();

    $q_length = length($$query_gap_stat);
    $s_length = length($$sbjct_gap_stat);
    $b_length = length($$blank);

    $left_str  = substr($$sbjct_gap_stat, 0, $q_length);
    $right_str = substr($$sbjct_gap_stat, ($s_length - $q_length),$q_length);

    if(($$query_gap_stat eq $left_str) & ($$query_gap_stat eq $right_str)){
#print "TEST_A_1, $$query_gap_stat, $left_str, $right_str\n";
	$update_flag = 0;
    }
    elsif($$query_gap_stat eq $left_str){
#print "TEST_B_1, $$query_gap_stat, $left_str, $right_str\n";
	$update_flag = 1;
	$left_or_right = 0;
	$left_str  = lc($left_str);

	substr($$query_gap_stat,0,$q_length,$left_str);
	substr($$sbjct_gap_stat,0,$q_length,$left_str);

	for($i=0; $i<$b_length; $i++){
	    $work .= '|';
	}
	substr($$blank,0,$b_length,$work);
    }
    elsif($query_gap_stat eq $right_str){
#print "TEST_C_1, $$query_gap_stat, $left_str, $right_str\n";
	$update_flag = 1;
	$left_or_right = 1;
	$right_str = lc($right_str);

	substr($$query_gap_stat,($s_length - $q_length)-1,$q_length,$right_str);
	substr($$sbjct_gap_stat,($s_length - $q_length)-1,$q_length,$right_str);

	for($i=0; $i<$b_length; $i++){
	    $work .= '|';
	}
	substr($$blank,0,$b_length,$work);
    }
    else{
#print "TEST_D_1, $$query_gap_stat, $left_str, $right_str\n";
	$update_flag = 0;
    }

    return($update_flag,$laft_or_right);
}
###############################################################################
sub update_sbjct_gap_state {
    ($query_gap_stat,$sbjct_gap_stat,$blank) = @_;

    my($update_flag,$laft_or_right);
    my($q_length,$s_length,$b_length);
    my($i);
    my($work);

    $update_flag = $left_or_right = 0;
    $q_length = $s_length = $b_length = 0;
    $work = ();

    $q_length = length($$query_gap_stat);
    $s_length = length($$sbjct_gap_stat);
    $b_length = length($$blank);

    $left_str  = substr($$query_gap_stat, 0, $s_length);
    $right_str = substr($$query_gap_stat, ($q_length - $s_length),$s_length);

    if(($$sbjct_gap_stat eq $left_str) & ($$sbjct_gap_stat eq $right_str)){
print "TEST_A_2, $$sbjct_gap_stat, $left_str, $right_str\n";
	$update_flag = 0;
    }
    elsif($$sbjct_gap_stat eq $left_str){
#print "TEST_B_2, $$sbjct_gap_stat, $left_str, $right_str\n";
	$update_flag = 1;
	$left_or_right = 0;
	$left_str  = lc($left_str);

	substr($$query_gap_stat,0,$s_length,$left_str);
	substr($$sbjct_gap_stat,0,$s_length,$left_str);

	for($i=0; $i<$b_length; $i++){
	    $work .= '|';
	}
	substr($$blank,0,$b_length,$work);
    }
    elsif($sbjct_gap_stat eq $right_str){
#print "TEST_C_2, $$sbjct_gap_stat, $left_str, $right_str\n";
	$update_flag = 1;
	$left_or_right = 1;
	$right_str = lc($right_str);

	substr($$query_gap_stat,($q_length - $s_length)-1,$s_length,$right_str);
	substr($$sbjct_gap_stat,($q_length - $s_length)-1,$s_length,$right_str);

	for($i=0; $i<$b_length; $i++){
	    $work .= '|';
	}
	substr($$blank,0,$b_length,$work);
    }
    else{
#print "TEST_D_2, $$sbjct_gap_stat, $left_str, $right_str\n";
	$update_flag = 0;
    }

    return($update_flag,$laft_or_right);
}
###############################################################################
sub num_line_make {
    ($query_line,$sbjct_line,$query_start_pos,$sbjct_start_pos) = @_;

    my($q_num_line,$s_num_line);
    my($c);
    my($number);
    my($enter_cnt,$alignment_cnt,$moji_cnt);
    my($i,$n,$first_blank_cnt);

    $c = $number = ();
    $q_num_line = $s_num_line = ();

    $moji_cnt = $query_start_pos - 1;
#    for($i=0,$moji_cnt=0; $i<length($query_line); $i++){
    for($i=0; $i<length($query_line); $i++){
	if(($i % 100) == 0){
	    $q_num_line .= '          ';
	}
	$c = substr($query_line, $i, 1);
	if($c =~ /[A-Za-z]/){
	    $moji_cnt++;
	    if(($moji_cnt % 10) == 0){
		$number = sprintf("%10d", $moji_cnt);
		$q_num_line .= $number;
	    }
	}
	elsif($c =~ /\s/){
	    $q_num_line .= ' ';
	}
	elsif($c =~ /\-/){
	    $q_num_line .= ' ';
	}
    }

    $moji_cnt = $sbjct_start_pos - 1;
    if($moji_cnt != 0){
	$first_blank_cnt = 10 - ($moji_cnt % 10);
    }
    else{
	$first_blank_cnt = 10;
    }
#    for($i=0,$moji_cnt=0; $i<length($sbjct_line); $i++){
    for($i=0; $i<length($sbjct_line); $i++){
	if($i == 0){
	    for($n=0; $n<$first_blank_cnt; $n++){
		$s_num_line .= ' ';
	    }
	}
	else{
	    if(($i % 100) == 0){
		$s_num_line .= '          ';
	    }
	}
	$c = substr($sbjct_line, $i, 1);
	if($c =~ /[A-Za-z]/){
	    $moji_cnt++;
	    if(($moji_cnt % 10) == 0){
		$number = sprintf("%10d", $moji_cnt);
		$s_num_line .= $number;
	    }
	}
	elsif($c =~ /\s/){
	    $s_num_line .= ' ';
	}
	elsif($c =~ /\-/){
	    $s_num_line .= ' ';
	}
    }

    return($q_num_line,$s_num_line);
}
###############################################################################
sub num_line_make_old {
    ($query_line,$sbjct_line,$query_start_pos,$sbjct_start_pos) = @_;

    my($q_num_line,$s_num_line);
    my($c);
    my($cnt);
    my($number);
    my($enter_cnt,$alignment_cnt,$moji_cnt);
    my($i,$n);

    $c = $number = ();
    $q_num_line = $s_num_line = '          ';
    $moji_cnt = 0;

    for($i=0,$cnt=0; $i<length($query_line); $i++){
#	$enter_cnt = $i % 60;
	$enter_cnt = $i % 100;
	$c = substr($query_line, $i, 1);
	if($c =~ /\s/){
#	if($c =~ /\s/ | $c =~ /\-/){
	    if(($enter_cnt == 0) && ($i != 0)){
		$q_num_line .= '          ';
	    }
	    $q_num_line .= ' ';
	}
	## /* 2002.05.09 add start */
	elsif($c =~ /\-/){
	    if(($enter_cnt == 0) && ($i != 0)){
		$q_num_line .= '          ';
	    }
	    $q_num_line .= ' ';
	}
	## /* 2002.05.09 add end *//* Horyuu */
	else{
	    $alignment_cnt = $cnt % 10;
	    if($alignment_cnt == 0){
		if($cnt != 0){
		    if($enter_cnt >= 1 && $enter_cnt <= 9){
			for($n=0; $n<$enter_cnt; $n++){
			    $q_num_line .= ' ';
			}
			$number = sprintf("%10d", $cnt);
			$q_num_line .= $number;
		    }
		    elsif($enter_cnt == 0){
		        $number = sprintf("%10d", $cnt);
			$q_num_line .= $number;
			$q_num_line .= '          ';
		    }
		    else{
			$number = sprintf("%10d", $cnt);
			$q_num_line .= $number;
		    }
		}
	    }
	    else{
		if($enter_cnt == 0){
		    for($n=0; $n<$alignment_cnt; $n++){
			$q_num_line .= ' ';
		    }
		}
	    }
	    $cnt++;
	}
    }
    ## /* 2003.03.10 add by hatano */
#    if($sbjct_start_pos != 1){
#	$cnt = $sbjct_start_pos - 1;
#	$i   = $sbjct_start_pos - 1;
#    }
#    else{
#	$cnt = 0;
#	$i   = 0;
#    }
#print "SBJCT_START_POS-> $sbjct_start_pos,  CNT-> $cnt\n";
    for($i=0,$cnt=0; $i<length($sbjct_line); $i++){
#    for(; $i<length($sbjct_line); $i++){
#	$enter_cnt = $i % 60;
	$enter_cnt = $i % 100;
	$c = substr($sbjct_line, $i, 1);
	if($c =~ /\s/){
	    if(($enter_cnt == 0) && ($i != 0)){
		$s_num_line .= '          ';
	    }
	    $s_num_line .= ' ';
	}
	## /* 2002.05.09 add start *//* Horyuu */
	elsif($c =~ /\-/){
	    if(($enter_cnt == 0) && ($i != 0)){
		$s_num_line .= '          ';
	    }
	    $s_num_line .= ' ';
	}
	## /* 2002.05.09 add end */
	else{
	    $alignment_cnt = $cnt % 10;
	    if($alignment_cnt == 0){
		if($cnt != 0){
		    if($enter_cnt >= 1 && $enter_cnt <= 9){
			for($n=0; $n<$enter_cnt; $n++){
			    $s_num_line .= ' ';
			}
#			$number = sprintf("%10d", $cnt);
			$number = sprintf("%10d", $cnt+($sbjct_start_pos-1));
			$s_num_line .= $number;
		    }
		    elsif($enter_cnt == 0){
#		        $number = sprintf("%10d", $cnt);
			$number = sprintf("%10d", $cnt+($sbjct_start_pos-1));
			$s_num_line .= $number;
			$s_num_line .= '          ';
		    }
		    else{
#			$number = sprintf("%10d", $cnt);
			$number = sprintf("%10d", $cnt+($sbjct_start_pos-1));
			$s_num_line .= $number;
		    }
		}
	    }
	    else{
		if($enter_cnt == 0){
		    for($n=0; $n<$alignment_cnt; $n++){
			$s_num_line .= ' ';
		    }
		}
	    }
	    $cnt++;
	}
    }

    return($q_num_line,$s_num_line);
}
###############################################################################
sub check_identities {
    ($bar_line) = @_;

    my($i);
    my($c);
    my($all_cnt,$identities_cnt);

    $all_cnt = $identities_cnt= 0;

    for($i=0; $i<length($bar_line); $i++){
	$c = substr($bar_line, $i, 1);
	if($c !~ /\s/){
	    if($c =~ /\|/){
		$identities_cnt++;
	    }
	    $all_cnt++;
	}
    }
    return($all_cnt,$identities_cnt);
}
###############################################################################
sub check_gaps {
    ($bar_line) = @_;

    my($i);
    my($c);
    my($all_cnt,$gaps_cnt);

    $all_cnt = $gaps_cnt= 0;

    for($i=0; $i<length($bar_line); $i++){
	$c = substr($bar_line, $i, 1);
	if($c !~ /\s/){
	    if($c =~ /\*/){
		$gaps_cnt++;
	    }
	    $all_cnt++;
	}
    }
    return($all_cnt,$gaps_cnt);
}
###############################################################################
sub alignment_cmp {
    ($query_line,$sbjct_line,$query_start_pos,$sbjct_start_pos,
     $query_fasta_file_path,$sbjct_fasta_file_path) = @_;

    my($q_line,$s_line);
    my($q_len,$s_len);
    my($q_fasta,$s_fasta);
    my($q_work,$s_work);
    my($i,$c,$c1,$c2);
    my($line);
    my($result);

    $q_line = $s_line = $c = $line = ();
    $q_len = $s_len = 0;
    $q_fasta = $s_fasta = ();
    $q_work = $s_work = ();
    $result = "OK";

    for($i=0; $i<length($query_line); $i++){
	$c = substr($query_line, $i, 1);
	$c = uc($c);
	if($c !~ /\s/ && $c !~ /\-/){
	    $q_line .= $c;
	}
    }
    $q_len = length($q_line);

    for($i=0; $i<length($sbjct_line); $i++){
	$c = substr($sbjct_line, $i, 1);
	$c = uc($c);
	if($c !~ /\s/ && $c !~ /\-/){
	    $s_line .= $c;
	}
    }
    $s_len = length($s_line);

    open(Q_FASTA,"<$query_fasta_file_path") || die "No $query_fasta_file_path.";
    while($line = <Q_FASTA>){
	chomp($line);
	if($line =~ /^\>/) {
	    next;
	}
	$q_work .= uc($line);
    }
    close(Q_FASTA);

    open(S_FASTA,"<$sbjct_fasta_file_path") || die "No $sbjct_fasta_file_path.";
    while($line = <S_FASTA>){
	chomp($line);
	if($line =~ /^\>/) {
	    next;
	}
	$s_work .= uc($line);
    }
    close(S_FASTA);

    $q_fasta = substr($q_work, $query_start_pos-1, $q_len);
    $s_fasta = substr($s_work, $sbjct_start_pos-1, $s_len);

    for($i=0; $i<length($q_line); $i++){
	$c1 = substr($q_line, $i, 1);
	$c2 = substr($q_fasta, $i, 1);
	if ($c1 !~ $c2){
#	    open(NG_FILE,">>$error_file") || die "No $error_file.";
	    print NG_FILE "<<<<<<<<<< Query Compare Check is NG. >>>>>>>>>>\n";
	    print NG_FILE "$query_fasta_file_path, $sbjct_fasta_file_path\n";
	    print NG_FILE "[q_line ]:$q_line\n";
	    print NG_FILE "[q_fasta]:$q_fasta\n";
#	    close(NG_FILE);
	    $result = "NG";
	    #print "<<<<<< QUERY MAKE-ALIGNMENT IS NG. >>>>>>\n";
	    $error_count++;
	    goto END;
	}
    }
    for($i=0; $i<length($s_line); $i++){
	$c1 = substr($s_line, $i, 1);
	$c2 = substr($s_fasta, $i, 1);
	if ($c1 !~ $c2){
#	    open(NG_FILE,">>$error_file") || die "No $error_file.";
	    print NG_FILE "<<<<<<<<<< Sbjct Compare Check is NG. >>>>>>>>>>\n";
	    print NG_FILE "$query_fasta_file_path, $sbjct_fasta_file_path\n";
	    print NG_FILE "[s_line ]:$s_line\n";
	    print NG_FILE "[s_fasta]:$s_fasta\n";
#	    close(NG_FILE);
	    #print "<<<<<< SBJCT MAKE-ALIGNMENT IS NG. >>>>>>\n";
	    $result = "NG";
	    $error_count++;
	    goto END;
	}
    }

END:
    return($result);
}
###############################################################################
sub input_file_convert {
    ($input_file) = @_;

    my($dir);
    my($file);
    my($work_path);
    my($line);
    my($len);

    $dir  = ();
    $file = ();
    $work_path = ();

    $dir  = dirname($$input_file);
    $file = basename($$input_file);

    $dir = $dir . '/work/';

    $work_path = $dir . $file;

    if(!-d $dir){
	mkdir "$dir", 0777 or die "mkdir error!:$dir.\n";
    }

    $line = ();
#print STDOUT "$$input_file\n";
    open(INPUT,"<$$input_file") || die "No $$input_file.";
    open(WORK,">$work_path") || die "No $work_path.";
    while($line = <INPUT>){
#	$line =~ s/\x0D\x0A|\x0D|\x0A/\n/g;
	$line =~ s/\x0D\x0A/\n/g;
	$line =~ tr/\x0D\x0A/\n\n/;

	print WORK "$line";
    }
    close(WORK);
    close(INPUT);

    $$input_file = $work_path;

    return($dir);
}
###############################################################################
sub ss_fasta_create {
    ($s_line,$s_path,$work_dir,$bar_line,$query_id) = @_;

    my($s_dir);
    my($s_file);
    my($dummy);
    my($ss_fasta_path);
    my($ss_line);
    my(@SSPLIT,@POS);
    my($len,$count,$i,$pos_wk,$align_cnt);
    my($chr);
    my($wk_len);

    $s_dir = $s_file = $ss_fasta_path = $ss_line = $chr = ();
    @SSPLIT = @POS = ();
    @pos_wk = 0;
    $count = $align_cnt = $wk_len = 0;

    $s_dir  = $work_dir . '/SSFASTA/';
    $s_file = basename($s_path);
    ($s_file,$dummy) = split(/\./, $s_file);

    $len = length($bar_line);
    for($i=0; $i<$len; $i++){
	$chr = substr($bar_line, $i, 1);
	if($chr eq '*'){
	    $count++;
	}
    }
    for($i=0; $i<$count; $i++,$pos_wk++){
	$pos_wk = index($bar_line, "*", $pos_wk);
	$POS[$i] = $pos_wk;
    }

    $ss_line = $s_line;

    for($i=0; $i<$count; $i++){
	$chr = substr($ss_line,$POS[$i],1);
	$chr = lc($chr);
	substr($ss_line,$POS[$i],1,$chr);
    }

    $ss_line =~ s/[A-Z]/\ /g;

    @SSPLIT = split(/\ +/, $ss_line);
    $wk_len = length($SSPLIT[0]);
    if($wk_len == 0){
	$dummy_wk = shift(@SSPLIT);
    }

    if(!-d $s_dir){
	mkdir "$s_dir", 0777 or die "mkdir error!:$s_dir.\n";
    }

    $align_cnt = $#SSPLIT;
    for($i=0; $i<=$align_cnt; $i++){
	$SSPLIT[$i] = uc($SSPLIT[$i]);
	$ss_fasta_path = sprintf("%s%s_SS_%02d.txt", $s_dir, $query_id, $i+1);
	open(SSWORK,">$ss_fasta_path") || die "No $ss_fasta_path.";
	print SSWORK "$SSPLIT[$i]";
	close(SSWORK);
    }
}
###############################################################################
sub union_padding {
    my($q_line,$b_line,$s_line) = @_;

    my($rtn_query, $rtn_bar, $rtn_sbjct);
    my($len, $i);
    my($chr);

    $rtn_query = $rtn_bar = $rtn_sbjct = ();
    $qchr = $bchr = $schr = ();
    $len = $i = 0;

    #print STDOUT "Q1:$q_line\n";
    #print STDOUT "B1:$b_line\n";
    #print STDOUT "S1:$s_line\n";
    $len = length($q_line);
    for($i=0; $i<$len; $i++){
	$qchr = substr($q_line, $i, 1);
	$bchr = substr($b_line, $i, 1);
	$schr = substr($s_line, $i, 1);
	# /* When '-' */
	if($qchr =~ /\-/){
	    if($schr !~ /\ /){
		$rtn_query .= $qchr;
		$rtn_bar   .= $bchr;
		$rtn_sbjct .= $schr;
	    }
	}
	elsif($schr =~/\-/){
	    if($qchr !~ /\ /){
		$rtn_query .= $qchr;
		$rtn_bar   .= $bchr;
		$rtn_sbjct .= $schr;
	    }
	}
	elsif($qchr =~ /\ /){
	    if($schr !~ /\ /){
		$rtn_query .= $qchr;
		$rtn_bar   .= $bchr;
		$rtn_sbjct .= $schr;
	    }
	}
	elsif($schr =~ /\ /){
	    if($qchr !~ /\ /){
		$rtn_query .= $qchr;
		$rtn_bar   .= $bchr;
		$rtn_sbjct .= $schr;
	    }
	}
	else{
	    $rtn_query .= $qchr;
	    $rtn_bar   .= $bchr;
	    $rtn_sbjct .= $schr;
	}
    }

    #print STDOUT "Q2$rtn_query\n";
    #print STDOUT "B2$rtn_bar\n";
    #print STDOUT "S2$rtn_sbjct\n";
    return($rtn_query, $rtn_bar, $rtn_sbjct);
}
## /* 2002.07.07 Reprori version add start */
###############################################################################
sub orf_line_make {
    ($qol,$sol,$qal,$sal) = @_;

    my($rtn_qol,$rtn_sol);
    my($len, $i, $align_cnt);
    my($chr, $ochr);

    $rtn_qol = $rtn_sol = ();
    $chr = $ochr = ();
    $len = 0;

    # Query ORF LINE
    $len = length($qal);
    for($i=0,$align_cnt=0; $i<$len; $i++){
	$chr = substr($qal, $i, 1);
	# When '-' or ' '
	if($chr =~ /\-/ || $chr =~ /\ /){
	    $ochr = ' ';
	}
	# When Not '-' and ' '
	else{
	    $ochr = substr($qol, $align_cnt, 1);
	    $align_cnt++;
	}
	$rtn_qol .= $ochr;
    }

    # Sbjct ORF LINE
    $chr = $ochr = ();
    $len = length($sal);
    for($i=0,$align_cnt=0; $i<$len; $i++){
	$chr = substr($sal, $i, 1);
	# When '-' or ' '
	if($chr =~ /\-/ || $chr =~ /\ /){
	    $ochr = ' ';
	}
	# When Not '-' and ' '
	else{
	    $ochr = substr($sol, $align_cnt, 1);
	    $align_cnt++;
	}
	$rtn_sol .= $ochr;
    }

    return($rtn_qol, $rtn_sol);

}
## /* 2002.07.07 Reprori version add end */
## /* 2002.07.08 Reprori version add start */
###############################################################################
sub make_tophit_tbl {
    ($query_id,$sbjct_id,$blast_out_file_path,$output_tbl_path) = @_;

    my(@tseqnt_length_tmp, $tseqnt_len);
    my(@qseqnt_length_tmp, $qseqnt_len);
    my(@qntstart, @qntsequence, @qntend);
    my(@tntstart, @tntsequence, @tntend);
    my(@identitiestmp);
    my(@contmp);
    my(@strandtmp);
    my($qnt_start_pos, $qnt_end_pos);
    my($tnt_start_pos, $tnt_end_pos);
    my($qnt_alignment, $tnt_alignment);
    my($query_cnt,$sbjct_cnt);
    my($identities);
    my($con);
    my($tmp);
    my($strand_flag);
    my($hit_count);
    my($score,$tseqnt_evalue);
    my($query_start_pos,$sbjct_start_pos);
    my($ret);

    $ret = "OK";

    #############################################
    ## Blast-output-file search(Alignment-line).
    #############################################
    {
	@tseqnt_length_tmp = $tseqnt_len = ();
	@qseqnt_length_tmp = $qseqnt_len = ();
	@qntstart = @qntsequence = @qntend = ();
	@tntstart = @tntsequence = @tntend = ();
	@identitiestmp = ();
	@strandtmp = ();
	$qnt_start_pos = $qnt_end_pos = ();
	$tnt_start_pos = $tnt_end_pos = ();
	$qnt_alignment = $tnt_alignment = ();
	$score_count = 0;
	$seq_count = 0;
	$query_cnt = $sbjct_cnt = 0;
	$identities = $contmp = $con = $tmp = ();
	$strand_flag = '+';
	$score = $tseqnt_evalue = ();
	$hit_count = 0;

	$time   = time();
	($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($time);
	$Year = $year + 1900;
	$Mon  = $mon + 1;
	$id = sprintf("%d/%02d/%02d/%02d%02d%02d", $Year, $Mon, $mday, $hour, $min, $sec);


	open(NG_FILE, ">>$error_file") || die "No $error_file.";
	# /* 2003.10.20 Bug taisaku add start */
	while(!-f $blast_out_file_path) {
		if (--$retry <= 0) {
			$ret = "Time out bl2seq.exe";
			print NG_FILE "<<<<<<<<<< [$id] QUERY:[$query_id], SBJCT:[$sbjct_id], $ret >>>>>>>>>>\n";
			$error_count++;
			goto EXIT;
		}
#		print STDOUT "SLEEP:$retry\n";
		sleep(1);
	}
	# /* 2003.10.20 Bug taisaku add end */
	open(BLAST_NT,"<$blast_out_file_path") || die "No $blast_out_file_path.";
	open(TOPHIT_TBL, ">>$output_tbl_path") || die "No $output_tbl_path.";
	while($line = <BLAST_NT>){
		chomp($line);
		if($line =~ /\([0-9]+\ letters\)/){
			# Query Length
			@qseqnt_length_tmp = split(/\ +/,$line);
			$qseqnt_len = $qseqnt_length_tmp[1];
			$qseqnt_len =~ s/\(//;
		}
		elsif($line =~ /Length\ \=/){
			# Sbjct Length
			@tseqnt_length_tmp = split(/\ +/,$line);
			$tseqnt_len = $tseqnt_length_tmp[3];
		}
		elsif($line =~ /Score\ \=/){
			if($score_count == 0){
				$line =~ s/\ e\-/\ 1e\-/;
				($score,$tseqnt_evalue) = split(/\,\ /,$line);
				# EVALUE
				$tseqnt_evalue =~ s/Expect\ \=\ //;
			}
			else{
				if($query_cnt > 0 || $sbjct_cnt > 0){
					$qnt_start_pos = shift(@qntstart);	# Query Start
					$qnt_end_pos = pop(@qntend);		# Query End
					$tnt_start_pos = shift(@tntstart);	# Sbjct Start
					$tnt_end_pos = pop(@tntend);		# Sbjct End
					$qnt_alignment = join("", @qntsequence);
					$tnt_alignment = join("", @tntsequence);
				}
				last;
			}
			$score_count++;
		}
		elsif($line =~ /Identities\ \=/){
			# Identities
			@identitiestmp = split(/\ +/,$line);
#			$identities = $identitiestmp[4];
#			$identities =~ s/\(//;
#			$identities =~ s/\)//;
#			$identities =~ s/\%//;
			# Con
			$contmp = $identitiestmp[3];
			($tmp, $con) = split(/\//,$contmp);
			# Identities
			$identities = $tmp / $con;
			$identities = $identities * 100;
			$identities = substr($identities, 0, 5);
		}
		elsif($line =~ /Strand\ \=/){
			# Strand
			@strandtmp = split(/\ +/,$line);
			if($strandtmp[3] eq $strandtmp[5]){
				$strand_flag = '+';
			}
			else{
				$strand_flag = '-';
			}
		}
		elsif($line =~ /^Query\:\ /){
			# Query Start Position & End Position
			@qnt_pstn_tmp = split(/\ +/,$line);
			push(@qntstart,$qnt_pstn_tmp[1]);
			push(@qntsequence,$qnt_pstn_tmp[2]);
			push(@qntend,$qnt_pstn_tmp[3]);
			$query_cnt++;
			$hit_count++;
		}
		elsif($line =~ /^Sbjct\:\ /){
			# Sbjct Start Position & End Position
			@tnt_pstn_tmp = split(/\ +/,$line);
			push(@tntstart,$tnt_pstn_tmp[1]);
			push(@tntsequence,$tnt_pstn_tmp[2]);
			push(@tntend,$tnt_pstn_tmp[3]);
			$sbjct_cnt++;
			$hit_count++;
		}
		elsif(eof(BLAST_NT)){
		    if($query_cnt > 0 || $sbjct_cnt > 0){
			$qnt_start_pos = shift(@qntstart);	# Query Start
			$qnt_end_pos = pop(@qntend);		# Query End
			$tnt_start_pos = shift(@tntstart);	# Sbjct Start
			$tnt_end_pos = pop(@tntend);		# Sbjct End
			$qnt_alignment = join("", @qntsequence);
			$tnt_alignment = join("", @tntsequence);

		    }
		    last;
		}
	}
	close(BLAST_NT);

	if($hit_count == 0){
		$ret = "No hits found";
		print NG_FILE "<<<<<<<<<< [$id] QUERY:[$query_id], SBJCT:[$sbjct_id], $ret >>>>>>>>>>\n";
		print TOPHIT_TBL "$query_id\t$sbjct_id\t$ret\n";
		$error_count++;
		goto EXIT;
	}
	else{
		print TOPHIT_TBL "$query_id\t$sbjct_id\t$qseqnt_len\t$tseqnt_len\t$tseqnt_evalue\t$con\t$identities\t$strand_flag\t$qnt_start_pos\t$qnt_end_pos\t$tnt_start_pos\t$tnt_end_pos\n";
	}
    }
EXIT:
    close(TOPHIT_TBL);
    close(NG_FILE);
    return($ret);
}
## /* 2002.07.08 Reprori version add end */
## /* 2002.07.14 Reprori version add start */
###############################################################################
sub orf_convert {
    ($q_orfline,$s_orfline) = @_;

    my($rtn_q,$rtn_s);
    my($buf);
    my($i);
    my($orf_code);

    $rtn_q = $rtn_s = $buf = $orf_code = ();

    for($i=0; $i<length($q_orfline); $i+=3){
	$buf = substr($q_orfline, $i, 3);
	if(length($buf) == 3){
	    $orf_code = $OrfCode{$buf};
	    if($orf_code eq ""){
		$orf_code = "N";
	    }
#	    $rtn_q .= "(" . $OrfCode{$buf} . ")";
	    $rtn_q .= "(" . $orf_code . ")";
	}
    }
#print STDOUT "rtn_q:$rtn_q($q_orfline)$i\n";
    $buf = ();
    for($i=0; $i<length($s_orfline); $i+=3){
	$buf = substr($s_orfline, $i, 3);
	if(length($buf) == 3){
	    $orf_code = $OrfCode{$buf};
	    if($orf_code eq ""){
		$orf_code = "N";
	    }
#	    $rtn_s .= "(" . $OrfCode{$buf} . ")";
	    $rtn_s .= "(" . $orf_code . ")";
	}
    }
#print STDOUT "rtn_s:$rtn_s($s_orfline)$i\n";

    return($rtn_q, $rtn_s);
}
###############################################################################
sub make_orf_code_table {

    $OrfCode{"TTT"} = "F";
    $OrfCode{"TTC"} = "F";
    $OrfCode{"TTA"} = "L";
    $OrfCode{"TTG"} = "L";
    $OrfCode{"TCT"} = "S";
    $OrfCode{"TCC"} = "S";
    $OrfCode{"TCA"} = "S";
    $OrfCode{"TCG"} = "S";
    $OrfCode{"TAT"} = "Y";
    $OrfCode{"TAC"} = "Y";
    $OrfCode{"TAA"} = "-";
    $OrfCode{"TAG"} = "-";
    $OrfCode{"TGT"} = "C";
    $OrfCode{"TGC"} = "C";
    $OrfCode{"TGA"} = "-";
    $OrfCode{"TGG"} = "W";
    $OrfCode{"CTT"} = "L";
    $OrfCode{"CTC"} = "L";
    $OrfCode{"CTA"} = "L";
    $OrfCode{"CTG"} = "L";
    $OrfCode{"CCT"} = "P";
    $OrfCode{"CCC"} = "P";
    $OrfCode{"CCA"} = "P";
    $OrfCode{"CCG"} = "P";
    $OrfCode{"CAT"} = "H";
    $OrfCode{"CAC"} = "H";
    $OrfCode{"CAA"} = "Q";
    $OrfCode{"CAG"} = "Q";
    $OrfCode{"CGT"} = "R";
    $OrfCode{"CGC"} = "R";
    $OrfCode{"CGA"} = "R";
    $OrfCode{"CGG"} = "R";
    $OrfCode{"ATT"} = "I";
    $OrfCode{"ATC"} = "I";
    $OrfCode{"ATA"} = "I";
    $OrfCode{"ATG"} = "M";
    $OrfCode{"ACT"} = "T";
    $OrfCode{"ACC"} = "T";
    $OrfCode{"ACA"} = "T";
    $OrfCode{"ACG"} = "T";
    $OrfCode{"AAT"} = "N";
    $OrfCode{"AAC"} = "N";
    $OrfCode{"AAA"} = "K";
    $OrfCode{"AAG"} = "K";
    $OrfCode{"AGT"} = "S";
    $OrfCode{"AGC"} = "S";
    $OrfCode{"AGA"} = "R";
    $OrfCode{"AGG"} = "R";
    $OrfCode{"GTT"} = "V";
    $OrfCode{"GTC"} = "V";
    $OrfCode{"GTA"} = "V";
    $OrfCode{"GTG"} = "V";
    $OrfCode{"GCT"} = "A";
    $OrfCode{"GCC"} = "A";
    $OrfCode{"GCA"} = "A";
    $OrfCode{"GCG"} = "A";
    $OrfCode{"GAT"} = "D";
    $OrfCode{"GAC"} = "D";
    $OrfCode{"GAA"} = "E";
    $OrfCode{"GAG"} = "E";
    $OrfCode{"GGT"} = "G";
    $OrfCode{"GGC"} = "G";
    $OrfCode{"GGA"} = "G";
    $OrfCode{"GGG"} = "G";
}
###############################################################################
sub html_query_align_line_make() {
    my($qlt, $qs, $qe, $cnt) = @_;

    my($query_html_line, $c) = ();
    my($start_draw_flg, $end_draw_flg) = 0;
    my($i) = 0;

    for($i=0; $i<length($$qlt); $i++){
	$c = substr($$qlt, $i, 1);
	if($c =~ /\ /){
	    if($$cnt > $qs-1 && $$cnt < $qe-1){
		if($start_draw_flg == 1){
		    $query_html_line .= "</span>";
		    $start_draw_flg = 0;
		    $end_draw_flg = 1;
		}
	    }
	    $query_html_line .= $c;
	}
	elsif($c =~ /\-/){ # 2004.01.21 add by hatano
	    if($$cnt > $qs-1 && $$cnt < $qe-1){
		if($start_draw_flg == 1){
		    $query_html_line .= "</span>";
		    $start_draw_flg = 0;
		    $end_draw_flg = 1;
		}
	    }
	    $query_html_line .= $c;
	}
	else{
	    if($$cnt == $qs-1){
		$query_html_line .= "<span style=\"background-color:#E9CC67\">";
		$query_html_line .= $c;
		$start_draw_flg = 1;
		$end_draw_flg = 0;
	    }
	    elsif($$cnt == $qe-1){
		$query_html_line .= $c;
		$query_html_line .= "</span>";
		$start_draw_flg = 0;
		$end_draw_flg = 1;
	    }
	    elsif($$cnt > $qs-1 && $$cnt < $qe-1){
		if($start_draw_flg == 0){
		    $query_html_line .= "<span style=\"background-color:#E9CC67\">";
		    $start_draw_flg = 1;
		    $end_draw_flg = 0;
		}
		$query_html_line .= $c;
	    }
	    else{
		$query_html_line .= $c;
	    }
	    if($i+1 == length($$qlt)){
		if($start_draw_flg == 1 && $end_draw_flg == 0){
		    $query_html_line .= "</span>";
		}
	    }
	    $$cnt++;
	}
    }

    return($query_html_line);
}
###############################################################################
sub html_sbjct_align_line_make() {
    my($slt, $ss, $se, $cnt) = @_;

    my($sbjct_html_line, $c) = ();
    my($start_draw_flg, $end_draw_flg) = 0;
    my($i) = 0;

    for($i=0; $i<length($$slt); $i++){
	$c = substr($$slt, $i, 1);
	if($c =~ /\ /){
	    if($$cnt > $ss-1 && $$cnt < $se-1){
		if($start_draw_flg == 1){
		    $sbjct_html_line .= "</span>";
		    $start_draw_flg = 0;
		    $end_draw_flg = 1;
		}
	    }
	    $sbjct_html_line .= $c;
	}
	elsif($c =~ /\-/){ # 2004.01.21 add by hatano.
	    if($$cnt > $ss-1 && $$cnt < $se-1){
		if($start_draw_flg == 1){
		    $sbjct_html_line .= "</span>";
		    $start_draw_flg = 0;
		    $end_draw_flg = 1;
		}
	    }
	    $sbjct_html_line .= $c;
	}
	else{
	    if($$cnt == $ss-1){
#		$sbjct_html_line .= "<span style=\"background-color:#C6BAD8\">";
#		$sbjct_html_line .= "<span style=\"background-color:#E4A4EE\">";
		$sbjct_html_line .= "<span style=\"background-color:#F0C9FA\">";
		$sbjct_html_line .= $c;
		$start_draw_flg = 1;
		$end_draw_flg = 0;
	    }
	    elsif($$cnt == $se-1){
		$sbjct_html_line .= $c;
		$sbjct_html_line .= "</span>";
		$start_draw_flg = 0;
		$end_draw_flg = 1;
	    }
	    elsif($$cnt > $ss-1 && $$cnt < $se-1){
		if($start_draw_flg == 0){
#		    $sbjct_html_line .= "<span style=\"background-color:#C6BAD8\">";
#		    $sbjct_html_line .= "<span style=\"background-color:#E4A4EE\">";
		    $sbjct_html_line .= "<span style=\"background-color:#F0C9FA\">";
		    $start_draw_flg = 1;
		    $end_draw_flg = 0;
		}
		$sbjct_html_line .= $c;
	    }
	    else{
		$sbjct_html_line .= $c;
	    }
	    if($i+1 == length($$slt)){
		if($start_draw_flg == 1 && $end_draw_flg == 0){
		    $sbjct_html_line .= "</span>";
		}
	    }
	    $$cnt++;
	}
    }

    return($sbjct_html_line);
}
## /* 2002.07.14 Reprori version add end */
## /* 2002.10.01 Reprori version add start */
###############################################################################
sub EN_search {
    ($fasta_path,$startp) = @_;

    my($rtn_pos);
    my($work, $buf, $diff_sz, $buf_len, $ORF_info);
    my($i);
    my($line);

    $rtn_pos = $diff_sz = $buf_len = 0;
    $work = $buf = $ORF_info = $line = ();

    open(FASTA,"<$fasta_path") || die "No $fasta_path.";
    while(<FASTA>){
	chomp($_);
	if($_ =~ /^\>/) {
	    next;
	}
	$line .= $_;
    }
    close(FASTA);
    $line = uc($line); # 2004.01.19 add by hatano.

    $diff_sz = length($line) - ($startp - 1);
    $work = substr($line, $startp-1, $diff_sz);
    $work2 = $work;

    $rtn_pos = $startp - 1;

#print STDOUT "line:$line\n";
    for($i=0; $i<=$diff_sz; $i+=3){
	$buf = substr($work, $i, 3);
	$buf_len = length($buf);
	if($buf_len == 3){
	    $ORF_info = "(" . $OrfCode{$buf} . ")";
#print STDOUT "$buf<$OrfCode{$buf}>";
	    $rtn_pos = $rtn_pos + $buf_len;
	    if($ORF_info =~ /\-/){
		last;
	    }
	}
	else{
	    $rtn_pos = $rtn_pos + $buf_len;
	    last;
	}
    }

    return($rtn_pos);
}
### 2005.09.22 add start. version 2.3.4.
###############################################################################
sub get_mutation_info{
	my($q_id, $qline, $s_id, $sline) = @_;

	my($rtn_qline, $rtn_sline) = ();
	my($rtn_mutation_info) = ();
	my($count1) = 0;
	my($count2) = 0;
	my($space1, $space2) = ();
	my($qstart, $sstart) = ();
	my($q_orf_start) = 0;
	my($s_orf_start) = 0;
	my($q_orf_end) = 0;
	my($s_orf_end) = 0;
	my($orf_flg) = "OFF";
	my($ins_del_data) = ();
	my($q_subst, $s_subst) = ();
	my($subst_cnt) = ();
	my($indel_cnt) = ();

	($count1, $space1) = &get_start_space($qline);
	($count2, $space2) = &get_start_space($sline);
	if($count1 == 0 && $count2 != 0){
		$rtn_qline = substr($qline, $count2);
		$rtn_sline = substr($sline, $count2);
	}
	elsif($count1 != 0 && $count2 == 0){
		$rtn_qline = substr($qline, $count1);
		$rtn_sline = substr($sline, $count1);
	}
	elsif($count1 == 0 && $count2 == 0){
		$rtn_qline = $qline;
		$rtn_sline = $sline;
	}
	$qstart = $count2;
	$sstart = $count1;

	($count1, $space1) = &get_end_space($rtn_qline);
	($count2, $space2) = &get_end_space($rtn_sline);
	if($count1 == 0 && $count2 != 0){
		$rtn_qline = substr($rtn_qline, 0, length($rtn_qline)-$count2);
		$rtn_sline = substr($rtn_sline, 0, length($rtn_sline)-$count2);
	}
	elsif($count1 != 0 && $count2 == 0){
		$rtn_qline = substr($rtn_qline, 0, length($rtn_qline)-$count1);
		$rtn_sline = substr($rtn_sline, 0, length($rtn_sline)-$count1);
	}

	my $qcnt=0;
	my $scnt=0;
	for(my $i=0; $i<length($rtn_qline); $i++){
		my $q = substr($rtn_qline, $i, 1);
		my $s = substr($rtn_sline, $i, 1);

		if($q =~ /\s/ || $q =~ /\-/){
			if($orf_flg eq "OFF"){
				$q_orf_start = $qstart + $qcnt;
				$s_orf_start = $sstart + $scnt + 1;
			}
			elsif($orf_flg eq "SUBST"){
				$q_orf_end = $qstart + $qcnt;
				$s_orf_end = $sstart + $scnt;
				if($subst_cnt eq '1'){
					$rtn_mutation_info .= $q_id . "\t" . $q_orf_start . "\t" . 
								$s_id . "\t" . $s_orf_start . "\t" . $s_subst . "->" . $q_subst . "\$";
				}
				else{
					$rtn_mutation_info .= $q_id . "\t" . $q_orf_start . ".." . $q_orf_end . "\t" . 
								$s_id . "\t" . $s_orf_start . ".." . $s_orf_end . "\t" . $s_subst . "->" . $q_subst . "\$";
				}
				$q_orf_start = $qstart + $qcnt;
				$s_orf_start = $sstart + $scnt;
			}
			$orf_flg = "QUERY";
			$ins_del_data .= $s;
			$scnt++;
			$subst_cnt = ();
			$q_subst = ();
			$s_subst = ();
			$indel_cnt++;
		}
		elsif($s =~ /\s/ || $s =~ /\-/){
			if($orf_flg eq "OFF"){
				$q_orf_start = $qstart + $qcnt + 1;
				$s_orf_start = $sstart + $scnt;
			}
			elsif($orf_flg eq "SUBST"){
				$q_orf_end = $qstart + $qcnt;
				$s_orf_end = $sstart + $scnt;
				if($subst_cnt eq '1'){
					$rtn_mutation_info .= $q_id . "\t" . $q_orf_start . "\t" . 
								$s_id . "\t" . $s_orf_start . "\t" . $s_subst . "->" . $q_subst . "\$";
				}
				else{
					$rtn_mutation_info .= $q_id . "\t" . $q_orf_start . ".." . $q_orf_end . "\t" . 
								$s_id . "\t" . $s_orf_start . ".." . $s_orf_end . "\t" . $s_subst . "->" . $q_subst . "\$";
				}
				$q_orf_start = $qstart + $qcnt;
				$s_orf_start = $sstart + $scnt;
			}
			$orf_flg = "SBJCT";
			$ins_del_data .= $q;
			$qcnt++;
			$subst_cnt = ();
			$q_subst = ();
			$s_subst = ();
			$indel_cnt++;
		}
		elsif($q !~ $s){
			if($orf_flg eq "OFF"){
				$q_orf_start = $qstart + $qcnt + 1;
				$s_orf_start = $sstart + $scnt + 1;
			}
			elsif($orf_flg eq "QUERY"){
				$q_orf_end = $q_orf_start + 1;
				$s_orf_end = $sstart + $scnt;
				if($indel_cnt eq '1'){
					$rtn_mutation_info .= $q_id . "\t" . $q_orf_start . "\t" . 
							$s_id . "\t" . $s_orf_start . "\t" . $ins_del_data . "->\$";
				}
				else{
					$rtn_mutation_info .= $q_id . "\t" . $q_orf_start . "\t" . 
							$s_id . "\t" . $s_orf_start . ".." . $s_orf_end . "\t" . $ins_del_data . "->\$";
				}
				$q_orf_start = $qstart + $qcnt + 1;
				$s_orf_start = $sstart + $scnt + 1;
			}
			elsif($orf_flg eq "SBJCT"){
				$q_orf_end = $qstart + $qcnt;
				$s_orf_end = $s_orf_start + 1;
				if($indel_cnt eq '1'){
					$rtn_mutation_info .= $q_id . "\t" . $q_orf_start . "\t" . 
							$s_id . "\t" . $s_orf_start . "\t" . "->" . $ins_del_data . "\$";
				}
				else{
					$rtn_mutation_info .= $q_id . "\t" . $q_orf_start . ".." . $q_orf_end . "\t" . 
							$s_id . "\t" . $s_orf_start . "\t" . "->" . $ins_del_data . "\$";
				}
				$q_orf_start = $qstart + $qcnt + 1;
				$s_orf_start = $sstart + $scnt + 1;
			}
			$orf_flg = "SUBST";
			$q_subst .= $q;
			$s_subst .= $s;
			$qcnt++;
			$scnt++;
			$ins_del_data = ();
			$subst_cnt++;
			$indel_cnt = ();
		}
		else{
			if($orf_flg eq "QUERY"){
				$q_orf_end = $q_orf_start + 1;
				$s_orf_end = $sstart + $scnt;
				if($indel_cnt eq '1'){
					$rtn_mutation_info .= $q_id . "\t" . $q_orf_start . "\t" . 
							$s_id . "\t" . $s_orf_start . "\t" . $ins_del_data . "->\$";
				}
				else{
					$rtn_mutation_info .= $q_id . "\t" . $q_orf_start . "\t" . 
							$s_id . "\t" . $s_orf_start . ".." . $s_orf_end . "\t" . $ins_del_data . "->\$";
				}
			}
			elsif($orf_flg eq "SBJCT"){
				$q_orf_end = $qstart + $qcnt;
				$s_orf_end = $s_orf_start + 1;
				if($indel_cnt eq '1'){
					$rtn_mutation_info .= $q_id . "\t" . $q_orf_start . "\t" . 
							$s_id . "\t" . $s_orf_start . "\t" . "->" . $ins_del_data . "\$";
				}
				else{
					$rtn_mutation_info .= $q_id . "\t" . $q_orf_start . ".." . $q_orf_end . "\t" . 
							$s_id . "\t" . $s_orf_start . "\t" . "->" . $ins_del_data . "\$";
				}
			}
			elsif($orf_flg eq "SUBST"){
				$q_orf_end = $qstart + $qcnt;
				$s_orf_end = $sstart + $scnt;
				if($subst_cnt eq '1'){
					$rtn_mutation_info .= $q_id . "\t" . $q_orf_start . "\t" . 
								$s_id . "\t" . $s_orf_start . "\t" . $s_subst . "->" . $q_subst . "\$";
				}
				else{
					$rtn_mutation_info .= $q_id . "\t" . $q_orf_start . ".." . $q_orf_end . "\t" . 
								$s_id . "\t" . $s_orf_start . ".." . $s_orf_end . "\t" . $s_subst . "->" . $q_subst . "\$";
				}
			}
			$orf_flg = "OFF";
			$qcnt++;
			$scnt++;
			$ins_del_data = ();
			$subst_cnt = ();
			$q_subst = ();
			$s_subst = ();
			$indel_cnt = ();
		}
	}

	chop($rtn_mutation_info);
	return($rtn_mutation_info);
}
sub get_start_space{
	my($line) = @_;

	my($space) = ();
	my($count) = 0;

	if($line =~ m/^\s+/){
		for(my $i=0; $i<length($line); $i++){
			my $c = substr($line, $i, 1);
			if($c =~ /\s/){
				$space .= $c;
				$count++;
			}
			else{ last; }
		}
	}

	return($count, $space);
}
sub get_end_space{
	my($line) = @_;

	my($space) = ();
	my($count) = 0;

	if($line =~ m/\s+$/){
		for(my $i=length($line);;$i--){
			my $c = substr($line, $i-1, 1);
			if($c =~ /\s/){
				$space .= $c;
				$count++;
			}
			else{ last; }
		}
	}

	return($count, $space);
}
### 2005.09.22 add end. version 2.3.4.
## /* 2002.10.01 Reprori version add end */
#---
